/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.tasks;

import java.nio.file.Path;
import java.util.StringJoiner;
import java.util.function.UnaryOperator;
import javax.sql.DataSource;
import org.apache.baremaps.geopackage.GeoPackageDataStore;
import org.apache.baremaps.openstreetmap.function.ProjectionTransformer;
import org.apache.baremaps.postgres.store.PostgresDataStore;
import org.apache.baremaps.store.DataTable;
import org.apache.baremaps.store.DataTableGeometryMapper;
import org.apache.baremaps.store.DataTableMapper;
import org.apache.baremaps.workflow.Task;
import org.apache.baremaps.workflow.WorkflowContext;
import org.apache.baremaps.workflow.WorkflowException;
import org.locationtech.jts.geom.util.GeometryTransformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportGeoPackage
implements Task {
    private static final Logger logger = LoggerFactory.getLogger(ImportGeoPackage.class);
    private Path file;
    private Integer fileSrid;
    private Object database;
    private Integer databaseSrid;

    public ImportGeoPackage() {
    }

    public ImportGeoPackage(Path file, Integer fileSrid, Object database, Integer databaseSrid) {
        this.file = file;
        this.fileSrid = fileSrid;
        this.database = database;
        this.databaseSrid = databaseSrid;
    }

    @Override
    public void execute(WorkflowContext context) throws Exception {
        Path path = this.file.toAbsolutePath();
        try (GeoPackageDataStore geoPackageDataStore = new GeoPackageDataStore(path);){
            DataSource dataSource = context.getDataSource(this.database);
            PostgresDataStore postgresDataStore = new PostgresDataStore(dataSource);
            for (String name : geoPackageDataStore.list()) {
                DataTable geoPackageTable = geoPackageDataStore.get(name);
                ProjectionTransformer projectionTransformer = new ProjectionTransformer(this.fileSrid.intValue(), this.databaseSrid.intValue());
                DataTableGeometryMapper rowTransformer = new DataTableGeometryMapper(geoPackageTable, (GeometryTransformer)projectionTransformer);
                DataTableMapper transformedDataTable = new DataTableMapper(geoPackageDataStore.get(name), (UnaryOperator)rowTransformer);
                postgresDataStore.add((DataTable)transformedDataTable);
            }
        }
        catch (Exception e) {
            throw new WorkflowException(e);
        }
    }

    public String toString() {
        return new StringJoiner(", ", ImportGeoPackage.class.getSimpleName() + "[", "]").add("file=" + String.valueOf(this.file)).add("fileSrid=" + this.fileSrid).add("database=" + String.valueOf(this.database)).add("databaseSrid=" + this.databaseSrid).toString();
    }
}

