/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.tilestore;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.math.IntMath;
import com.google.common.math.LongMath;
import java.util.Iterator;
import java.util.List;
import java.util.StringJoiner;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import org.apache.baremaps.tilestore.TileCoordIterator;
import org.locationtech.jts.geom.Envelope;

public final class TileCoord
implements Comparable<TileCoord> {
    private static final double EPSILON = 1.0E-7;
    private static final int[] sides = IntStream.range(0, 30).map(i -> IntMath.pow((int)2, (int)i)).toArray();
    private static final long[] squares = LongStream.range(0L, 30L).map(i -> LongMath.pow((long)IntMath.pow((int)2, (int)((int)i)), (int)2)).toArray();
    private static final long[] offsets = LongStream.range(0L, 30L).map(i -> LongStream.range(0L, i).map(j -> LongMath.pow((long)IntMath.pow((int)2, (int)((int)j)), (int)2)).sum()).toArray();
    private final int x;
    private final int y;
    private final int z;

    public TileCoord(int index) {
        int zoom = 0;
        long offset = 0L;
        long count = 1L;
        while ((long)index >= offset + count) {
            offset += count;
            count = squares[++zoom];
        }
        long position = (long)index - offset;
        this.x = (int)position % sides[zoom];
        this.y = (int)position / sides[zoom];
        this.z = zoom;
    }

    public TileCoord(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static Iterator<TileCoord> iterator(Envelope envelope, int minzoom, int maxzoom) {
        return new TileCoordIterator(envelope, minzoom, maxzoom);
    }

    public static List<TileCoord> list(Envelope envelope, int minzoom, int maxzoom) {
        return ImmutableList.copyOf(TileCoord.iterator(envelope, minzoom, maxzoom));
    }

    public static long count(Envelope envelope, int minzoom, int maxzoom) {
        int count = 0;
        for (int zoom = minzoom; zoom <= maxzoom; ++zoom) {
            TileCoord min = TileCoord.min(envelope, zoom);
            TileCoord max = TileCoord.max(envelope, zoom);
            count += (max.x() - min.x() + 1) * (max.y() - min.y() + 1);
        }
        return count;
    }

    public static TileCoord fromLonLat(double lon, double lat, int z) {
        return new TileCoord((int)((lon + 180.0) / 360.0 * (double)(1 << z)), (int)((1.0 - Math.log(Math.tan(Math.toRadians(lat)) + 1.0 / Math.cos(Math.toRadians(lat))) / Math.PI) / 2.0 * (double)(1 << z)), z);
    }

    public long index() {
        long x = this.x;
        long y = this.y;
        long offset = offsets[this.z];
        long position = x + y * (long)sides[this.z];
        return offset + position;
    }

    public int x() {
        return this.x;
    }

    public int y() {
        return this.y;
    }

    public int z() {
        return this.z;
    }

    public TileCoord parent() {
        return new TileCoord(this.x / 2, this.y / 2, this.z - 1);
    }

    public TileCoord left() {
        return new TileCoord(this.x - 1, this.y, this.z);
    }

    public TileCoord right() {
        return new TileCoord(this.x + 1, this.y, this.z);
    }

    public TileCoord top() {
        return new TileCoord(this.x, this.y - 1, this.z);
    }

    public TileCoord bottom() {
        return new TileCoord(this.x, this.y + 1, this.z);
    }

    public Envelope envelope() {
        double x1 = TileCoord.tile2lon(this.x, this.z);
        double x2 = TileCoord.tile2lon(this.x + 1, this.z);
        double y1 = TileCoord.tile2lat(this.y + 1, this.z);
        double y2 = TileCoord.tile2lat(this.y, this.z);
        return new Envelope(x1, x2, y1, y2);
    }

    public static double tile2lon(int x, int z) {
        return (double)x / Math.pow(2.0, z) * 360.0 - 180.0;
    }

    public static double tile2lat(int y, int z) {
        double n = Math.PI - Math.PI * 2 * (double)y / Math.pow(2.0, z);
        return Math.toDegrees(Math.atan(Math.sinh(n)));
    }

    public static TileCoord min(Envelope envelope, int zoom) {
        return TileCoord.fromLonLat(envelope.getMinX(), envelope.getMaxY(), zoom);
    }

    public static TileCoord max(Envelope envelope, int zoom) {
        return TileCoord.fromLonLat(envelope.getMaxX() - 1.0E-7, envelope.getMinY() + 1.0E-7, zoom);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TileCoord that = (TileCoord)o;
        return this.x == that.x && this.y == that.y && this.z == that.z;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.x, this.y, this.z});
    }

    public String toString() {
        return new StringJoiner(", ", TileCoord.class.getSimpleName() + "[", "]").add("x=" + this.x).add("y=" + this.y).add("z=" + this.z).toString();
    }

    @Override
    public int compareTo(TileCoord that) {
        return Long.compare(this.index(), that.index());
    }
}

