/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.geotiff.inflater;

import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import org.apache.sis.image.DataType;
import org.apache.sis.io.stream.ChannelDataInput;
import org.apache.sis.storage.UnsupportedEncodingException;
import org.apache.sis.storage.geotiff.inflater.Inflater;
import org.apache.sis.util.resources.Errors;

abstract class CopyFromBytes
extends Inflater {
    private long streamPosition;
    private boolean positionNeedsRefresh;
    private final int bytesPerElement;
    private final int pixelsPerElement;

    private CopyFromBytes(ChannelDataInput input, int chunksPerRow, int samplesPerChunk, int[] skipAfterChunks, int pixelsPerElement, int bytesPerElement) {
        super(input, chunksPerRow, samplesPerChunk, skipAfterChunks, pixelsPerElement, input.buffer.capacity() / bytesPerElement);
        this.bytesPerElement = bytesPerElement;
        this.pixelsPerElement = pixelsPerElement;
    }

    static CopyFromBytes create(ChannelDataInput input, DataType dataType, int chunksPerRow, int samplesPerChunk, int[] skipAfterChunks, int pixelsPerElement) throws UnsupportedEncodingException {
        switch (dataType) {
            case USHORT: 
            case SHORT: {
                return new Shorts(input, chunksPerRow, samplesPerChunk, skipAfterChunks, pixelsPerElement);
            }
            case BYTE: {
                return new Bytes(input, chunksPerRow, samplesPerChunk, skipAfterChunks, pixelsPerElement);
            }
            case INT: {
                return new Ints(input, chunksPerRow, samplesPerChunk, skipAfterChunks, pixelsPerElement);
            }
            case FLOAT: {
                return new Floats(input, chunksPerRow, samplesPerChunk, skipAfterChunks, pixelsPerElement);
            }
            case DOUBLE: {
                return new Doubles(input, chunksPerRow, samplesPerChunk, skipAfterChunks, pixelsPerElement);
            }
        }
        throw new UnsupportedEncodingException(Errors.format((short)163, (Object)dataType));
    }

    @Override
    public void setInputOutput(long start, long byteCount, Buffer bank) throws IOException {
        super.setInputOutput(start, byteCount, bank);
        this.streamPosition = start;
        this.positionNeedsRefresh = false;
    }

    @Override
    public void uncompressRow() throws IOException {
        if (!this.positionNeedsRefresh) {
            this.positionNeedsRefresh = true;
            this.input.seek(this.streamPosition);
        }
    }

    @Override
    public final void skip(long n) throws IOException {
        if (n != 0L) {
            if (this.positionNeedsRefresh) {
                this.positionNeedsRefresh = false;
                this.streamPosition = this.input.getStreamPosition();
            }
            boolean r = n % (long)this.pixelsPerElement > 0L;
            n /= (long)this.pixelsPerElement;
            if (r) {
                ++n;
            }
            this.streamPosition = Math.addExact(this.streamPosition, n *= (long)this.bytesPerElement);
        }
    }

    final int skipAfterChunk(int skipIndex) throws IOException {
        int n = this.skipAfterChunks[skipIndex] * this.bytesPerElement;
        while (n != 0) {
            int p = this.input.buffer.position();
            int s = Math.min(p + n, this.input.buffer.limit());
            this.input.buffer.position(s);
            if ((n -= s - p) == 0) break;
            this.input.ensureBufferContains(this.bytesPerElement);
        }
        return ++skipIndex < this.skipAfterChunks.length ? skipIndex : 0;
    }

    private static final class Shorts
    extends CopyFromBytes {
        private ShortBuffer bank;

        Shorts(ChannelDataInput input, int count, int size, int[] skips, int divisor) {
            super(input, count, size, skips, divisor, 2);
        }

        @Override
        public void setInputOutput(long start, long byteCount, Buffer bank) throws IOException {
            super.setInputOutput(start, byteCount, bank);
            this.bank = (ShortBuffer)bank;
        }

        @Override
        public void uncompressRow() throws IOException {
            super.uncompressRow();
            int skipIndex = 0;
            ByteBuffer source = this.input.buffer;
            int i = this.chunksPerRow;
            while (--i > 0) {
                int n = this.elementsPerChunk;
                this.input.ensureBufferContains(n * 2);
                do {
                    this.bank.put(source.getShort());
                } while (--n != 0);
                if (this.skipAfterChunks == null) continue;
                skipIndex = this.skipAfterChunk(skipIndex);
            }
            int n = this.elementsPerChunk * 2;
            this.input.ensureBufferContains(n);
            this.bank.put(source.asShortBuffer().limit(this.elementsPerChunk));
            source.position(source.position() + n);
        }
    }

    private static final class Bytes
    extends CopyFromBytes {
        private ByteBuffer bank;

        Bytes(ChannelDataInput input, int count, int size, int[] skips, int divisor) {
            super(input, count, size, skips, divisor, 1);
        }

        @Override
        public void setInputOutput(long start, long byteCount, Buffer bank) throws IOException {
            super.setInputOutput(start, byteCount, bank);
            this.bank = (ByteBuffer)bank;
        }

        @Override
        public void uncompressRow() throws IOException {
            super.uncompressRow();
            int skipIndex = 0;
            ByteBuffer source = this.input.buffer;
            int i = this.chunksPerRow;
            while (--i > 0) {
                int n = this.elementsPerChunk;
                this.input.ensureBufferContains(n);
                do {
                    this.bank.put(source.get());
                } while (--n != 0);
                if (this.skipAfterChunks == null) continue;
                skipIndex = this.skipAfterChunk(skipIndex);
            }
            this.input.ensureBufferContains(this.elementsPerChunk);
            int limit = source.limit();
            source.limit(source.position() + this.elementsPerChunk);
            this.bank.put(source);
            source.limit(limit);
        }
    }

    private static final class Ints
    extends CopyFromBytes {
        private IntBuffer bank;

        Ints(ChannelDataInput input, int count, int size, int[] skips, int divisor) {
            super(input, count, size, skips, divisor, 4);
        }

        @Override
        public void setInputOutput(long start, long byteCount, Buffer bank) throws IOException {
            super.setInputOutput(start, byteCount, bank);
            this.bank = (IntBuffer)bank;
        }

        @Override
        public void uncompressRow() throws IOException {
            super.uncompressRow();
            int skipIndex = 0;
            ByteBuffer source = this.input.buffer;
            int i = this.chunksPerRow;
            while (--i > 0) {
                int n = this.elementsPerChunk;
                this.input.ensureBufferContains(n * 4);
                do {
                    this.bank.put(source.getInt());
                } while (--n != 0);
                if (this.skipAfterChunks == null) continue;
                skipIndex = this.skipAfterChunk(skipIndex);
            }
            int n = this.elementsPerChunk * 4;
            this.input.ensureBufferContains(n);
            this.bank.put(source.asIntBuffer().limit(this.elementsPerChunk));
            source.position(source.position() + n);
        }
    }

    private static final class Floats
    extends CopyFromBytes {
        private FloatBuffer bank;

        Floats(ChannelDataInput input, int count, int size, int[] skips, int divisor) {
            super(input, count, size, skips, divisor, 4);
        }

        @Override
        public void setInputOutput(long start, long byteCount, Buffer bank) throws IOException {
            super.setInputOutput(start, byteCount, bank);
            this.bank = (FloatBuffer)bank;
        }

        @Override
        public void uncompressRow() throws IOException {
            super.uncompressRow();
            int skipIndex = 0;
            ByteBuffer source = this.input.buffer;
            int i = this.chunksPerRow;
            while (--i > 0) {
                int n = this.elementsPerChunk;
                this.input.ensureBufferContains(n * 4);
                do {
                    this.bank.put(source.getFloat());
                } while (--n != 0);
                if (this.skipAfterChunks == null) continue;
                skipIndex = this.skipAfterChunk(skipIndex);
            }
            int n = this.elementsPerChunk * 4;
            this.input.ensureBufferContains(n);
            this.bank.put(source.asFloatBuffer().limit(this.elementsPerChunk));
            source.position(source.position() + n);
        }
    }

    private static final class Doubles
    extends CopyFromBytes {
        private DoubleBuffer bank;

        Doubles(ChannelDataInput input, int count, int size, int[] skips, int divisor) {
            super(input, count, size, skips, divisor, 8);
        }

        @Override
        public void setInputOutput(long start, long byteCount, Buffer bank) throws IOException {
            super.setInputOutput(start, byteCount, bank);
            this.bank = (DoubleBuffer)bank;
        }

        @Override
        public void uncompressRow() throws IOException {
            super.uncompressRow();
            int skipIndex = 0;
            ByteBuffer source = this.input.buffer;
            int i = this.chunksPerRow;
            while (--i > 0) {
                int n = this.elementsPerChunk;
                this.input.ensureBufferContains(n * 8);
                do {
                    this.bank.put(source.getDouble());
                } while (--n != 0);
                if (this.skipAfterChunks == null) continue;
                skipIndex = this.skipAfterChunk(skipIndex);
            }
            int n = this.elementsPerChunk * 8;
            this.input.ensureBufferContains(n);
            this.bank.put(source.asDoubleBuffer().limit(this.elementsPerChunk));
            source.position(source.position() + n);
        }
    }
}

