/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.geoparquet;

import java.util.ArrayList;
import java.util.List;
import org.apache.baremaps.geoparquet.GeoParquetException;
import org.apache.baremaps.geoparquet.GeoParquetMetadata;
import org.apache.baremaps.geoparquet.GeoParquetSchema;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.schema.GroupType;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKBReader;
import org.locationtech.jts.io.WKBWriter;

public class GeoParquetGroup {
    private final GroupType parquetSchema;
    private final GeoParquetMetadata geoParquetMetadata;
    private final GeoParquetSchema geoParquetSchema;
    private final Object[] data;

    public GeoParquetGroup(GroupType parquetSchema, GeoParquetMetadata geoParquetMetadata, GeoParquetSchema geoParquetSchema) {
        this.parquetSchema = parquetSchema;
        this.geoParquetMetadata = geoParquetMetadata;
        this.geoParquetSchema = geoParquetSchema;
        this.data = new Object[parquetSchema.getFields().size()];
        for (int i = 0; i < parquetSchema.getFieldCount(); ++i) {
            GeoParquetSchema.Field field = geoParquetSchema.fields().get(i);
            this.data[i] = field.cardinality() == GeoParquetSchema.Cardinality.REPEATED ? new ArrayList() : null;
        }
    }

    public GeoParquetGroup addGroup(int fieldIndex) {
        GeoParquetGroup group = this.createGroup(fieldIndex);
        this.add(fieldIndex, group);
        return group;
    }

    public GeoParquetGroup addGroup(String field) {
        return this.addGroup(this.getParquetSchema().getFieldIndex(field));
    }

    private GeoParquetGroup createGroup(int fieldIndex) {
        GeoParquetSchema.Field field = this.geoParquetSchema.fields().get(fieldIndex);
        if (field instanceof GeoParquetSchema.EnvelopeField) {
            GeoParquetSchema.EnvelopeField envelopeField = (GeoParquetSchema.EnvelopeField)field;
            return new GeoParquetGroup(this.parquetSchema.getType(fieldIndex).asGroupType(), this.geoParquetMetadata, envelopeField.schema());
        }
        if (field instanceof GeoParquetSchema.GroupField) {
            GeoParquetSchema.GroupField groupField = (GeoParquetSchema.GroupField)field;
            return new GeoParquetGroup(this.parquetSchema.getType(fieldIndex).asGroupType(), this.geoParquetMetadata, groupField.schema());
        }
        throw new GeoParquetException("Field at index " + fieldIndex + " is not a group");
    }

    public GeoParquetGroup getGroup(int fieldIndex, int index) {
        return (GeoParquetGroup)this.getValue(fieldIndex, index);
    }

    public GeoParquetGroup getGroup(String field, int index) {
        return this.getGroup(this.getParquetSchema().getFieldIndex(field), index);
    }

    public int getFieldRepetitionCount(int fieldIndex) {
        Object value = this.data[fieldIndex];
        if (value instanceof List) {
            List list = (List)value;
            return list.size();
        }
        return value == null ? 0 : 1;
    }

    Object getValue(int fieldIndex, int index) {
        Object value = this.data[fieldIndex];
        if (value instanceof List) {
            List list = (List)value;
            return list.get(index);
        }
        if (index == 0) {
            return value;
        }
        throw this.createGeoParquetException(fieldIndex, "element number " + index);
    }

    private Object getValue(int fieldIndex) {
        GeoParquetSchema.Field field = this.geoParquetSchema.fields().get(fieldIndex);
        if (field.cardinality() == GeoParquetSchema.Cardinality.REPEATED) {
            throw new IllegalStateException("Field " + fieldIndex + " (" + field.name() + ") is repeated. Use getValues() instead.");
        }
        return this.data[fieldIndex];
    }

    public List<Object> getValues(int fieldIndex) {
        GeoParquetSchema.Field field = this.geoParquetSchema.fields().get(fieldIndex);
        if (field.cardinality() != GeoParquetSchema.Cardinality.REPEATED) {
            return List.of(this.getValue(fieldIndex));
        }
        return (List)this.data[fieldIndex];
    }

    private void addValue(int fieldIndex, Object value) {
        Object currentValue = this.data[fieldIndex];
        if (currentValue instanceof List) {
            ((List)currentValue).add(value);
        } else {
            this.data[fieldIndex] = value;
        }
    }

    public void add(int fieldIndex, int value) {
        this.addValue(fieldIndex, value);
    }

    public void add(int fieldIndex, long value) {
        this.addValue(fieldIndex, value);
    }

    public void add(int fieldIndex, String value) {
        this.addValue(fieldIndex, Binary.fromString((String)value));
    }

    public void add(int fieldIndex, boolean value) {
        this.addValue(fieldIndex, value);
    }

    public void add(int fieldIndex, Binary value) {
        this.addValue(fieldIndex, value);
    }

    public void add(int fieldIndex, float value) {
        this.addValue(fieldIndex, Float.valueOf(value));
    }

    public void add(int fieldIndex, double value) {
        this.addValue(fieldIndex, value);
    }

    public void add(int fieldIndex, GeoParquetGroup value) {
        this.addValue(fieldIndex, value);
    }

    public void add(int fieldIndex, Geometry geometry) {
        byte[] bytes = new WKBWriter().write(geometry);
        this.add(fieldIndex, Binary.fromConstantByteArray((byte[])bytes));
    }

    public void add(String field, int value) {
        this.add(this.getParquetSchema().getFieldIndex(field), value);
    }

    public void add(String field, long value) {
        this.add(this.getParquetSchema().getFieldIndex(field), value);
    }

    public void add(String field, float value) {
        this.add(this.getParquetSchema().getFieldIndex(field), value);
    }

    public void add(String field, double value) {
        this.add(this.getParquetSchema().getFieldIndex(field), value);
    }

    public void add(String field, String value) {
        this.add(this.getParquetSchema().getFieldIndex(field), value);
    }

    public void add(String field, boolean value) {
        this.add(this.getParquetSchema().getFieldIndex(field), value);
    }

    public void add(String field, Binary value) {
        this.add(this.getParquetSchema().getFieldIndex(field), value);
    }

    public void add(String field, GeoParquetGroup value) {
        this.add(this.getParquetSchema().getFieldIndex(field), value);
    }

    public void add(String field, Geometry geometry) {
        this.add(this.getParquetSchema().getFieldIndex(field), geometry);
    }

    private GeoParquetException createGeoParquetException(int fieldIndex, String elementText) {
        String msg = String.format("Not found %d (%s) %s in group%n%s", fieldIndex, this.parquetSchema.getFieldName(fieldIndex), elementText, this);
        return new GeoParquetException(msg);
    }

    public GeoParquetSchema getGeoParquetSchema() {
        return this.geoParquetSchema;
    }

    public GroupType getParquetSchema() {
        return this.parquetSchema;
    }

    public GeoParquetMetadata getGeoParquetMetadata() {
        return this.geoParquetMetadata;
    }

    public String getStringValue(int fieldIndex, int index) {
        return this.getBinaryValue(fieldIndex, index).toStringUsingUTF8();
    }

    public Binary getBinaryValue(int fieldIndex, int index) {
        return (Binary)this.getValue(fieldIndex, index);
    }

    public Geometry getGeometry(int fieldIndex, int index) {
        byte[] bytes = this.getBinaryValue(fieldIndex, index).getBytes();
        try {
            return new WKBReader().read(bytes);
        }
        catch (ParseException e) {
            throw new GeoParquetException("WKBReader failed to parse", e);
        }
    }

    public Binary getBinaryValue(int fieldIndex) {
        return (Binary)this.getValue(fieldIndex);
    }

    public Boolean getBooleanValue(int fieldIndex) {
        return (Boolean)this.getValue(fieldIndex);
    }

    public Double getDoubleValue(int fieldIndex) {
        return (Double)this.getValue(fieldIndex);
    }

    public Float getFloatValue(int fieldIndex) {
        return (Float)this.getValue(fieldIndex);
    }

    public Integer getIntegerValue(int fieldIndex) {
        return (Integer)this.getValue(fieldIndex);
    }

    public Long getLongValue(int fieldIndex) {
        return (Long)this.getValue(fieldIndex);
    }

    public String getStringValue(int fieldIndex) {
        return this.getStringValue(fieldIndex, 0);
    }

    public Geometry getGeometryValue(int fieldIndex) {
        return this.getGeometry(fieldIndex, 0);
    }

    public GeoParquetGroup getGroupValue(int fieldIndex) {
        return (GeoParquetGroup)this.getValue(fieldIndex);
    }

    private <T> List<T> getValuesOfType(int fieldIndex, Class<T> clazz) {
        return this.getValues(fieldIndex).stream().map(clazz::cast).toList();
    }

    public List<Binary> getBinaryValues(int fieldIndex) {
        return this.getValuesOfType(fieldIndex, Binary.class);
    }

    public List<Boolean> getBooleanValues(int fieldIndex) {
        return this.getValuesOfType(fieldIndex, Boolean.class);
    }

    public List<Double> getDoubleValues(int fieldIndex) {
        return this.getValuesOfType(fieldIndex, Double.class);
    }

    public List<Float> getFloatValues(int fieldIndex) {
        return this.getValuesOfType(fieldIndex, Float.class);
    }

    public List<Integer> getIntegerValues(int fieldIndex) {
        return this.getValuesOfType(fieldIndex, Integer.class);
    }

    public List<Long> getLongValues(int fieldIndex) {
        return this.getValuesOfType(fieldIndex, Long.class);
    }

    public List<String> getStringValues(int fieldIndex) {
        return this.getValues(fieldIndex).stream().map(value -> ((Binary)value).toStringUsingUTF8()).toList();
    }

    public List<Geometry> getGeometryValues(int fieldIndex) {
        return this.getValues(fieldIndex).stream().map(value -> {
            try {
                return new WKBReader().read(((Binary)value).getBytes());
            }
            catch (ParseException e) {
                throw new GeoParquetException("WKBReader failed to parse.", e);
            }
        }).toList();
    }

    public List<GeoParquetGroup> getGroupValues(int fieldIndex) {
        Object object = this.data[fieldIndex];
        if (object instanceof List) {
            List list = (List)object;
            return list;
        }
        return List.of((GeoParquetGroup)this.data[fieldIndex]);
    }

    private double getNumericValue(GeoParquetGroup group, int fieldIndex) {
        GeoParquetSchema.Type fieldType = group.getGeoParquetSchema().fields().get(fieldIndex).type();
        return switch (fieldType) {
            case GeoParquetSchema.Type.FLOAT -> group.getFloatValue(fieldIndex).floatValue();
            case GeoParquetSchema.Type.DOUBLE -> group.getDoubleValue(fieldIndex);
            default -> throw new GeoParquetException("Expected numeric field at index " + fieldIndex);
        };
    }

    public Envelope getEnvelopeValue(int fieldIndex) {
        return this.getEnvelopeValues(fieldIndex).get(0);
    }

    public List<Envelope> getEnvelopeValues(int fieldIndex) {
        return this.getGroupValues(fieldIndex).stream().map(group -> {
            double xMin = this.getNumericValue((GeoParquetGroup)group, 0);
            double yMin = this.getNumericValue((GeoParquetGroup)group, 1);
            double xMax = this.getNumericValue((GeoParquetGroup)group, 2);
            double yMax = this.getNumericValue((GeoParquetGroup)group, 3);
            return new Envelope(xMin, xMax, yMin, yMax);
        }).toList();
    }

    public Binary getBinaryValue(String fieldName) {
        return this.getBinaryValue(this.parquetSchema.getFieldIndex(fieldName));
    }

    public List<Binary> getBinaryValues(String fieldName) {
        return this.getBinaryValues(this.parquetSchema.getFieldIndex(fieldName));
    }

    public Boolean getBooleanValue(String fieldName) {
        return this.getBooleanValue(this.parquetSchema.getFieldIndex(fieldName));
    }

    public List<Boolean> getBooleanValues(String fieldName) {
        return this.getBooleanValues(this.parquetSchema.getFieldIndex(fieldName));
    }

    public Double getDoubleValue(String fieldName) {
        return this.getDoubleValue(this.parquetSchema.getFieldIndex(fieldName));
    }

    public List<Double> getDoubleValues(String fieldName) {
        return this.getDoubleValues(this.parquetSchema.getFieldIndex(fieldName));
    }

    public Float getFloatValue(String fieldName) {
        return this.getFloatValue(this.parquetSchema.getFieldIndex(fieldName));
    }

    public List<Float> getFloatValues(String fieldName) {
        return this.getFloatValues(this.parquetSchema.getFieldIndex(fieldName));
    }

    public Integer getIntegerValue(String fieldName) {
        return this.getIntegerValue(this.parquetSchema.getFieldIndex(fieldName));
    }

    public List<Integer> getIntegerValues(String fieldName) {
        return this.getIntegerValues(this.parquetSchema.getFieldIndex(fieldName));
    }

    public Long getLongValue(String fieldName) {
        return this.getLongValue(this.parquetSchema.getFieldIndex(fieldName));
    }

    public List<Long> getLongValues(String fieldName) {
        return this.getLongValues(this.parquetSchema.getFieldIndex(fieldName));
    }

    public String getStringValue(String fieldName) {
        return this.getStringValue(this.parquetSchema.getFieldIndex(fieldName));
    }

    public List<String> getStringValues(String fieldName) {
        return this.getStringValues(this.parquetSchema.getFieldIndex(fieldName));
    }

    public Geometry getGeometryValue(String fieldName) {
        return this.getGeometryValue(this.parquetSchema.getFieldIndex(fieldName));
    }

    public List<Geometry> getGeometryValues(String fieldName) {
        return this.getGeometryValues(this.parquetSchema.getFieldIndex(fieldName));
    }

    public GeoParquetGroup getGroupValue(String fieldName) {
        return this.getGroupValue(this.parquetSchema.getFieldIndex(fieldName));
    }

    public List<GeoParquetGroup> getGroupValues(String fieldName) {
        return this.getGroupValues(this.parquetSchema.getFieldIndex(fieldName));
    }

    public Envelope getEnvelopeValue(String fieldName) {
        return this.getEnvelopeValue(this.parquetSchema.getFieldIndex(fieldName));
    }

    public List<Envelope> getEnvelopeValues(String fieldName) {
        return this.getEnvelopeValues(this.parquetSchema.getFieldIndex(fieldName));
    }

    public String toString() {
        return this.toString("");
    }

    private String toString(String indent) {
        StringBuilder builder = new StringBuilder();
        int fieldCount = this.parquetSchema.getFields().size();
        for (int i = 0; i < fieldCount; ++i) {
            String fieldName = this.parquetSchema.getFieldName(i);
            Object fieldValue = this.data[i];
            if (fieldValue == null) continue;
            this.appendFieldToString(builder, indent, fieldName, fieldValue);
        }
        return builder.toString();
    }

    private void appendFieldToString(StringBuilder builder, String indent, String fieldName, Object fieldValue) {
        if (fieldValue instanceof List) {
            List values = (List)fieldValue;
            for (Object value : values) {
                this.appendValueToString(builder, indent, fieldName, value);
            }
        } else {
            this.appendValueToString(builder, indent, fieldName, fieldValue);
        }
    }

    private void appendValueToString(StringBuilder builder, String indent, String fieldName, Object value) {
        builder.append(indent).append(fieldName);
        if (value == null) {
            builder.append(": NULL\n");
        } else if (value instanceof GeoParquetGroup) {
            GeoParquetGroup group = (GeoParquetGroup)value;
            builder.append("\n").append(group.toString(indent + "  "));
        } else {
            String valueString = this.getValueAsString(value);
            builder.append(": ").append(valueString).append("\n");
        }
    }

    private String getValueAsString(Object value) {
        if (value instanceof Binary) {
            Binary binary = (Binary)value;
            return binary.toStringUsingUTF8();
        }
        return value.toString();
    }
}

