/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.rpsl;

import java.util.ArrayList;
import java.util.Spliterator;
import java.util.function.Consumer;
import org.apache.baremaps.rpsl.RpslObject;

class RpslSpliterator
implements Spliterator<RpslObject> {
    private final Spliterator<String> lineSpliterator;
    private String currentLine;

    public RpslSpliterator(Spliterator<String> lineSpliterator) {
        this.lineSpliterator = lineSpliterator;
    }

    @Override
    public boolean tryAdvance(Consumer<? super RpslObject> consumer) {
        ArrayList<RpslObject.RpslAttribute> attributes = new ArrayList<RpslObject.RpslAttribute>();
        String attributeName = null;
        StringBuilder attributeValue = new StringBuilder();
        while (this.advanceLine()) {
            int index;
            if (this.currentLine.isEmpty()) {
                if (attributes.isEmpty()) continue;
                attributes.add(new RpslObject.RpslAttribute(attributeName, attributeValue.toString()));
                consumer.accept(new RpslObject(attributes));
                return true;
            }
            if (this.currentLine.startsWith("#") || this.currentLine.startsWith("%")) continue;
            if (this.currentLine.startsWith(" ") || this.currentLine.startsWith("+")) {
                attributeValue.append('\n').append(this.currentLine.trim());
                continue;
            }
            if (attributeName != null) {
                attributes.add(new RpslObject.RpslAttribute(attributeName, attributeValue.toString()));
            }
            if ((index = this.currentLine.indexOf(58)) < 0) continue;
            attributeName = this.currentLine.substring(0, index).trim();
            attributeValue = new StringBuilder(this.currentLine.substring(index + 1).trim());
        }
        if (attributeName != null) {
            attributes.add(new RpslObject.RpslAttribute(attributeName, attributeValue.toString()));
            consumer.accept(new RpslObject(attributes));
            return true;
        }
        return false;
    }

    private boolean advanceLine() {
        return this.lineSpliterator.tryAdvance((? super T line) -> {
            this.currentLine = line;
        });
    }

    @Override
    public Spliterator<RpslObject> trySplit() {
        return null;
    }

    @Override
    public long estimateSize() {
        return this.lineSpliterator.estimateSize();
    }

    @Override
    public int characteristics() {
        return this.lineSpliterator.characteristics();
    }
}

