/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.dgiwg;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import mil.nga.crs.CRSType;
import mil.nga.crs.geo.GeoDatums;
import mil.nga.geopackage.BoundingBox;
import mil.nga.geopackage.GeoPackageException;
import mil.nga.geopackage.contents.ContentsDataType;
import mil.nga.geopackage.dgiwg.DataType;
import mil.nga.geopackage.dgiwg.UTMZone;
import mil.nga.geopackage.dgiwg.WellKnownText;
import mil.nga.geopackage.srs.SpatialReferenceSystem;
import mil.nga.proj.ProjectionConstants;

public enum CoordinateReferenceSystem {
    EPSG_3035(3035L, CRSType.PROJECTED, 2, WellKnownText.EPSG_3035, "Lambert Azimuthal Equal Area ETRS89 for Europe", new BoundingBox(2000000.0, 1000000.0, 6500000.0, 5500000.0), new BoundingBox(-16.1, 32.88, 40.18, 84.73), DataType.TILES_2D, DataType.TILES_3D),
    EPSG_3395(3395L, CRSType.PROJECTED, 2, WellKnownText.EPSG_3395, "Mercator view of world excluding polar areas for very small scale mapping", BoundingBox.worldWebMercator(), new BoundingBox(-ProjectionConstants.WGS84_HALF_WORLD_LON_WIDTH, -80.0, ProjectionConstants.WGS84_HALF_WORLD_LON_WIDTH, 84.0), DataType.TILES_2D, DataType.TILES_3D),
    EPSG_3857(3857L, CRSType.PROJECTED, 2, WellKnownText.EPSG_3857, "Uses spherical development of ellipsoidal coordinates. This should only be used for visualization purposes.", BoundingBox.worldWebMercator(), BoundingBox.worldWGS84WithWebMercatorLimits(), DataType.TILES_2D),
    EPSG_3978(3978L, CRSType.PROJECTED, 2, WellKnownText.EPSG_3978, "Lambert Conformal Conic NAD83 for Canada", new BoundingBox(-7786476.885838887, -5153821.09213678, 7148753.233541353, 7928343.534071138), new BoundingBox(-172.54, 23.81, -47.74, 86.46), DataType.TILES_2D),
    EPSG_4326(4326L, CRSType.GEODETIC, 2, WellKnownText.EPSG_4326, "Horizontal component of 3D system. Used by the GPS satellite navigation system and for NATO military geodetic surveying.", DataType.TILES_3D, DataType.FEATURES_2D),
    EPSG_4979(4979L, CRSType.GEODETIC, 3, WellKnownText.EPSG_4979, "Used by the GPS satellite navigation system and for NATO military geodetic surveying.", DataType.TILES_3D, DataType.FEATURES_3D),
    EPSG_5041(5041L, CRSType.PROJECTED, 2, WellKnownText.EPSG_5041, "Military mapping by NATO north of 60\u00b0 N", new BoundingBox(-1.4440759350252E7, -1.4440759350252E7, 1.8440759350252E7, 1.8440759350252E7), new BoundingBox(-ProjectionConstants.WGS84_HALF_WORLD_LON_WIDTH, 60.0, ProjectionConstants.WGS84_HALF_WORLD_LON_WIDTH, ProjectionConstants.WGS84_HALF_WORLD_LAT_HEIGHT), DataType.TILES_2D, DataType.TILES_3D),
    EPSG_5042(5042L, CRSType.PROJECTED, 2, WellKnownText.EPSG_5042, "Military mapping by NATO south of 60\u00b0 S", new BoundingBox(-1.4440759350252E7, -1.4440759350252E7, 1.8440759350252E7, 1.8440759350252E7), new BoundingBox(-ProjectionConstants.WGS84_HALF_WORLD_LON_WIDTH, -ProjectionConstants.WGS84_HALF_WORLD_LAT_HEIGHT, ProjectionConstants.WGS84_HALF_WORLD_LON_WIDTH, -60.0), DataType.TILES_2D, DataType.TILES_3D),
    EPSG_9518(9518L, CRSType.COMPOUND, 3, WellKnownText.EPSG_9518, "Geodetic position based on the World Geodetic System 1984 (WGS 84), extended by height position based on the Earth Gravity Model 2008 (EGM08).", DataType.FEATURES_3D),
    EPSG_32601(32601L),
    EPSG_32602(32602L),
    EPSG_32603(32603L),
    EPSG_32604(32604L),
    EPSG_32605(32605L),
    EPSG_32606(32606L),
    EPSG_32607(32607L),
    EPSG_32608(32608L),
    EPSG_32609(32609L),
    EPSG_32610(32610L),
    EPSG_32611(32611L),
    EPSG_32612(32612L),
    EPSG_32613(32613L),
    EPSG_32614(32614L),
    EPSG_32615(32615L),
    EPSG_32616(32616L),
    EPSG_32617(32617L),
    EPSG_32618(32618L),
    EPSG_32619(32619L),
    EPSG_32620(32620L),
    EPSG_32621(32621L),
    EPSG_32622(32622L),
    EPSG_32623(32623L),
    EPSG_32624(32624L),
    EPSG_32625(32625L),
    EPSG_32626(32626L),
    EPSG_32627(32627L),
    EPSG_32628(32628L),
    EPSG_32629(32629L),
    EPSG_32630(32630L),
    EPSG_32631(32631L),
    EPSG_32632(32632L),
    EPSG_32633(32633L),
    EPSG_32634(32634L),
    EPSG_32635(32635L),
    EPSG_32636(32636L),
    EPSG_32637(32637L),
    EPSG_32638(32638L),
    EPSG_32639(32639L),
    EPSG_32640(32640L),
    EPSG_32641(32641L),
    EPSG_32642(32642L),
    EPSG_32643(32643L),
    EPSG_32644(32644L),
    EPSG_32645(32645L),
    EPSG_32646(32646L),
    EPSG_32647(32647L),
    EPSG_32648(32648L),
    EPSG_32649(32649L),
    EPSG_32650(32650L),
    EPSG_32651(32651L),
    EPSG_32652(32652L),
    EPSG_32653(32653L),
    EPSG_32654(32654L),
    EPSG_32655(32655L),
    EPSG_32656(32656L),
    EPSG_32657(32657L),
    EPSG_32658(32658L),
    EPSG_32659(32659L),
    EPSG_32660(32660L),
    EPSG_32701(32701L),
    EPSG_32702(32702L),
    EPSG_32703(32703L),
    EPSG_32704(32704L),
    EPSG_32705(32705L),
    EPSG_32706(32706L),
    EPSG_32707(32707L),
    EPSG_32708(32708L),
    EPSG_32709(32709L),
    EPSG_32710(32710L),
    EPSG_32711(32711L),
    EPSG_32712(32712L),
    EPSG_32713(32713L),
    EPSG_32714(32714L),
    EPSG_32715(32715L),
    EPSG_32716(32716L),
    EPSG_32717(32717L),
    EPSG_32718(32718L),
    EPSG_32719(32719L),
    EPSG_32720(32720L),
    EPSG_32721(32721L),
    EPSG_32722(32722L),
    EPSG_32723(32723L),
    EPSG_32724(32724L),
    EPSG_32725(32725L),
    EPSG_32726(32726L),
    EPSG_32727(32727L),
    EPSG_32728(32728L),
    EPSG_32729(32729L),
    EPSG_32730(32730L),
    EPSG_32731(32731L),
    EPSG_32732(32732L),
    EPSG_32733(32733L),
    EPSG_32734(32734L),
    EPSG_32735(32735L),
    EPSG_32736(32736L),
    EPSG_32737(32737L),
    EPSG_32738(32738L),
    EPSG_32739(32739L),
    EPSG_32740(32740L),
    EPSG_32741(32741L),
    EPSG_32742(32742L),
    EPSG_32743(32743L),
    EPSG_32744(32744L),
    EPSG_32745(32745L),
    EPSG_32746(32746L),
    EPSG_32747(32747L),
    EPSG_32748(32748L),
    EPSG_32749(32749L),
    EPSG_32750(32750L),
    EPSG_32751(32751L),
    EPSG_32752(32752L),
    EPSG_32753(32753L),
    EPSG_32754(32754L),
    EPSG_32755(32755L),
    EPSG_32756(32756L),
    EPSG_32757(32757L),
    EPSG_32758(32758L),
    EPSG_32759(32759L),
    EPSG_32760(32760L);

    private static Map<String, Map<Long, CoordinateReferenceSystem>> authorityCodeCRS;
    private static Map<DataType, Set<CoordinateReferenceSystem>> dataTypeCRS;
    private final String authority;
    private final long code;
    private final String crsName;
    private final CRSType type;
    private final int dimension;
    private final String wkt;
    private final String description;
    private final BoundingBox bounds;
    private final BoundingBox wgs84Bounds;
    private final Set<DataType> dataTypes;
    private final Map<ContentsDataType, Set<DataType>> contentsDataTypes;
    public static final String LAMBERT_CONIC_CONFORMAL_1SP_DESCRIPTION = "For a one standard parallel Lambert the natural origin of the projected coordinate system is the intersection of the standard parallel with the longitude of origin (central meridian).";
    public static final String LAMBERT_CONIC_CONFORMAL_2SP_DESCRIPTION = "Two standard parallels will usually be made according to the latitudinal extent of the area which it is wished to map, the parallels usually being chosen so that they each lie a proportion inboard of the north and south margins of the mapped area.";

    private CoordinateReferenceSystem(long epsgCode, CRSType type, int dimension, String wkt, String description, DataType ... dataTypes) {
        this(epsgCode, CoordinateReferenceSystem.epsgURL(epsgCode), type, dimension, wkt, description, dataTypes);
    }

    private CoordinateReferenceSystem(long epsgCode, String name, CRSType type, int dimension, String wkt, String description, DataType ... dataTypes) {
        this(epsgCode, name, type, dimension, wkt, description, BoundingBox.worldWGS84(), dataTypes);
    }

    private CoordinateReferenceSystem(long epsgCode, CRSType type, int dimension, String wkt, String description, BoundingBox wgs84Bounds, DataType ... dataTypes) {
        this(epsgCode, CoordinateReferenceSystem.epsgURL(epsgCode), type, dimension, wkt, description, wgs84Bounds, dataTypes);
    }

    private CoordinateReferenceSystem(long epsgCode, String name, CRSType type, int dimension, String wkt, String description, BoundingBox wgs84Bounds, DataType ... dataTypes) {
        this(epsgCode, name, type, dimension, wkt, description, wgs84Bounds, wgs84Bounds, dataTypes);
    }

    private CoordinateReferenceSystem(long epsgCode, CRSType type, int dimension, String wkt, String description, BoundingBox bounds, BoundingBox wgs84Bounds, DataType ... dataTypes) {
        this(epsgCode, CoordinateReferenceSystem.epsgURL(epsgCode), type, dimension, wkt, description, bounds, wgs84Bounds, dataTypes);
    }

    private CoordinateReferenceSystem(long epsgCode, String name, CRSType type, int dimension, String wkt, String description, BoundingBox bounds, BoundingBox wgs84Bounds, DataType ... dataTypes) {
        this("EPSG", epsgCode, name, type, dimension, wkt, description, bounds, wgs84Bounds, dataTypes);
    }

    private CoordinateReferenceSystem(String authority, long code, String name, CRSType type, int dimension, String wkt, String description, DataType ... dataTypes) {
        this(authority, code, name, type, dimension, wkt, description, BoundingBox.worldWGS84(), dataTypes);
    }

    private CoordinateReferenceSystem(String authority, long code, String name, CRSType type, int dimension, String wkt, String description, BoundingBox wgs84Bounds, DataType ... dataTypes) {
        this(authority, code, name, type, dimension, wkt, description, wgs84Bounds, wgs84Bounds, dataTypes);
    }

    private CoordinateReferenceSystem(String authority, long code, String name, CRSType type, int dimension, String wkt, String description, BoundingBox bounds, BoundingBox wgs84Bounds, DataType ... dataTypes) {
        this.authority = authority;
        this.code = code;
        this.crsName = name;
        this.type = type;
        this.dimension = dimension;
        this.wkt = wkt;
        this.description = description;
        this.bounds = bounds;
        this.wgs84Bounds = wgs84Bounds;
        this.dataTypes = new LinkedHashSet<DataType>(Arrays.asList(dataTypes));
        this.contentsDataTypes = new HashMap<ContentsDataType, Set<DataType>>();
        for (DataType dataType : dataTypes) {
            ContentsDataType contentsDataType = dataType.getDataType();
            Set<DataType> dataTypesSet = this.contentsDataTypes.get((Object)contentsDataType);
            if (dataTypesSet == null) {
                dataTypesSet = new LinkedHashSet<DataType>();
                this.contentsDataTypes.put(contentsDataType, dataTypesSet);
            }
            dataTypesSet.add(dataType);
        }
        CoordinateReferenceSystem.initialize(this);
    }

    private CoordinateReferenceSystem(long epsgCode) {
        this.wkt = WellKnownText.getUTMZone(epsgCode);
        this.authority = "EPSG";
        this.code = epsgCode;
        long zone = UTMZone.getZone(epsgCode);
        this.crsName = CoordinateReferenceSystem.epsgURL(epsgCode);
        this.type = CRSType.PROJECTED;
        this.dimension = 2;
        long centralMedian = UTMZone.getCentralMeridian(zone);
        String lonDirection = centralMedian < 0L ? "W" : "S";
        boolean north = UTMZone.isNorth(epsgCode);
        double minLongitude = centralMedian - 3L;
        double maxLongitude = centralMedian + 3L;
        double minLatitude = 0.0;
        double maxLatitude = 0.0;
        if (north) {
            maxLatitude = 84.0;
        } else {
            minLatitude = -80.0;
        }
        StringBuilder description = new StringBuilder("Between ");
        description.append(Math.abs(minLongitude));
        description.append("\u00b0");
        description.append(lonDirection);
        description.append(" and ");
        description.append(Math.abs(maxLongitude));
        description.append("\u00b0");
        description.append(lonDirection);
        description.append(", ");
        if (north) {
            description.append("northern");
        } else {
            description.append("southern");
        }
        description.append(" hemisphere between ");
        if (north) {
            description.append("equator and 84\u00b0N");
        } else {
            description.append("80\u00b0S and equator");
        }
        description.append(", onshore and offshore.");
        this.description = description.toString();
        this.bounds = new BoundingBox(-9501965.72931276, -2.00039314586255E7, 1.05019657293128E7, 2.00039314586255E7);
        this.wgs84Bounds = new BoundingBox(minLongitude, minLatitude, maxLongitude, maxLatitude);
        this.dataTypes = new LinkedHashSet<DataType>();
        this.dataTypes.add(DataType.TILES_2D);
        this.contentsDataTypes = new HashMap<ContentsDataType, Set<DataType>>();
        this.contentsDataTypes.put(ContentsDataType.TILES, this.dataTypes);
        CoordinateReferenceSystem.initialize(this);
    }

    public String getAuthority() {
        return this.authority;
    }

    public long getCode() {
        return this.code;
    }

    public String getAuthorityAndCode() {
        return this.authority + ":" + this.code;
    }

    public String getName() {
        return this.crsName;
    }

    public CRSType getType() {
        return this.type;
    }

    public int getDimension() {
        return this.dimension;
    }

    public String getWkt() {
        return this.wkt;
    }

    public String getDescription() {
        return this.description;
    }

    public BoundingBox getBounds() {
        return this.bounds;
    }

    public BoundingBox getWGS84Bounds() {
        return this.wgs84Bounds;
    }

    public Set<DataType> getDataTypes() {
        return this.dataTypes;
    }

    public boolean isType(CRSType type) {
        return this.type == type;
    }

    public boolean isDataType(DataType dataType) {
        return this.dataTypes.contains((Object)dataType);
    }

    public Map<ContentsDataType, Set<DataType>> getContentsDataTypes() {
        return this.contentsDataTypes;
    }

    public Set<DataType> getTilesDataTypes() {
        return this.getDataTypes(ContentsDataType.TILES);
    }

    public boolean hasTilesDataTypes() {
        Set<DataType> tiles = this.getTilesDataTypes();
        return tiles != null && !tiles.isEmpty();
    }

    public Set<DataType> getFeaturesDataTypes() {
        return this.getDataTypes(ContentsDataType.FEATURES);
    }

    public boolean hasFeaturesDataTypes() {
        Set<DataType> features = this.getFeaturesDataTypes();
        return features != null && !features.isEmpty();
    }

    public Set<DataType> getDataTypes(ContentsDataType contentsDataType) {
        return this.contentsDataTypes.get((Object)contentsDataType);
    }

    public SpatialReferenceSystem createSpatialReferenceSystem() {
        SpatialReferenceSystem srs = new SpatialReferenceSystem();
        srs.setSrsName(this.crsName);
        srs.setSrsId(this.code);
        srs.setOrganization(this.authority);
        srs.setOrganizationCoordsysId(this.code);
        String definition = this.wkt;
        if (this.type == CRSType.COMPOUND) {
            definition = "undefined";
        }
        srs.setDefinition(definition);
        srs.setDescription(this.description);
        srs.setDefinition_12_063(this.wkt);
        return srs;
    }

    public SpatialReferenceSystem createTilesSpatialReferenceSystem() {
        if (!this.hasTilesDataTypes()) {
            throw new GeoPackageException("CRS is not valid for tiles: " + this.getAuthorityAndCode());
        }
        return this.createSpatialReferenceSystem();
    }

    public SpatialReferenceSystem createFeaturesSpatialReferenceSystem() {
        if (!this.hasFeaturesDataTypes()) {
            throw new GeoPackageException("CRS is not valid for features: " + this.getAuthorityAndCode());
        }
        return this.createSpatialReferenceSystem();
    }

    public static SpatialReferenceSystem createLambertConicConformal1SP(long epsg, String name, CRSType crsType, GeoDatums geoDatum, double latitudeOfOrigin, double centralMeridian, double scaleFactor, double falseEasting, double falseNorthing) {
        String definition = WellKnownText.getLambertConicConformal1SP(epsg, name, crsType, geoDatum, latitudeOfOrigin, centralMeridian, scaleFactor, falseEasting, falseNorthing);
        return CoordinateReferenceSystem.createLambertConicConformal(epsg, name, definition, LAMBERT_CONIC_CONFORMAL_1SP_DESCRIPTION);
    }

    public static SpatialReferenceSystem createLambertConicConformal2SP(long epsg, String name, CRSType crsType, GeoDatums geoDatum, double standardParallel1, double standardParallel2, double latitudeOfOrigin, double centralMeridian, double falseEasting, double falseNorthing) {
        String definition = WellKnownText.getLambertConicConformal2SP(epsg, name, crsType, geoDatum, standardParallel1, standardParallel2, latitudeOfOrigin, centralMeridian, falseEasting, falseNorthing);
        return CoordinateReferenceSystem.createLambertConicConformal(epsg, name, definition, LAMBERT_CONIC_CONFORMAL_2SP_DESCRIPTION);
    }

    private static SpatialReferenceSystem createLambertConicConformal(long epsg, String name, String definition, String description) {
        SpatialReferenceSystem srs = new SpatialReferenceSystem();
        srs.setSrsName(name);
        srs.setSrsId(epsg);
        srs.setOrganization("EPSG");
        srs.setOrganizationCoordsysId(epsg);
        srs.setDefinition(definition);
        srs.setDescription(description);
        srs.setDefinition_12_063(definition);
        return srs;
    }

    public static CoordinateReferenceSystem getCoordinateReferenceSystem(long epsgCode) {
        return CoordinateReferenceSystem.getCoordinateReferenceSystem("EPSG", epsgCode);
    }

    public static CoordinateReferenceSystem getCoordinateReferenceSystem(SpatialReferenceSystem srs) {
        return CoordinateReferenceSystem.getCoordinateReferenceSystem(srs.getOrganization(), srs.getOrganizationCoordsysId());
    }

    public static CoordinateReferenceSystem getCoordinateReferenceSystem(String authority, long code) {
        CoordinateReferenceSystem crs = null;
        Map<Long, CoordinateReferenceSystem> codeMap = authorityCodeCRS.get(authority);
        if (codeMap != null) {
            crs = codeMap.get(code);
        }
        return crs;
    }

    public static Set<CoordinateReferenceSystem> getCoordinateReferenceSystems(DataType dataType) {
        Set<CoordinateReferenceSystem> crs = dataTypeCRS.get((Object)dataType);
        if (crs != null) {
            crs = Collections.unmodifiableSet(crs);
        }
        return crs;
    }

    public static Set<CoordinateReferenceSystem> getCoordinateReferenceSystems(ContentsDataType dataType) {
        LinkedHashSet<CoordinateReferenceSystem> crss = new LinkedHashSet<CoordinateReferenceSystem>();
        for (DataType dt : DataType.getDataTypes(dataType)) {
            Set<CoordinateReferenceSystem> crs = dataTypeCRS.get((Object)dt);
            if (crs == null) continue;
            crss.addAll(crs);
        }
        return crss;
    }

    public static String epsgURL(long epsgCode) {
        return "http://www.opengis.net/def/crs/EPSG/0/" + epsgCode;
    }

    private static void initialize(CoordinateReferenceSystem crs) {
        Map<Long, CoordinateReferenceSystem> codeMap;
        if (authorityCodeCRS == null) {
            authorityCodeCRS = new HashMap<String, Map<Long, CoordinateReferenceSystem>>();
        }
        if ((codeMap = authorityCodeCRS.get(crs.getAuthority())) == null) {
            codeMap = new HashMap<Long, CoordinateReferenceSystem>();
            authorityCodeCRS.put(crs.getAuthority(), codeMap);
        }
        codeMap.put(crs.getCode(), crs);
        if (dataTypeCRS == null) {
            dataTypeCRS = new HashMap<DataType, Set<CoordinateReferenceSystem>>();
        }
        for (DataType dataType : crs.getDataTypes()) {
            Set<CoordinateReferenceSystem> crsSet = dataTypeCRS.get((Object)dataType);
            if (crsSet == null) {
                crsSet = new LinkedHashSet<CoordinateReferenceSystem>();
                dataTypeCRS.put(dataType, crsSet);
            }
            crsSet.add(crs);
        }
    }
}

