/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.openstreetmap.function;

import java.util.Optional;
import java.util.function.Function;
import org.apache.baremaps.openstreetmap.model.Bound;
import org.apache.baremaps.openstreetmap.model.Entity;
import org.apache.baremaps.openstreetmap.model.Header;
import org.apache.baremaps.openstreetmap.model.Node;
import org.apache.baremaps.openstreetmap.model.Relation;
import org.apache.baremaps.openstreetmap.model.Way;
import org.apache.baremaps.openstreetmap.stream.StreamException;
import org.locationtech.jts.geom.Geometry;

public class EntityToGeometryMapper
implements Function<Entity, Optional<Geometry>> {
    @Override
    public Optional<Geometry> apply(Entity entity) {
        try {
            if (entity instanceof Node) {
                Node node = (Node)entity;
                return Optional.ofNullable(node.getGeometry());
            }
            if (entity instanceof Way) {
                Way way = (Way)entity;
                return Optional.ofNullable(way.getGeometry());
            }
            if (entity instanceof Relation) {
                Relation relation = (Relation)entity;
                return Optional.ofNullable(relation.getGeometry());
            }
            if (entity instanceof Header) {
                return Optional.empty();
            }
            if (entity instanceof Bound) {
                return Optional.empty();
            }
            throw new StreamException("Unknown entity type.");
        }
        catch (Exception e) {
            throw new StreamException(e);
        }
    }
}

