/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.openstreetmap.utils;

import org.apache.baremaps.openstreetmap.function.ProjectionTransformer;
import org.apache.baremaps.openstreetmap.utils.CRSUtils;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.geom.util.AffineTransformation;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKBReader;
import org.locationtech.jts.io.WKBWriter;
import org.locationtech.proj4j.CoordinateReferenceSystem;
import org.locationtech.proj4j.CoordinateTransform;
import org.locationtech.proj4j.CoordinateTransformFactory;

public class GeometryUtils {
    public static final GeometryFactory GEOMETRY_FACTORY_WGS84 = new GeometryFactory(new PrecisionModel(), 4326);

    private GeometryUtils() {
    }

    public static byte[] serialize(Geometry geometry) {
        if (geometry == null) {
            return null;
        }
        WKBWriter writer = new WKBWriter(2, 1, true);
        return writer.write(geometry);
    }

    public static Geometry deserialize(byte[] wkb) {
        if (wkb == null) {
            return null;
        }
        try {
            WKBReader reader = new WKBReader(new GeometryFactory());
            return reader.read(wkb);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static CoordinateTransform coordinateTransform(Integer sourceSrid, Integer targetSrid) {
        CoordinateReferenceSystem sourceCRS = CRSUtils.createFromSrid(sourceSrid);
        CoordinateReferenceSystem targetCRS = CRSUtils.createFromSrid(targetSrid);
        CoordinateTransformFactory coordinateTransformFactory = new CoordinateTransformFactory();
        return coordinateTransformFactory.createTransform(sourceCRS, targetCRS);
    }

    public static ProjectionTransformer projectionTransformer(int inputSRID, int outputSRID) {
        return new ProjectionTransformer(inputSRID, outputSRID);
    }

    public static Geometry scale(Geometry geometry, double factor) {
        AffineTransformation transform = AffineTransformation.scaleInstance((double)factor, (double)factor);
        return transform.transform(geometry);
    }

    public static Geometry createEnvelope(int xMin, int yMin, int xMax, int yMax) {
        return new GeometryFactory().createPolygon(new Coordinate[]{new Coordinate((double)xMin, (double)yMin), new Coordinate((double)xMin, (double)yMax), new Coordinate((double)xMax, (double)yMax), new Coordinate((double)xMax, (double)yMin), new Coordinate((double)xMin, (double)yMin)});
    }
}

