/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.sf.geojson;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import mil.nga.sf.Geometry;
import mil.nga.sf.GeometryCollection;
import mil.nga.sf.geojson.Feature;
import mil.nga.sf.geojson.GeoJsonObject;
import mil.nga.sf.geojson.GeometryType;

@JsonPropertyOrder(value={"type", "bbox", "features"})
public class FeatureCollection
extends GeoJsonObject
implements Iterable<Feature> {
    private static final long serialVersionUID = 1L;
    private List<Feature> features = new ArrayList<Feature>();

    public FeatureCollection() {
    }

    public FeatureCollection(Feature feature) {
        this.addFeature(feature);
    }

    public FeatureCollection(Collection<Feature> features) {
        this.setFeatures(features);
    }

    public List<Feature> getFeatures() {
        return this.features;
    }

    public void setFeatures(Collection<Feature> features) {
        this.features = new ArrayList<Feature>(features);
    }

    public void addFeature(Feature feature) {
        this.features.add(feature);
    }

    public void addFeatures(Collection<Feature> features) {
        this.features.addAll(features);
    }

    public int numFeatures() {
        return this.features.size();
    }

    public Feature getFeature(int i) {
        return this.features.get(i);
    }

    @Override
    public Iterator<Feature> iterator() {
        return this.features.iterator();
    }

    @Override
    public Geometry getSimpleGeometry() {
        GeometryCollection geometry = null;
        if (this.features != null && !this.features.isEmpty()) {
            GeometryCollection geomCollection = new GeometryCollection();
            for (Feature feature : this.features) {
                Geometry geom = feature.getSimpleGeometry();
                if (geom == null) continue;
                geomCollection.addGeometry(geom);
            }
            if (!geomCollection.isEmpty()) {
                geometry = geomCollection;
            }
        }
        return geometry;
    }

    @JsonIgnore
    public GeometryType getGeometryType() {
        GeometryType result = null;
        for (Feature feature : this.features) {
            GeometryType gt = feature.getGeometryType();
            if (result == null) {
                result = gt;
                continue;
            }
            if (gt == result) continue;
            result = GeometryType.GEOMETRY;
            break;
        }
        return result;
    }

    @JsonIgnore
    public Map<String, String> getPropertiesMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Feature feature : this.getFeatures()) {
            Map<String, Object> properties = feature.getProperties();
            for (String property : properties.keySet()) {
                if (result.containsKey(property)) continue;
                result.put(property, properties.get(property).getClass().getSimpleName());
            }
        }
        return result;
    }

    @Override
    public String getType() {
        return "FeatureCollection";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.features == null ? 0 : this.features.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FeatureCollection other = (FeatureCollection)obj;
        return !(this.features == null ? other.features != null : !this.features.equals(other.features));
    }
}

