/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.sf.geojson;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import mil.nga.sf.Geometry;
import mil.nga.sf.geojson.Feature;
import mil.nga.sf.geojson.FeatureCollection;

@JsonTypeInfo(property="type", use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY)
@JsonSubTypes(value={@JsonSubTypes.Type(value=Feature.class), @JsonSubTypes.Type(value=FeatureCollection.class), @JsonSubTypes.Type(value=mil.nga.sf.geojson.Geometry.class)})
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public abstract class GeoJsonObject
implements Serializable {
    private static final long serialVersionUID = 1L;
    private double[] bbox;
    private Map<String, Object> foreignMembers = new HashMap<String, Object>();

    public double[] getBbox() {
        return this.bbox;
    }

    public void setBbox(double[] bbox) {
        this.bbox = bbox;
    }

    public abstract String getType();

    @JsonIgnore
    public abstract Geometry getSimpleGeometry();

    @JsonAnyGetter
    public Map<String, Object> getForeignMembers() {
        return this.foreignMembers;
    }

    public Object getForeignMember(String name) {
        return this.foreignMembers.get(name);
    }

    public Object hasForeignMember(String name) {
        return this.foreignMembers.containsKey(name);
    }

    @JsonAnySetter
    public void setForeignMember(String name, Object value) {
        this.foreignMembers.put(name, value);
    }

    public boolean hasForeignMembers() {
        return !this.foreignMembers.isEmpty();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.bbox);
        result = 31 * result + (this.foreignMembers == null ? 0 : this.foreignMembers.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GeoJsonObject other = (GeoJsonObject)obj;
        if (!Arrays.equals(this.bbox, other.bbox)) {
            return false;
        }
        return !(this.foreignMembers == null ? other.foreignMembers != null : !this.foreignMembers.equals(other.foreignMembers));
    }
}

