/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.jmx;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.util.Objects;
import org.apache.hadoop.jmx.JMXJsonServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMXJsonServletNaNFiltered
extends JMXJsonServlet {
    private static final Logger LOG = LoggerFactory.getLogger(JMXJsonServletNaNFiltered.class);

    @Override
    protected boolean extraCheck(Object value) {
        return Objects.equals("NaN", Objects.toString(value).trim());
    }

    @Override
    protected void extraWrite(Object value, String attName, JsonGenerator jg) throws IOException {
        LOG.debug("The {} attribute with value: {} was identified as NaN and will be replaced with 0.0", (Object)attName, value);
        jg.writeNumber(0.0);
    }
}

