/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server;

import com.linecorp.armeria.common.annotation.UnstableApi;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.binder.MeterBinder;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.LongAdder;

@UnstableApi
public final class ServerMetrics
implements MeterBinder {
    private final LongAdder pendingHttp1Requests = new LongAdder();
    private final LongAdder pendingHttp2Requests = new LongAdder();
    private final LongAdder activeHttp1WebSocketRequests = new LongAdder();
    private final LongAdder activeHttp1Requests = new LongAdder();
    private final LongAdder activeHttp2Requests = new LongAdder();
    private final AtomicInteger activeConnections = new AtomicInteger();

    ServerMetrics() {
    }

    public long pendingRequests() {
        return this.pendingHttp1Requests() + this.pendingHttp2Requests();
    }

    public long pendingHttp1Requests() {
        return this.pendingHttp1Requests.longValue();
    }

    public long pendingHttp2Requests() {
        return this.pendingHttp2Requests.longValue();
    }

    public long activeRequests() {
        return this.activeHttp1WebSocketRequests() + this.activeHttp1Requests() + this.activeHttp2Requests();
    }

    public long activeHttp1WebSocketRequests() {
        return this.activeHttp1WebSocketRequests.longValue();
    }

    public long activeHttp1Requests() {
        return this.activeHttp1Requests.longValue();
    }

    public long activeHttp2Requests() {
        return this.activeHttp2Requests.longValue();
    }

    public int activeConnections() {
        return this.activeConnections.get();
    }

    void increasePendingHttp1Requests() {
        this.pendingHttp1Requests.increment();
    }

    void decreasePendingHttp1Requests() {
        this.pendingHttp1Requests.decrement();
    }

    void increasePendingHttp2Requests() {
        this.pendingHttp2Requests.increment();
    }

    void decreasePendingHttp2Requests() {
        this.pendingHttp2Requests.decrement();
    }

    void increaseActiveHttp1Requests() {
        this.activeHttp1Requests.increment();
    }

    void decreaseActiveHttp1Requests() {
        this.activeHttp1Requests.decrement();
    }

    void increaseActiveHttp1WebSocketRequests() {
        this.activeHttp1WebSocketRequests.increment();
    }

    void decreaseActiveHttp1WebSocketRequests() {
        this.activeHttp1WebSocketRequests.decrement();
    }

    void increaseActiveHttp2Requests() {
        this.activeHttp2Requests.increment();
    }

    void decreaseActiveHttp2Requests() {
        this.activeHttp2Requests.decrement();
    }

    int increaseActiveConnectionsAndGet() {
        return this.activeConnections.incrementAndGet();
    }

    void decreaseActiveConnections() {
        this.activeConnections.decrementAndGet();
    }

    public void bindTo(MeterRegistry meterRegistry) {
        meterRegistry.gauge("armeria.server.connections", (Number)this.activeConnections);
        String allRequestsMeterName = "armeria.server.all.requests";
        meterRegistry.gauge("armeria.server.all.requests", ImmutableList.of(Tag.of((String)"protocol", (String)"http1"), Tag.of((String)"state", (String)"pending")), (Number)this.pendingHttp1Requests);
        meterRegistry.gauge("armeria.server.all.requests", ImmutableList.of(Tag.of((String)"protocol", (String)"http2"), Tag.of((String)"state", (String)"pending")), (Number)this.pendingHttp2Requests);
        meterRegistry.gauge("armeria.server.all.requests", ImmutableList.of(Tag.of((String)"protocol", (String)"http1"), Tag.of((String)"state", (String)"active")), (Number)this.activeHttp1Requests);
        meterRegistry.gauge("armeria.server.all.requests", ImmutableList.of(Tag.of((String)"protocol", (String)"http2"), Tag.of((String)"state", (String)"active")), (Number)this.activeHttp2Requests);
        meterRegistry.gauge("armeria.server.all.requests", ImmutableList.of(Tag.of((String)"protocol", (String)"http1.websocket"), Tag.of((String)"state", (String)"active")), (Number)this.activeHttp1WebSocketRequests);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("pendingHttp1Requests", this.pendingHttp1Requests).add("activeHttp1WebSocketRequests", this.activeHttp1WebSocketRequests).add("activeHttp1Requests", this.activeHttp1Requests).add("pendingHttp2Requests", this.pendingHttp2Requests).add("activeHttp2Requests", this.activeHttp2Requests).add("activeConnections", this.activeConnections).toString();
    }
}

