/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.postgres.copy;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import de.bytefish.pgbulkinsert.pgsql.handlers.BaseValueHandler;
import java.io.DataOutputStream;
import java.io.IOException;

public class JsonbValueHandler
extends BaseValueHandler<Object> {
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private final int jsonbProtocolVersion;

    public JsonbValueHandler() {
        this(1);
    }

    public JsonbValueHandler(int jsonbProtocolVersion) {
        this.jsonbProtocolVersion = jsonbProtocolVersion;
    }

    private static byte[] asJson(Object object) throws IOException {
        try {
            String value = objectMapper.writeValueAsString(object);
            return value.getBytes("UTF-8");
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    protected void internalHandle(DataOutputStream buffer, Object value) throws IOException {
        byte[] utf8Bytes = JsonbValueHandler.asJson(value);
        buffer.writeInt(utf8Bytes.length + 1);
        buffer.writeByte(this.jsonbProtocolVersion);
        buffer.write(utf8Bytes);
    }

    public int getLength(Object value) {
        try {
            byte[] utf8Bytes = JsonbValueHandler.asJson(value);
            return utf8Bytes.length;
        }
        catch (IOException e) {
            return 0;
        }
    }

    static {
        SimpleModule module = new SimpleModule();
        module.addSerializer(String.class, (JsonSerializer)new NoQuotesStringSerializer());
        objectMapper.registerModule((Module)module);
    }

    static class NoQuotesStringSerializer
    extends JsonSerializer<String> {
        NoQuotesStringSerializer() {
        }

        public void serialize(String value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeRawValue(value);
        }
    }
}

