/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.postgres.openstreetmap;

import java.util.List;
import java.util.function.Consumer;
import org.apache.baremaps.openstreetmap.model.Change;
import org.apache.baremaps.openstreetmap.model.Element;
import org.apache.baremaps.postgres.openstreetmap.Repository;
import org.apache.baremaps.postgres.openstreetmap.RepositoryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangeElementsImporter<T extends Element>
implements Consumer<Change> {
    private static final Logger logger = LoggerFactory.getLogger(ChangeElementsImporter.class);
    private final Class<T> type;
    private final Repository<Long, T> nodeRepository;

    public ChangeElementsImporter(Class<T> type, Repository<Long, T> nodeRepository) {
        this.type = type;
        this.nodeRepository = nodeRepository;
    }

    @Override
    public void accept(Change change) {
        switch (change.type()) {
            case CREATE: 
            case MODIFY: {
                this.put(change);
                break;
            }
            case DELETE: {
                this.delete(change);
            }
        }
    }

    private void put(Change change) {
        List<Element> nodes = change.entities().stream().filter(this.type::isInstance).map(this.type::cast).toList();
        if (!nodes.isEmpty()) {
            try {
                this.nodeRepository.put(nodes);
            }
            catch (RepositoryException e) {
                logger.error("Failed to save nodes", (Throwable)e);
            }
        }
    }

    private void delete(Change change) {
        List<Long> nodes = change.entities().stream().filter(this.type::isInstance).map(this.type::cast).map(Element::getId).toList();
        if (!nodes.isEmpty()) {
            try {
                this.nodeRepository.delete(nodes);
            }
            catch (RepositoryException e) {
                logger.error("Failed to delete nodes", (Throwable)e);
            }
        }
    }
}

