/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.postgres.openstreetmap;

import java.util.List;
import java.util.function.Consumer;
import org.apache.baremaps.openstreetmap.model.Change;
import org.apache.baremaps.openstreetmap.model.Element;
import org.apache.baremaps.openstreetmap.model.Node;
import org.apache.baremaps.openstreetmap.model.Relation;
import org.apache.baremaps.openstreetmap.model.Way;
import org.apache.baremaps.postgres.openstreetmap.Repository;
import org.apache.baremaps.postgres.openstreetmap.RepositoryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PutChangeImporter
implements Consumer<Change> {
    private static final Logger logger = LoggerFactory.getLogger(PutChangeImporter.class);
    private final Repository<Long, Node> nodeRepository;
    private final Repository<Long, Way> wayRepository;
    private final Repository<Long, Relation> relationRepository;

    public PutChangeImporter(Repository<Long, Node> nodeRepository, Repository<Long, Way> wayRepository, Repository<Long, Relation> relationRepository) {
        this.nodeRepository = nodeRepository;
        this.wayRepository = wayRepository;
        this.relationRepository = relationRepository;
    }

    @Override
    public void accept(Change change) {
        List<Node> nodes = change.entities().stream().filter(entity -> entity instanceof Node).map(entity -> (Node)entity).toList();
        List<Way> ways = change.entities().stream().filter(entity -> entity instanceof Way).map(entity -> (Way)entity).toList();
        List<Relation> relations = change.entities().stream().filter(entity -> entity instanceof Relation).map(entity -> (Relation)entity).toList();
        try {
            switch (change.type()) {
                case CREATE: 
                case MODIFY: {
                    this.put(this.nodeRepository, nodes);
                    this.put(this.wayRepository, ways);
                    this.put(this.relationRepository, relations);
                    break;
                }
                case DELETE: {
                    this.delete(this.nodeRepository, nodes);
                    this.delete(this.wayRepository, ways);
                    this.delete(this.relationRepository, relations);
                }
            }
        }
        catch (RepositoryException e) {
            logger.error("Error while saving changes", (Throwable)e);
        }
    }

    private <T extends Element> void put(Repository<Long, T> repository, List<T> entities) throws RepositoryException {
        if (!entities.isEmpty()) {
            repository.put(entities);
        }
    }

    private <T extends Element> void delete(Repository<Long, T> repository, List<T> entities) throws RepositoryException {
        List<Long> ids = entities.stream().map(Element::getId).toList();
        if (!ids.isEmpty()) {
            repository.delete(ids);
        }
    }
}

