/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.postgres.refresh;

import com.google.common.graph.GraphBuilder;
import com.google.common.graph.MutableGraph;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.baremaps.postgres.refresh.DatabaseMetadataRetriever;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DependencyGraphBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)DependencyGraphBuilder.class.getName());

    private DependencyGraphBuilder() {
    }

    public static MutableGraph<DatabaseMetadataRetriever.DatabaseObject> buildGraph(List<DatabaseMetadataRetriever.DatabaseObject> objects, List<DatabaseMetadataRetriever.DatabaseDependency> dependencies) throws SQLException {
        MutableGraph graph = GraphBuilder.directed().allowsSelfLoops(false).build();
        objects.forEach(arg_0 -> ((MutableGraph)graph).addNode(arg_0));
        dependencies.forEach(dep -> graph.putEdge((Object)dep.source(), (Object)dep.dependent()));
        return graph;
    }

    public static List<DatabaseMetadataRetriever.DatabaseObject> topologicalSort(MutableGraph<DatabaseMetadataRetriever.DatabaseObject> graph) {
        HashMap<DatabaseMetadataRetriever.DatabaseObject, Integer> inDegree = new HashMap<DatabaseMetadataRetriever.DatabaseObject, Integer>();
        for (Object node : graph.nodes()) {
            inDegree.put((DatabaseMetadataRetriever.DatabaseObject)node, 0);
        }
        for (Object node : graph.nodes()) {
            for (DatabaseMetadataRetriever.DatabaseObject successor : graph.successors(node)) {
                inDegree.compute(successor, (k, v) -> v == null ? 1 : v + 1);
            }
        }
        LinkedList<DatabaseMetadataRetriever.DatabaseObject> queue = new LinkedList<DatabaseMetadataRetriever.DatabaseObject>();
        for (Map.Entry entry : inDegree.entrySet()) {
            if ((Integer)entry.getValue() != 0) continue;
            queue.add((DatabaseMetadataRetriever.DatabaseObject)entry.getKey());
        }
        ArrayList<DatabaseMetadataRetriever.DatabaseObject> result = new ArrayList<DatabaseMetadataRetriever.DatabaseObject>();
        while (!queue.isEmpty()) {
            DatabaseMetadataRetriever.DatabaseObject databaseObject = (DatabaseMetadataRetriever.DatabaseObject)queue.poll();
            result.add(databaseObject);
            for (DatabaseMetadataRetriever.DatabaseObject succ : graph.successors((Object)databaseObject)) {
                int newVal = (Integer)inDegree.get(succ) - 1;
                inDegree.put(succ, newVal);
                if (newVal != 0) continue;
                queue.add(succ);
            }
        }
        return result;
    }
}

