/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.data.collection;

import org.apache.baremaps.data.collection.AppendOnlyLog;
import org.apache.baremaps.data.collection.DataList;
import org.apache.baremaps.data.collection.MemoryAlignedDataList;
import org.apache.baremaps.data.type.LongDataType;

public class IndexedDataList<E>
implements DataList<E> {
    private final DataList<Long> index;
    private final AppendOnlyLog<E> values;

    public IndexedDataList(AppendOnlyLog<E> values) {
        this(new MemoryAlignedDataList<Long>(new LongDataType()), values);
    }

    public IndexedDataList(DataList<Long> index, AppendOnlyLog<E> values) {
        this.index = index;
        this.values = values;
    }

    @Override
    public long addIndexed(E value) {
        long position = this.values.addPositioned(value);
        return this.index.addIndexed(position);
    }

    @Override
    public void set(long index, E value) {
        long position = this.values.addPositioned(value);
        this.index.set(index, position);
    }

    @Override
    public E get(long index) {
        long position = this.index.get(index);
        return this.values.getPositioned(position);
    }

    @Override
    public long size() {
        return this.index.size();
    }

    @Override
    public void clear() {
        this.index.clear();
        this.values.clear();
    }
}

