/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.data.collection;

import java.util.Iterator;
import java.util.Map;
import org.apache.baremaps.data.collection.AppendOnlyLog;
import org.apache.baremaps.data.collection.DataList;
import org.apache.baremaps.data.collection.DataMap;
import org.apache.baremaps.data.collection.MemoryAlignedDataList;
import org.apache.baremaps.data.type.LongDataType;
import org.apache.baremaps.data.type.PairDataType;

public class MonotonicDataMap<E>
implements DataMap<Long, E> {
    private final DataList<Long> offsets;
    private final DataList<PairDataType.Pair<Long, Long>> keys;
    private final AppendOnlyLog<E> values;
    private long lastChunk = -1L;

    public MonotonicDataMap(AppendOnlyLog<E> values) {
        this(new MemoryAlignedDataList<Long>(new LongDataType()), new MemoryAlignedDataList<PairDataType.Pair<Long, Long>>(new PairDataType<Long, Long>(new LongDataType(), new LongDataType())), values);
    }

    public MonotonicDataMap(DataList<PairDataType.Pair<Long, Long>> keys, AppendOnlyLog<E> values) {
        this(new MemoryAlignedDataList<Long>(new LongDataType()), keys, values);
    }

    public MonotonicDataMap(DataList<Long> offsets, DataList<PairDataType.Pair<Long, Long>> keys, AppendOnlyLog<E> values) {
        this.offsets = offsets;
        this.keys = keys;
        this.values = values;
    }

    @Override
    public E put(Long key, E value) {
        long index = this.keys.size();
        long chunk = key >>> 8;
        if (chunk != this.lastChunk) {
            while (this.offsets.size() <= chunk) {
                this.offsets.add(index);
            }
            this.lastChunk = chunk;
        }
        long position = this.values.addPositioned(value);
        this.keys.add(new PairDataType.Pair<Long, Long>(key, position));
        return null;
    }

    @Override
    public E get(Object keyObject) {
        long key = (Long)keyObject;
        long chunk = key >>> 8;
        if (chunk >= this.offsets.size()) {
            return null;
        }
        long lo = this.offsets.get(chunk);
        long hi = Math.min(this.keys.size(), chunk >= this.offsets.size() - 1L ? this.keys.size() : this.offsets.get(chunk + 1L).longValue()) - 1L;
        while (lo <= hi) {
            long index = lo + hi >>> 1;
            PairDataType.Pair<Long, Long> pair = this.keys.get(index);
            long value = pair.left();
            if (value < key) {
                lo = index + 1L;
                continue;
            }
            if (value > key) {
                hi = index - 1L;
                continue;
            }
            return this.values.getPositioned(pair.right());
        }
        return null;
    }

    @Override
    public Iterator<Long> keyIterator() {
        return this.keys.stream().map(PairDataType.Pair::left).iterator();
    }

    @Override
    public Iterator<E> valueIterator() {
        return this.keys.stream().map(PairDataType.Pair::right).map(this.values::getPositioned).iterator();
    }

    @Override
    public Iterator<Map.Entry<Long, E>> entryIterator() {
        return this.keys.stream().map(p -> Map.entry((Long)p.left(), this.values.getPositioned((Long)p.right()))).iterator();
    }

    @Override
    public long size() {
        return this.keys.size();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        return this.values.contains(value);
    }

    @Override
    public void clear() {
        this.offsets.clear();
        this.keys.clear();
        this.values.clear();
    }
}

