/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.internal;

import java.util.List;
import org.apache.sis.measure.Units;
import org.apache.sis.metadata.ModifiableMetadata;
import org.apache.sis.metadata.internal.RecordSchemaSIS;
import org.apache.sis.metadata.iso.quality.DefaultAbsoluteExternalPositionalAccuracy;
import org.apache.sis.metadata.iso.quality.DefaultQuantitativeResult;
import org.apache.sis.util.Static;
import org.apache.sis.util.collection.WeakValueHashMap;
import org.apache.sis.util.iso.DefaultRecord;
import org.apache.sis.util.iso.DefaultRecordType;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.metadata.quality.EvaluationMethodType;
import org.opengis.metadata.quality.PositionalAccuracy;
import org.opengis.util.InternationalString;

public final class TransformationAccuracy
extends Static {
    private static final InternationalString TRANSFORMATION_ACCURACY = Vocabulary.formatInternational((short)200);
    private static final WeakValueHashMap<Double, PositionalAccuracy> CACHE = new WeakValueHashMap(Double.class);

    private TransformationAccuracy() {
    }

    public static PositionalAccuracy create(Double accuracy) {
        PositionalAccuracy p = (PositionalAccuracy)CACHE.get((Object)accuracy);
        if (p == null) {
            DefaultRecordType type = RecordSchemaSIS.REAL;
            DefaultRecord record = new DefaultRecord(type);
            record.setAll(accuracy);
            DefaultQuantitativeResult result = new DefaultQuantitativeResult();
            result.setValues(List.of(record));
            result.setValueUnit(Units.METRE);
            result.setValueType(type);
            DefaultAbsoluteExternalPositionalAccuracy element = new DefaultAbsoluteExternalPositionalAccuracy(result);
            element.setNamesOfMeasure(List.of(TRANSFORMATION_ACCURACY));
            element.setEvaluationMethodType(EvaluationMethodType.DIRECT_EXTERNAL);
            element.transitionTo(ModifiableMetadata.State.FINAL);
            p = (PositionalAccuracy)CACHE.putIfAbsent((Object)accuracy, (Object)element);
            if (p == null) {
                p = element;
            }
        }
        return p;
    }
}

