/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.extent;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.function.BinaryOperator;
import org.apache.sis.metadata.TitleProperty;
import org.apache.sis.metadata.internal.ReferencingServices;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.apache.sis.metadata.iso.extent.Extents;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Emptiable;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.util.iso.Types;
import org.apache.sis.xml.NilObject;
import org.apache.sis.xml.NilReason;
import org.opengis.geometry.Envelope;
import org.opengis.metadata.extent.Extent;
import org.opengis.metadata.extent.GeographicExtent;
import org.opengis.metadata.extent.TemporalExtent;
import org.opengis.metadata.extent.VerticalExtent;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.InternationalString;

@TitleProperty(name="description")
@XmlType(name="EX_Extent_Type", propOrder={"description", "geographicElements", "temporalElements", "verticalElements"})
@XmlRootElement(name="EX_Extent")
public class DefaultExtent
extends ISOMetadata
implements Extent {
    private static final long serialVersionUID = 2979058128422252800L;
    private InternationalString description;
    private Collection<GeographicExtent> geographicElements;
    private Collection<VerticalExtent> verticalElements;
    private Collection<TemporalExtent> temporalElements;

    public DefaultExtent() {
    }

    public DefaultExtent(CharSequence description, GeographicExtent geographicElements, VerticalExtent verticalElements, TemporalExtent temporalElements) {
        this.description = Types.toInternationalString(description);
        this.geographicElements = this.singleton(geographicElements, GeographicExtent.class);
        this.verticalElements = this.singleton(verticalElements, VerticalExtent.class);
        this.temporalElements = this.singleton(temporalElements, TemporalExtent.class);
    }

    public DefaultExtent(Extent object) {
        super(object);
        if (object != null) {
            this.description = object.getDescription();
            this.geographicElements = this.copyCollection(object.getGeographicElements(), GeographicExtent.class);
            this.temporalElements = this.copyCollection(object.getTemporalElements(), TemporalExtent.class);
            this.verticalElements = this.copyCollection(object.getVerticalElements(), VerticalExtent.class);
        }
    }

    public static DefaultExtent castOrCopy(Extent object) {
        if (object == null || object instanceof DefaultExtent) {
            return (DefaultExtent)object;
        }
        return new DefaultExtent(object);
    }

    @XmlElement(name="description")
    public InternationalString getDescription() {
        return this.description;
    }

    public void setDescription(InternationalString newValue) {
        this.checkWritePermission(this.description);
        this.description = newValue;
    }

    @XmlElement(name="geographicElement")
    public Collection<GeographicExtent> getGeographicElements() {
        this.geographicElements = this.nonNullCollection(this.geographicElements, GeographicExtent.class);
        return this.geographicElements;
    }

    public void setGeographicElements(Collection<? extends GeographicExtent> newValues) {
        this.geographicElements = this.writeCollection(newValues, this.geographicElements, GeographicExtent.class);
    }

    @XmlElement(name="verticalElement")
    public Collection<VerticalExtent> getVerticalElements() {
        this.verticalElements = this.nonNullCollection(this.verticalElements, VerticalExtent.class);
        return this.verticalElements;
    }

    public void setVerticalElements(Collection<? extends VerticalExtent> newValues) {
        this.verticalElements = this.writeCollection(newValues, this.verticalElements, VerticalExtent.class);
    }

    @XmlElement(name="temporalElement")
    public Collection<TemporalExtent> getTemporalElements() {
        this.temporalElements = this.nonNullCollection(this.temporalElements, TemporalExtent.class);
        return this.temporalElements;
    }

    public void setTemporalElements(Collection<? extends TemporalExtent> newValues) {
        this.temporalElements = this.writeCollection(newValues, this.temporalElements, TemporalExtent.class);
    }

    private Boolean isNonEmpty() {
        return this.geographicElements != null || this.verticalElements != null || this.temporalElements != null || this.description != null ? Boolean.TRUE : null;
    }

    public void addElements(Envelope envelope) throws TransformException {
        this.checkWritePermission(this.isNonEmpty());
        ArgumentChecks.ensureNonNull((String)"envelope", (Object)envelope);
        ReferencingServices.getInstance().addElements(envelope, this);
    }

    public void intersect(Extent other) {
        this.checkWritePermission(this.isNonEmpty());
        ArgumentChecks.ensureNonNull((String)"other", (Object)other);
        InternationalString od = other.getDescription();
        if (od != null && !(this.description instanceof NilObject)) {
            if (this.description == null || od instanceof NilObject) {
                this.description = od;
            } else if (!this.description.equals(od)) {
                this.description = NilReason.MISSING.createNilObject(InternationalString.class);
            }
        }
        this.geographicElements = this.intersect(GeographicExtent.class, this.geographicElements, other.getGeographicElements(), Extents::intersection);
        this.verticalElements = this.intersect(VerticalExtent.class, this.verticalElements, other.getVerticalElements(), Extents::intersection);
        this.temporalElements = this.intersect(TemporalExtent.class, this.temporalElements, other.getTemporalElements(), Extents::intersection);
    }

    private <T> Collection<T> intersect(Class<T> type, Collection<T> targets, Collection<? extends T> sources, BinaryOperator<T> intersect) {
        if (!Containers.isNullOrEmpty(sources)) {
            if (!Containers.isNullOrEmpty(targets)) {
                LinkedHashSet<T> results = new LinkedHashSet<T>(Containers.hashMapCapacity((int)targets.size()));
                Object empty = null;
                for (Object target : targets) {
                    for (T source : sources) {
                        Object e = intersect.apply(target, source);
                        results.add(e);
                        if (empty != null || e == source || e == target || !(e instanceof Emptiable) || !((Emptiable)e).isEmpty()) continue;
                        empty = e;
                    }
                }
                results.remove(null);
                if (results.size() > 1) {
                    results.remove(empty);
                }
                sources = results;
            }
            targets = this.writeCollection(sources, targets, type);
        }
        return targets;
    }
}

