/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.xml.bind.gts;

import jakarta.xml.bind.annotation.XmlElement;
import java.math.BigDecimal;
import java.math.BigInteger;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import org.apache.sis.metadata.internal.TemporalUtilities;
import org.apache.sis.pending.geoapi.temporal.TemporalFactory;
import org.apache.sis.util.SimpleInternationalString;
import org.apache.sis.xml.bind.Context;
import org.apache.sis.xml.bind.gco.PropertyType;
import org.apache.sis.xml.util.XmlUtilities;
import org.opengis.temporal.PeriodDuration;
import org.opengis.util.InternationalString;

public class TM_PeriodDuration
extends PropertyType<TM_PeriodDuration, PeriodDuration> {
    public TM_PeriodDuration() {
    }

    private TM_PeriodDuration(PeriodDuration metadata) {
        super(metadata);
    }

    @Override
    protected TM_PeriodDuration wrap(PeriodDuration value) {
        return new TM_PeriodDuration(value);
    }

    @Override
    protected final Class<PeriodDuration> getBoundType() {
        return PeriodDuration.class;
    }

    @XmlElement(name="TM_PeriodDuration")
    public final Duration getElement() {
        return TM_PeriodDuration.toXML((PeriodDuration)this.metadata);
    }

    static Duration toXML(PeriodDuration duration) {
        if (duration instanceof org.apache.sis.pending.geoapi.temporal.PeriodDuration) {
            try {
                org.apache.sis.pending.geoapi.temporal.PeriodDuration metadata = (org.apache.sis.pending.geoapi.temporal.PeriodDuration)duration;
                DatatypeFactory factory = XmlUtilities.getDatatypeFactory();
                BigInteger years = null;
                InternationalString value = metadata.getYears();
                if (value != null) {
                    years = new BigInteger(value.toString());
                }
                BigInteger months = null;
                value = metadata.getMonths();
                if (value != null) {
                    months = new BigInteger(value.toString());
                }
                BigInteger days = null;
                value = metadata.getDays();
                if (value != null) {
                    days = new BigInteger(value.toString());
                }
                BigInteger hours = null;
                value = metadata.getHours();
                if (value != null) {
                    hours = new BigInteger(value.toString());
                }
                BigInteger minutes = null;
                value = metadata.getMinutes();
                if (value != null) {
                    minutes = new BigInteger(value.toString());
                }
                BigDecimal seconds = null;
                value = metadata.getSeconds();
                if (value != null) {
                    seconds = new BigDecimal(value.toString());
                }
                return factory.newDuration(true, years, months, days, hours, minutes, seconds);
            }
            catch (DatatypeConfigurationException e) {
                Context.warningOccured(Context.current(), TM_PeriodDuration.class, "toXML", e, true);
            }
        }
        return null;
    }

    public final void setElement(Duration duration) {
        this.metadata = TM_PeriodDuration.toISO(duration);
    }

    static PeriodDuration toISO(Duration duration) {
        if (duration != null) {
            TemporalFactory factory = TemporalUtilities.getTemporalFactory();
            SimpleInternationalString years = null;
            int value = duration.getYears();
            if (value != 0) {
                years = new SimpleInternationalString(Integer.toString(value));
            }
            SimpleInternationalString months = null;
            value = duration.getMonths();
            if (value != 0) {
                months = new SimpleInternationalString(Integer.toString(value));
            }
            InternationalString weeks = null;
            SimpleInternationalString days = null;
            value = duration.getDays();
            if (value != 0) {
                days = new SimpleInternationalString(Integer.toString(value));
            }
            SimpleInternationalString hours = null;
            value = duration.getHours();
            if (value != 0) {
                hours = new SimpleInternationalString(Integer.toString(value));
            }
            SimpleInternationalString minutes = null;
            value = duration.getMinutes();
            if (value != 0) {
                minutes = new SimpleInternationalString(Integer.toString(value));
            }
            SimpleInternationalString seconds = null;
            value = duration.getSeconds();
            if (value != 0) {
                seconds = new SimpleInternationalString(Integer.toString(value));
            }
            return factory.createPeriodDuration((InternationalString)years, (InternationalString)months, weeks, (InternationalString)days, (InternationalString)hours, (InternationalString)minutes, (InternationalString)seconds);
        }
        return null;
    }

    public static final class Since2014
    extends TM_PeriodDuration {
        @Override
        protected TM_PeriodDuration wrap(PeriodDuration value) {
            return this.accept2014() ? super.wrap(value) : null;
        }
    }
}

