/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.message;

import java.util.Objects;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.util.StringBuilderFormattable;

public class SimpleMessage
implements Message,
StringBuilderFormattable,
CharSequence {
    private String message;
    private final CharSequence charSequence;

    public SimpleMessage() {
        this(null);
    }

    public SimpleMessage(String message) {
        this.message = message;
        this.charSequence = message;
    }

    public SimpleMessage(CharSequence charSequence) {
        this.charSequence = charSequence;
    }

    @Override
    public String getFormattedMessage() {
        this.message = this.message == null ? String.valueOf(this.charSequence) : this.message;
        return this.message;
    }

    @Override
    public void formatTo(StringBuilder buffer) {
        buffer.append(this.message != null ? this.message : this.charSequence);
    }

    @Override
    public String getFormat() {
        return this.message;
    }

    @Override
    public Object[] getParameters() {
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SimpleMessage)) {
            return false;
        }
        SimpleMessage that = (SimpleMessage)o;
        return Objects.equals(this.charSequence, that.charSequence) || Objects.equals(this.getFormattedMessage(), that.getFormattedMessage());
    }

    public int hashCode() {
        return Objects.hash(this.getFormattedMessage());
    }

    @Override
    public String toString() {
        return this.getFormattedMessage();
    }

    @Override
    public Throwable getThrowable() {
        return null;
    }

    @Override
    public int length() {
        return this.charSequence == null ? 0 : this.charSequence.length();
    }

    @Override
    public char charAt(int index) {
        return this.charSequence.charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.charSequence.subSequence(start, end);
    }
}

