/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.utils;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Supplier;
import software.amazon.awssdk.annotations.Immutable;
import software.amazon.awssdk.annotations.SdkProtectedApi;
import software.amazon.awssdk.annotations.ToBuilderIgnoreField;
import software.amazon.awssdk.utils.IoUtils;
import software.amazon.awssdk.utils.SdkAutoCloseable;
import software.amazon.awssdk.utils.Validate;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@SdkProtectedApi
@Immutable
public final class AttributeMap
implements ToCopyableBuilder<Builder, AttributeMap>,
SdkAutoCloseable {
    private static final AttributeMap EMPTY = AttributeMap.builder().build();
    private final Map<Key<?>, Value<?>> attributes;
    private final DependencyGraph dependencyGraph;

    private AttributeMap(Builder builder) {
        this.attributes = builder.attributes;
        this.dependencyGraph = builder.dependencyGraph;
    }

    public <T> boolean containsKey(Key<T> typedKey) {
        return this.attributes.containsKey(typedKey);
    }

    public <T> T get(Key<T> key) {
        Validate.notNull(key, "Key to retrieve must not be null.", new Object[0]);
        Value<?> value = this.attributes.get(key);
        if (value == null) {
            return null;
        }
        return key.convertValue(value.get(new ExpectCachedLazyValueSource()));
    }

    public AttributeMap merge(AttributeMap lowerPrecedence) {
        Builder resultBuilder = new Builder(this);
        lowerPrecedence.attributes.forEach((k, v) -> resultBuilder.internalComputeIfAbsent(k, () -> {
            Value result = v.copy();
            result.clearCache();
            return result;
        }));
        return resultBuilder.build();
    }

    public static AttributeMap empty() {
        return EMPTY;
    }

    @Override
    public void close() {
        this.attributes.values().forEach(SdkAutoCloseable::close);
    }

    public String toString() {
        return this.attributes.toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AttributeMap)) {
            return false;
        }
        AttributeMap rhs = (AttributeMap)obj;
        if (this.attributes.size() != rhs.attributes.size()) {
            return false;
        }
        for (Key<?> lhsKey : this.attributes.keySet()) {
            Object rhsValue;
            Object lhsValue = this.get(lhsKey);
            if (Objects.equals(lhsValue, rhsValue = rhs.get(lhsKey))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 1;
        for (Key<?> key : this.attributes.keySet()) {
            hashCode = 31 * hashCode + Objects.hashCode(this.get(key));
        }
        return hashCode;
    }

    public AttributeMap copy() {
        return this.toBuilder().build();
    }

    @Override
    @ToBuilderIgnoreField(value={"configuration"})
    public Builder toBuilder() {
        return new Builder(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    private static void closeIfPossible(Object object) {
        if (object instanceof ExecutorService) {
            ((ExecutorService)object).shutdown();
        } else {
            IoUtils.closeIfCloseable(object, null);
        }
    }

    static class ExpectCachedLazyValueSource
    implements LazyValueSource {
        ExpectCachedLazyValueSource() {
        }

        @Override
        public <T> T get(Key<T> sourceKey) {
            throw new IllegalStateException("Value should be cached.");
        }
    }

    private static class CachedValue<T> {
        private final T value;

        private CachedValue(T value) {
            this.value = value;
        }

        private static boolean haveSameCachedValues(CachedValue<?> lhs, CachedValue<?> rhs) {
            if (lhs == null || rhs == null) {
                return false;
            }
            return lhs.value == rhs.value;
        }
    }

    private static final class DerivedValue<T>
    implements Value<T> {
        private final LazyValue<T> lazyValue;
        private boolean valueCached = false;
        private T value;
        private boolean onStack = false;

        private DerivedValue(LazyValue<T> lazyValue) {
            this.lazyValue = lazyValue;
        }

        private DerivedValue(LazyValue<T> lazyValue, boolean valueCached, T value) {
            this.lazyValue = lazyValue;
            this.valueCached = valueCached;
            this.value = value;
        }

        @Override
        public T get(LazyValueSource source) {
            this.primeCache(source);
            return this.value;
        }

        private void primeCache(LazyValueSource source) {
            if (!this.valueCached) {
                if (this.onStack) {
                    throw new IllegalStateException("Derived key attempted to read itself");
                }
                try {
                    this.onStack = true;
                    this.value = this.lazyValue.get(source);
                }
                finally {
                    this.onStack = false;
                }
                this.valueCached = true;
            }
        }

        @Override
        public Value<T> copy() {
            return new DerivedValue<T>(this.lazyValue, this.valueCached, this.value);
        }

        @Override
        public void clearCache() {
            this.valueCached = false;
        }

        @Override
        public CachedValue<T> cachedValue() {
            if (!this.valueCached) {
                return null;
            }
            return new CachedValue(this.value);
        }

        @Override
        public void close() {
            AttributeMap.closeIfPossible(this.value);
        }

        public String toString() {
            if (this.valueCached) {
                return "Value(" + this.value + ")";
            }
            return "Value(<<lazy>>)";
        }
    }

    private static class ConstantValue<T>
    implements Value<T> {
        private final T value;

        private ConstantValue(T value) {
            this.value = value;
        }

        @Override
        public T get(LazyValueSource source) {
            return this.value;
        }

        @Override
        public Value<T> copy() {
            return this;
        }

        @Override
        public void clearCache() {
        }

        @Override
        public CachedValue<T> cachedValue() {
            return new CachedValue(this.value);
        }

        @Override
        public void close() {
            AttributeMap.closeIfPossible(this.value);
        }

        public String toString() {
            return "Value(" + this.value + ")";
        }
    }

    private static interface Value<T>
    extends SdkAutoCloseable {
        public T get(LazyValueSource var1);

        public Value<T> copy();

        public void clearCache();

        public CachedValue<T> cachedValue();
    }

    private static final class DependencyGraph {
        private final Map<Value<?>, Set<Value<?>>> dependents;

        private DependencyGraph() {
            this.dependents = new IdentityHashMap();
        }

        private DependencyGraph(DependencyGraph source, Map<Value<?>, Value<?>> valueRemapping) {
            this.dependents = new IdentityHashMap(source.dependents.size());
            source.dependents.forEach((key, values) -> {
                HashSet newValues = new HashSet(values.size());
                Value remappedKey = (Value)valueRemapping.get(key);
                Validate.notNull(remappedKey, "Remapped key must not be null.", new Object[0]);
                this.dependents.put(remappedKey, newValues);
                values.forEach(v -> {
                    Value remappedValue = (Value)valueRemapping.get(v);
                    Validate.notNull(remappedValue, "Remapped value must not be null.", new Object[0]);
                    newValues.add(remappedValue);
                });
            });
        }

        private void addDependency(Value<?> consumer, Value<?> dependency) {
            Validate.notNull(consumer, "Consumer must not be null.", new Object[0]);
            this.dependents.computeIfAbsent(dependency, k -> new HashSet()).add(consumer);
        }

        private void valueUpdated(Value<?> oldValue, Value<?> newValue) {
            Set<Value<?>> oldValueDependents;
            CachedValue<?> newCachedValue;
            if (oldValue == newValue) {
                return;
            }
            CachedValue<?> oldCachedValue = oldValue.cachedValue();
            if (!CachedValue.haveSameCachedValues((CachedValue)oldCachedValue, (CachedValue)(newCachedValue = newValue.cachedValue()))) {
                this.invalidateConsumerCaches(oldValue);
            }
            if ((oldValueDependents = this.dependents.remove(oldValue)) != null) {
                this.dependents.put(newValue, oldValueDependents);
            }
            this.dependents.values().forEach(v -> {
                if (v.remove(oldValue)) {
                    v.add(newValue);
                }
            });
        }

        private void invalidateConsumerCaches(Value<?> value) {
            ArrayDeque unloadQueue = new ArrayDeque();
            unloadQueue.add(value);
            while (!unloadQueue.isEmpty()) {
                Value toUnload = (Value)unloadQueue.poll();
                toUnload.clearCache();
                Set<Value<?>> toUnloadDependents = this.dependents.remove(toUnload);
                if (toUnloadDependents == null) continue;
                unloadQueue.addAll(toUnloadDependents);
            }
        }

        public DependencyGraph copy(Map<Value<?>, Value<?>> valueRemapping) {
            return new DependencyGraph(this, valueRemapping);
        }
    }

    @FunctionalInterface
    public static interface LazyValueSource {
        public <T> T get(Key<T> var1);
    }

    @FunctionalInterface
    public static interface LazyValue<T> {
        public T get(LazyValueSource var1);
    }

    public static final class Builder
    implements CopyableBuilder<Builder, AttributeMap> {
        private Map<Key<?>, Value<?>> attributes;
        private DependencyGraph dependencyGraph;
        private boolean copyOnUpdate;

        private Builder() {
            this.attributes = new HashMap();
            this.dependencyGraph = new DependencyGraph();
            this.copyOnUpdate = false;
        }

        private Builder(AttributeMap attributeMap) {
            this.attributes = attributeMap.attributes;
            this.dependencyGraph = attributeMap.dependencyGraph;
            this.copyOnUpdate = true;
        }

        private Builder(Builder builder) {
            this.attributes = builder.attributes;
            this.dependencyGraph = builder.dependencyGraph;
            this.copyOnUpdate = true;
            this.checkCopyOnUpdate();
        }

        public <T> T get(Key<T> key) {
            return key.convertValue(this.internalGet(null, key));
        }

        public <T> T computeIfAbsent(Key<T> key, Supplier<T> valueIfAbsent) {
            Validate.notNull(key, "Key to set must not be null.", new Object[0]);
            Value<?> result = this.internalComputeIfAbsent(key, () -> {
                Object value = valueIfAbsent.get();
                return new ConstantValue(value);
            });
            return key.convertValue(this.resolveValue(result));
        }

        public <T> Builder put(Key<T> key, T value) {
            Validate.notNull(key, "Key to set must not be null.", new Object[0]);
            this.internalPut(key, new ConstantValue(value));
            return this;
        }

        public <T> Builder putLazy(Key<T> key, LazyValue<T> lazyValue) {
            Validate.notNull(key, "Key to set must not be null.", new Object[0]);
            this.internalPut(key, new DerivedValue(lazyValue));
            return this;
        }

        public <T> Builder putLazyIfAbsent(Key<T> key, LazyValue<T> lazyValue) {
            Validate.notNull(key, "Key to set must not be null.", new Object[0]);
            this.internalComputeIfAbsent(key, () -> new DerivedValue(lazyValue));
            return this;
        }

        public Builder putAll(Map<? extends Key<?>, ?> attributes) {
            attributes.forEach(this::unsafeInternalPutConstant);
            return this;
        }

        public Builder putAll(AttributeMap attributes) {
            attributes.attributes.forEach((k, v) -> this.unsafeInternalPutConstant((Key)k, attributes.get(k)));
            return this;
        }

        private <T> void unsafeInternalPutConstant(Key<T> key, Object value) {
            try {
                T tValue = key.convertValue(value);
                this.internalPut(key, new ConstantValue(tValue));
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException("Cannot write " + value.getClass() + " type to key " + key, e);
            }
        }

        private void internalPut(Key<?> key, Value<?> value) {
            Validate.notNull(value, "Value must not be null.", new Object[0]);
            this.checkCopyOnUpdate();
            Value<?> oldValue = this.attributes.put(key, value);
            if (oldValue != null) {
                this.dependencyGraph.valueUpdated(oldValue, value);
            }
        }

        private Value<?> internalComputeIfAbsent(Key<?> key, Supplier<Value<?>> value) {
            this.checkCopyOnUpdate();
            return this.attributes.compute(key, (k, v) -> {
                if (v == null || this.resolveValue((Value)v) == null) {
                    Value newValue = (Value)value.get();
                    Validate.notNull(newValue, "Supplied value must not be null.", new Object[0]);
                    if (v != null) {
                        this.dependencyGraph.valueUpdated(v, newValue);
                    }
                    return newValue;
                }
                return v;
            });
        }

        private void checkCopyOnUpdate() {
            if (this.copyOnUpdate) {
                Map<Key<?>, Value<?>> attributesToCopy = this.attributes;
                this.attributes = new HashMap(attributesToCopy.size());
                IdentityHashMap valueRemapping = new IdentityHashMap(attributesToCopy.size());
                attributesToCopy.forEach((k, v) -> {
                    Value newValue = v.copy();
                    valueRemapping.put((Value<?>)v, newValue);
                    this.attributes.put((Key<?>)k, newValue);
                });
                this.dependencyGraph = this.dependencyGraph.copy(valueRemapping);
                this.copyOnUpdate = false;
            }
        }

        @Override
        public AttributeMap build() {
            ArrayList valuesToPrime = new ArrayList(this.attributes.values());
            valuesToPrime.forEach(this::resolveValue);
            this.copyOnUpdate = true;
            return new AttributeMap(this);
        }

        @Override
        public Builder copy() {
            return new Builder(this);
        }

        private <T> T internalGet(Value<?> requester, Key<T> key) {
            Value value;
            Validate.notNull(key, "Key to retrieve must not be null.", new Object[0]);
            if (requester != null) {
                this.checkCopyOnUpdate();
                value = this.attributes.computeIfAbsent(key, (? super K k) -> new ConstantValue(null));
                this.dependencyGraph.addDependency(requester, value);
            } else {
                value = this.attributes.get(key);
                if (value == null) {
                    return null;
                }
            }
            return key.convertValue(this.resolveValue(value));
        }

        private <T> T resolveValue(final Value<T> value) {
            Validate.notNull(value, "Encountered a null value when resolving configuration attributes. This is commonly caused by concurrent modifications to non-thread-safe types. Ensure you're synchronizing access to all non-thread-safe types.", new Object[0]);
            return value.get(new LazyValueSource(){

                public <U> U get(Key<U> innerKey) {
                    return (U)this.internalGet(value, innerKey);
                }
            });
        }
    }

    public static abstract class Key<T> {
        private final Class<?> valueType;
        private final Function<Object, T> convertMethod;

        protected Key(Class<T> valueType) {
            this.valueType = valueType;
            this.convertMethod = valueType::cast;
        }

        protected Key(UnsafeValueType unsafeValueType) {
            this.valueType = unsafeValueType.valueType;
            this.convertMethod = v -> v;
        }

        public String toString() {
            return "Key(" + this.valueType.getName() + ")";
        }

        public final T convertValue(Object value) {
            return this.convertMethod.apply(value);
        }

        protected static class UnsafeValueType {
            private final Class<?> valueType;

            public UnsafeValueType(Class<?> valueType) {
                this.valueType = valueType;
            }
        }
    }
}

