/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.provider;

import jakarta.xml.bind.annotation.XmlTransient;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.measure.Unit;
import org.apache.sis.measure.MeasurementRange;
import org.apache.sis.measure.Units;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.parameter.ParameterBuilder;
import org.apache.sis.referencing.internal.Resources;
import org.apache.sis.referencing.operation.DefaultOperationMethod;
import org.apache.sis.referencing.operation.transform.DefaultMathTransformFactory;
import org.apache.sis.referencing.operation.transform.MathTransformProvider;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.metadata.citation.Citation;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.SingleOperation;
import org.opengis.util.GenericName;

@XmlTransient
public abstract class AbstractProvider
extends DefaultOperationMethod
implements MathTransformProvider {
    private static final long serialVersionUID = 1165868434518724597L;
    static final Logger LOGGER = Logger.getLogger("org.apache.sis.referencing.operation");
    private final Class<? extends SingleOperation> operationType;
    public final Class<? extends CoordinateSystem> sourceCSType;
    public final Class<? extends CoordinateSystem> targetCSType;
    public final boolean sourceOnEllipsoid;
    public final boolean targetOnEllipsoid;

    protected AbstractProvider(Map<String, ?> properties, ParameterDescriptorGroup parameters) {
        super(properties, parameters);
        this.operationType = SingleOperation.class;
        this.sourceCSType = CoordinateSystem.class;
        this.targetCSType = CoordinateSystem.class;
        this.sourceOnEllipsoid = false;
        this.targetOnEllipsoid = false;
    }

    AbstractProvider(Class<? extends SingleOperation> operationType, ParameterDescriptorGroup parameters, Class<? extends CoordinateSystem> sourceCSType, boolean sourceOnEllipsoid, Class<? extends CoordinateSystem> targetCSType, boolean targetOnEllipsoid) {
        super(AbstractProvider.toMap((IdentifiedObject)parameters), parameters);
        this.operationType = operationType;
        this.sourceCSType = sourceCSType;
        this.targetCSType = targetCSType;
        this.sourceOnEllipsoid = sourceOnEllipsoid;
        this.targetOnEllipsoid = targetOnEllipsoid;
    }

    @Deprecated
    AbstractProvider(AbstractProvider copy) {
        super(copy);
        this.operationType = copy.operationType;
        this.sourceCSType = copy.sourceCSType;
        this.targetCSType = copy.targetCSType;
        this.sourceOnEllipsoid = copy.sourceOnEllipsoid;
        this.targetOnEllipsoid = copy.targetOnEllipsoid;
    }

    private static Map<String, Object> toMap(IdentifiedObject parameters) {
        Collection aliases;
        ArgumentChecks.ensureNonNull((String)"parameters", (Object)parameters);
        HashMap<String, Object> properties = new HashMap<String, Object>(4);
        properties.put("name", parameters.getName());
        Set identifiers = parameters.getIdentifiers();
        int size = identifiers.size();
        if (size != 0) {
            properties.put("identifiers", identifiers.toArray(new ReferenceIdentifier[size]));
        }
        if ((size = (aliases = parameters.getAlias()).size()) != 0) {
            properties.put("alias", aliases.toArray(new GenericName[size]));
        }
        return properties;
    }

    static ParameterBuilder builder() {
        return ((ParameterBuilder)new ParameterBuilder().setCodeSpace((Citation)Citations.EPSG, "EPSG")).setRequired(true);
    }

    static ParameterBuilder addNameAndLegacy(ParameterBuilder builder, String name, String legacy) {
        return (ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)builder.addName(name)).setDeprecated(true)).setRemarks((CharSequence)Vocabulary.formatInternational((short)190, (Object)name))).addName(legacy)).setDeprecated(false)).setRemarks(null);
    }

    static ParameterBuilder addIdentifierAndLegacy(ParameterBuilder builder, String code, String legacy) {
        return (ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)builder.addIdentifier(code)).setDeprecated(true)).setRemarks((CharSequence)Vocabulary.formatInternational((short)190, (Object)code))).addIdentifier(legacy)).setDeprecated(false)).setRemarks(null);
    }

    static ParameterDescriptor<Double> createZeroConstant(ParameterBuilder builder) {
        Double zero = 0.0;
        return builder.createBounded(MeasurementRange.create((double)-0.0, (boolean)true, (double)zero, (boolean)true, (Unit)Units.DEGREE), zero);
    }

    static ParameterDescriptor<Double> createMandatoryLatitude(ParameterBuilder builder) {
        return builder.createBounded(-90.0, 90.0, Double.NaN, Units.DEGREE);
    }

    static ParameterDescriptor<Double> createLatitude(ParameterBuilder builder, boolean includePoles) {
        return builder.createBounded(MeasurementRange.create((double)-90.0, (boolean)includePoles, (double)90.0, (boolean)includePoles, (Unit)Units.DEGREE), 0.0);
    }

    static ParameterDescriptor<Double> createLongitude(ParameterBuilder builder) {
        return builder.createBounded(-180.0, 180.0, 0.0, Units.DEGREE);
    }

    static ParameterDescriptor<Double> createScale(ParameterBuilder builder) {
        return builder.createStrictlyPositive(1.0, Units.UNITY);
    }

    static ParameterDescriptor<Double> createShift(ParameterBuilder builder) {
        return builder.create(0.0, Units.METRE);
    }

    public String resolveAmbiguity(DefaultMathTransformFactory.Context context) {
        return null;
    }

    @Override
    public final Class<? extends SingleOperation> getOperationType() {
        return this.operationType;
    }

    public AbstractProvider variantFor(MathTransform transform) {
        return this.redimension(transform.getSourceDimensions(), transform.getTargetDimensions());
    }

    public AbstractProvider redimension(int sourceDimensions, int targetDimensions) {
        ArgumentChecks.ensureStrictlyPositive((String)"sourceDimensions", (int)sourceDimensions);
        ArgumentChecks.ensureStrictlyPositive((String)"targetDimensions", (int)targetDimensions);
        Integer src = this.getSourceDimensions();
        Integer tgt = this.getTargetDimensions();
        if (!(src != null && src != sourceDimensions || tgt != null && tgt != targetDimensions)) {
            return this;
        }
        throw new IllegalArgumentException(Resources.format((short)21, this.getName().getCode(), sourceDimensions, targetDimensions));
    }

    public AbstractProvider inverse() {
        return null;
    }

    static void recoverableException(Class<? extends AbstractProvider> caller, Exception e) {
        Logging.recoverableException((Logger)LOGGER, caller, (String)"createMathTransform", (Throwable)e);
    }
}

