/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.catalog;

import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.gravitino.Audit;
import org.apache.gravitino.StringIdentifier;
import org.apache.gravitino.messaging.Topic;
import org.apache.gravitino.meta.AuditInfo;
import org.apache.gravitino.meta.TopicEntity;

public class EntityCombinedTopic
implements Topic {
    private final Topic topic;
    private final TopicEntity topicEntity;
    private Set<String> hiddenProperties;
    private boolean imported;

    private EntityCombinedTopic(Topic topic, TopicEntity topicEntity) {
        this.topic = topic;
        this.topicEntity = topicEntity;
        this.imported = false;
    }

    public static EntityCombinedTopic of(Topic topic, TopicEntity topicEntity) {
        return new EntityCombinedTopic(topic, topicEntity);
    }

    public static EntityCombinedTopic of(Topic topic) {
        return new EntityCombinedTopic(topic, null);
    }

    public EntityCombinedTopic withHiddenPropertiesSet(Set<String> hiddenProperties) {
        this.hiddenProperties = hiddenProperties;
        return this;
    }

    public EntityCombinedTopic withImported(boolean imported) {
        this.imported = imported;
        return this;
    }

    public String name() {
        return this.topic.name();
    }

    public String comment() {
        return this.topicEntity == null ? this.topic.comment() : this.topicEntity.comment();
    }

    public Map<String, String> properties() {
        return this.topic.properties().entrySet().stream().filter(p -> !this.hiddenProperties.contains(p.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public Audit auditInfo() {
        AuditInfo mergedAudit = AuditInfo.builder().withCreator(this.topic.auditInfo().creator()).withCreateTime(this.topic.auditInfo().createTime()).withLastModifier(this.topic.auditInfo().lastModifier()).withLastModifiedTime(this.topic.auditInfo().lastModifiedTime()).build();
        return this.topicEntity == null ? this.topic.auditInfo() : mergedAudit.merge(this.topicEntity.auditInfo(), true);
    }

    public boolean imported() {
        return this.imported;
    }

    StringIdentifier stringIdentifier() {
        return StringIdentifier.fromProperties(this.topic.properties());
    }
}

