/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.dto.requests;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.Catalog;
import org.apache.gravitino.rest.RESTRequest;

public class CatalogCreateRequest
implements RESTRequest {
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="type")
    private final Catalog.Type type;
    @JsonProperty(value="provider")
    private final String provider;
    @Nullable
    @JsonProperty(value="comment")
    private final String comment;
    @Nullable
    @JsonProperty(value="properties")
    private final Map<String, String> properties;

    public CatalogCreateRequest() {
        this(null, null, null, null, null);
    }

    public CatalogCreateRequest(String name, Catalog.Type type, String provider, String comment, Map<String, String> properties) {
        this.name = name;
        this.type = type;
        this.provider = provider;
        this.comment = comment;
        this.properties = properties;
    }

    @Override
    public void validate() throws IllegalArgumentException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.name), (Object)"\"name\" field is required and cannot be empty");
        Preconditions.checkArgument((this.type != null ? 1 : 0) != 0, (Object)"\"type\" field is required and cannot be empty");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.provider), (Object)"\"provider\" field is required and cannot be empty");
    }

    public String getName() {
        return this.name;
    }

    public Catalog.Type getType() {
        return this.type;
    }

    public String getProvider() {
        return this.provider;
    }

    @Nullable
    public String getComment() {
        return this.comment;
    }

    @Nullable
    public Map<String, String> getProperties() {
        return this.properties;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CatalogCreateRequest)) {
            return false;
        }
        CatalogCreateRequest other = (CatalogCreateRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Catalog.Type this$type = this.getType();
        Catalog.Type other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$provider = this.getProvider();
        String other$provider = other.getProvider();
        if (this$provider == null ? other$provider != null : !this$provider.equals(other$provider)) {
            return false;
        }
        String this$comment = this.getComment();
        String other$comment = other.getComment();
        if (this$comment == null ? other$comment != null : !this$comment.equals(other$comment)) {
            return false;
        }
        Map<String, String> this$properties = this.getProperties();
        Map<String, String> other$properties = other.getProperties();
        return !(this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CatalogCreateRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Catalog.Type $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $provider = this.getProvider();
        result = result * 59 + ($provider == null ? 43 : $provider.hashCode());
        String $comment = this.getComment();
        result = result * 59 + ($comment == null ? 43 : $comment.hashCode());
        Map<String, String> $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        return result;
    }

    public String toString() {
        return "CatalogCreateRequest(name=" + this.getName() + ", type=" + this.getType() + ", provider=" + this.getProvider() + ", comment=" + this.getComment() + ", properties=" + this.getProperties() + ")";
    }
}

