/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.dubbo.common.BaseServiceMetadata;
import org.apache.dubbo.common.context.FrameworkExt;
import org.apache.dubbo.common.context.LifecycleAdapter;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.config.ReferenceConfigBase;
import org.apache.dubbo.config.ServiceConfigBase;
import org.apache.dubbo.rpc.model.BuiltinServiceDetector;
import org.apache.dubbo.rpc.model.ConsumerModel;
import org.apache.dubbo.rpc.model.MethodDescriptor;
import org.apache.dubbo.rpc.model.ProviderModel;
import org.apache.dubbo.rpc.model.ServiceDescriptor;
import org.apache.dubbo.rpc.model.ServiceMetadata;

public class ServiceRepository
extends LifecycleAdapter
implements FrameworkExt {
    public static final String NAME = "repository";
    private ConcurrentMap<String, ServiceDescriptor> services = new ConcurrentHashMap<String, ServiceDescriptor>();
    private ConcurrentMap<String, ConsumerModel> consumers = new ConcurrentHashMap<String, ConsumerModel>();
    private ConcurrentMap<String, ProviderModel> providers = new ConcurrentHashMap<String, ProviderModel>();
    private ConcurrentMap<String, ProviderModel> providersWithoutGroup = new ConcurrentHashMap<String, ProviderModel>();

    public ServiceRepository() {
        Set<BuiltinServiceDetector> builtinServices = ExtensionLoader.getExtensionLoader(BuiltinServiceDetector.class).getSupportedExtensionInstances();
        if (CollectionUtils.isNotEmpty(builtinServices)) {
            for (BuiltinServiceDetector service : builtinServices) {
                this.registerService(service.getService());
            }
        }
    }

    public ServiceDescriptor registerService(Class<?> interfaceClazz) {
        return this.services.computeIfAbsent(interfaceClazz.getName(), _k -> new ServiceDescriptor(interfaceClazz));
    }

    public ServiceDescriptor registerService(String path, Class<?> interfaceClass) {
        ServiceDescriptor serviceDescriptor = this.registerService(interfaceClass);
        if (!interfaceClass.getName().equals(path)) {
            this.services.putIfAbsent(path, serviceDescriptor);
        }
        return serviceDescriptor;
    }

    public void unregisterService(Class<?> interfaceClazz) {
        this.unregisterService(interfaceClazz.getName());
    }

    public void unregisterService(String path) {
        this.services.remove(path);
    }

    public void registerConsumer(String serviceKey, ServiceDescriptor serviceDescriptor, ReferenceConfigBase<?> rc, Object proxy, ServiceMetadata serviceMetadata) {
        ConsumerModel consumerModel = new ConsumerModel(serviceMetadata.getServiceKey(), proxy, serviceDescriptor, rc, serviceMetadata);
        this.consumers.putIfAbsent(serviceKey, consumerModel);
    }

    public void reRegisterConsumer(String newServiceKey, String serviceKey) {
        ConsumerModel consumerModel = (ConsumerModel)this.consumers.get(serviceKey);
        consumerModel.setServiceKey(newServiceKey);
        this.consumers.putIfAbsent(newServiceKey, consumerModel);
        this.consumers.remove(serviceKey);
    }

    public void registerProvider(String serviceKey, Object serviceInstance, ServiceDescriptor serviceModel, ServiceConfigBase<?> serviceConfig, ServiceMetadata serviceMetadata) {
        ProviderModel providerModel = new ProviderModel(serviceKey, serviceInstance, serviceModel, serviceConfig, serviceMetadata);
        this.providers.putIfAbsent(serviceKey, providerModel);
        this.providersWithoutGroup.putIfAbsent(ServiceRepository.keyWithoutGroup(serviceKey), providerModel);
    }

    private static String keyWithoutGroup(String serviceKey) {
        return BaseServiceMetadata.interfaceFromServiceKey(serviceKey) + ":" + BaseServiceMetadata.versionFromServiceKey(serviceKey);
    }

    public void reRegisterProvider(String newServiceKey, String serviceKey) {
        ProviderModel providerModel = (ProviderModel)this.providers.get(serviceKey);
        providerModel.setServiceKey(newServiceKey);
        this.providers.putIfAbsent(newServiceKey, providerModel);
        this.providers.remove(serviceKey);
    }

    public List<ServiceDescriptor> getAllServices() {
        return Collections.unmodifiableList(new ArrayList(this.services.values()));
    }

    public ServiceDescriptor lookupService(String interfaceName) {
        return (ServiceDescriptor)this.services.get(interfaceName);
    }

    public MethodDescriptor lookupMethod(String interfaceName, String methodName) {
        ServiceDescriptor serviceDescriptor = this.lookupService(interfaceName);
        if (serviceDescriptor == null) {
            return null;
        }
        List<MethodDescriptor> methods = serviceDescriptor.getMethods(methodName);
        if (CollectionUtils.isEmpty(methods)) {
            return null;
        }
        return methods.iterator().next();
    }

    public List<ProviderModel> getExportedServices() {
        return Collections.unmodifiableList(new ArrayList(this.providers.values()));
    }

    public ProviderModel lookupExportedService(String serviceKey) {
        return (ProviderModel)this.providers.get(serviceKey);
    }

    public ProviderModel lookupExportedServiceWithoutGroup(String key) {
        return (ProviderModel)this.providersWithoutGroup.get(key);
    }

    public List<ConsumerModel> getReferredServices() {
        return Collections.unmodifiableList(new ArrayList(this.consumers.values()));
    }

    public ConsumerModel lookupReferredService(String serviceKey) {
        return (ConsumerModel)this.consumers.get(serviceKey);
    }

    @Override
    public void destroy() throws IllegalStateException {
        this.services.clear();
        this.consumers.clear();
        this.providers.clear();
        this.providersWithoutGroup.clear();
    }
}

