/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.data.push.client;

import com.google.common.collect.Maps;
import com.xiaomi.data.push.client.Pair;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HttpClient {
    private static final Logger logger = LoggerFactory.getLogger(HttpClient.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Pair<Integer, String> get(String url) {
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(1000).setConnectTimeout(500).setConnectionRequestTimeout(500).build();
        HttpGet get = new HttpGet(url);
        CloseableHttpClient httpClient = null;
        CloseableHttpResponse response = null;
        HttpEntity entity = null;
        String responseContent = null;
        try {
            httpClient = HttpClients.createDefault();
            get.setConfig(requestConfig);
            response = httpClient.execute((HttpUriRequest)get);
            entity = response.getEntity();
            responseContent = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
            logger.debug("http get url:{} body:{} result:{}", (Object)url, (Object)responseContent);
            Pair<Integer, String> pair = Pair.of(response.getStatusLine().getStatusCode(), responseContent);
            return pair;
        }
        catch (Exception e) {
            Pair<Integer, String> pair = Pair.of(500, e.getMessage());
            return pair;
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
                if (httpClient != null) {
                    httpClient.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String get(String url, Map<String, String> headers) {
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(1000).setConnectTimeout(500).setConnectionRequestTimeout(500).build();
        HttpGet get = new HttpGet(url);
        headers.entrySet().stream().forEach(it -> get.setHeader((String)it.getKey(), (String)it.getValue()));
        CloseableHttpClient httpClient = null;
        CloseableHttpResponse response = null;
        HttpEntity entity = null;
        String responseContent = null;
        try {
            httpClient = HttpClients.createDefault();
            get.setConfig(requestConfig);
            response = httpClient.execute((HttpUriRequest)get);
            entity = response.getEntity();
            responseContent = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
            logger.debug("http get url:{} body:{} result:{}", (Object)url, (Object)responseContent);
            String string = responseContent;
            return string;
        }
        catch (Exception e) {
            String string = e.toString();
            return string;
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
                if (httpClient != null) {
                    httpClient.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String post(String url, String body, Map<String, String> headers, int timeout) {
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(timeout).setConnectTimeout(timeout).setConnectionRequestTimeout(timeout).build();
        HttpPost post = new HttpPost(url);
        headers.entrySet().forEach(it -> post.setHeader((String)it.getKey(), (String)it.getValue()));
        try {
            post.setEntity((HttpEntity)new StringEntity(body));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        CloseableHttpClient httpClient = null;
        CloseableHttpResponse response = null;
        HttpEntity entity = null;
        String responseContent = null;
        try {
            httpClient = HttpClients.createDefault();
            post.setConfig(requestConfig);
            response = httpClient.execute((HttpUriRequest)post);
            entity = response.getEntity();
            String string = responseContent = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
            return string;
        }
        catch (Exception e) {
            String string = e.toString();
            return string;
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
                if (httpClient != null) {
                    httpClient.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static String post(String url, String body) {
        return HttpClient.post(url, body, Maps.newHashMap(), 1000);
    }

    public static String post(String url, String body, int timeout) {
        return HttpClient.post(url, body, Maps.newHashMap(), timeout);
    }
}

