/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.manager.dao;

import com.xiaomi.youpin.docean.anno.Service;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.ozhera.log.manager.model.dto.MilogAppConfigTailDTO;
import org.apache.ozhera.log.manager.model.pojo.MilogAppMiddlewareRel;
import org.nutz.dao.Chain;
import org.nutz.dao.Cnd;
import org.nutz.dao.Condition;
import org.nutz.dao.Sqls;
import org.nutz.dao.entity.Record;
import org.nutz.dao.impl.NutDao;
import org.nutz.dao.sql.Sql;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service
public class MilogAppMiddlewareRelDao {
    private static final Logger log = LoggerFactory.getLogger(MilogAppMiddlewareRelDao.class);
    @Resource
    private NutDao dao;

    public void insertUpdate(MilogAppMiddlewareRel middlewareRel) {
        Cnd cnd = Cnd.where((String)"milog_app_id", (String)"=", (Object)middlewareRel.getMilogAppId()).and("middleware_id", "=", (Object)middlewareRel.getMiddlewareId()).and("tail_id", "=", (Object)middlewareRel.getTailId());
        List middlewareRels = this.dao.query(MilogAppMiddlewareRel.class, (Condition)cnd);
        if (CollectionUtils.isEmpty((Collection)middlewareRels)) {
            this.dao.insert((Object)middlewareRel);
        } else {
            MilogAppMiddlewareRel rel = (MilogAppMiddlewareRel)middlewareRels.get(middlewareRels.size() - 1);
            if (null != rel.getConfig().getBatchSendSize() && null == middlewareRel.getConfig().getBatchSendSize()) {
                middlewareRel.getConfig().setBatchSendSize(rel.getConfig().getBatchSendSize());
            }
            middlewareRel.setId(rel.getId());
            this.dao.update((Object)middlewareRel);
        }
    }

    public List<MilogAppMiddlewareRel> queryByCondition(Long milogAppId, Long middlewareId, Long tailId) {
        Cnd cnd = Cnd.NEW();
        if (null != milogAppId) {
            cnd.and("milog_app_id", "=", (Object)milogAppId);
        }
        if (null != middlewareId) {
            cnd.and("middleware_id", "=", (Object)middlewareId);
        }
        if (null != tailId) {
            cnd.and("tail_id", "=", (Object)tailId);
        }
        List middlewareRels = this.dao.query(MilogAppMiddlewareRel.class, (Condition)cnd);
        return middlewareRels;
    }

    public boolean updateTopicRelMqConfig(Long id, MilogAppMiddlewareRel.Config config) {
        int ret = this.dao.update(MilogAppMiddlewareRel.class, Chain.make((String)"config", (Object)config), (Condition)Cnd.where((String)"id", (String)"=", (Object)id));
        return ret == 1;
    }

    public void deleteRel(Long milogAppId, Long tailId) {
        List<MilogAppMiddlewareRel> milogAppMiddlewareRels = this.queryByCondition(milogAppId, null, tailId);
        if (CollectionUtils.isNotEmpty(milogAppMiddlewareRels)) {
            milogAppMiddlewareRels.forEach(middlewareRel -> this.dao.delete(MilogAppMiddlewareRel.class, middlewareRel.getId().longValue()));
        }
    }

    public List<MilogAppConfigTailDTO.ConfigTailDTO> queryByAMilogAppId(Long milogAppId) {
        Sql sql = Sqls.queryEntity((String)"SELECT\n\tmr.middleware_id AS middlewareId,\n\tmc.type AS type,\n\tmc.alias AS middlewareName,\n\tml.id AS tailId,\n\tml.tail AS tailName,\n\tml.creator AS tailCreator,\n\tml.ctime AS tailCreateTime,\n\tml.utime AS tailUpdateTime,\n\tml.updater AS tailUpdater,\n\tmr.config AS mqConfig \nFROM\n\tmilog_app_middleware_rel mr\n\tLEFT JOIN milog_middleware_config mc ON mr.middleware_id = mc.id\n\tLEFT JOIN milog_logstail ml ON mr.tail_id = ml.id \nWHERE\n\tmr.milog_app_id = @milogAppId");
        sql.params().set("milogAppId", (Object)milogAppId);
        sql.setEntity(this.dao.getEntity(MilogAppConfigTailDTO.ConfigTailDTO.class));
        this.dao.execute(sql);
        return sql.getList(MilogAppConfigTailDTO.ConfigTailDTO.class);
    }

    public void update(MilogAppMiddlewareRel milogAppMiddlewareRel) {
        this.dao.update((Object)milogAppMiddlewareRel);
    }

    public void delete(Long id) {
        this.dao.delete(MilogAppMiddlewareRel.class, id.longValue());
    }

    public List<MilogAppMiddlewareRel> getAppRelByLimit(int offset, int rows) {
        String sqlString = String.format("select * from milog_app_middleware_rel limit %d,%d", offset, rows);
        Sql sql = Sqls.queryEntity((String)sqlString);
        sql.setEntity(this.dao.getEntity(MilogAppMiddlewareRel.class));
        this.dao.execute(sql);
        return sql.getList(MilogAppMiddlewareRel.class);
    }

    public Integer queryCountByTopicName(String topicName) {
        Sql sql = Sqls.queryRecord((String)"SELECT count(1) as count FROM `milog_app_middleware_rel` where config like @topicName ");
        sql.params().set("topicName", (Object)("%" + topicName + "%"));
        LinkedList records = (LinkedList)this.dao.execute(sql).getResult();
        int access = ((Record)records.get(0)).getInt("count");
        return access;
    }
}

