/*
 * Decompiled with CFR 0.152.
 */
package run.mone.doris;

import com.google.common.io.ByteStreams;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultRedirectStrategy;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import run.mone.doris.HttpUtil;

public class DorisStreamLoad {
    private static final Logger log = LoggerFactory.getLogger(DorisStreamLoad.class);
    private final String DORIS_HOST;
    private final String DORIS_USER;
    private final String DORIS_PASSWORD;
    private final int DORIS_HTTP_PORT;
    private static JsonParser jsonParser = new JsonParser();

    public DorisStreamLoad(String host, String user, String pwd, int port) {
        this.DORIS_HOST = host;
        this.DORIS_USER = user;
        this.DORIS_PASSWORD = pwd;
        this.DORIS_HTTP_PORT = port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendData(String database, String table, String content, boolean partitioned) throws Exception {
        String loadUrl = String.format("http://%s:%s/api/%s/%s/_stream_load?strip_outer_array=true", this.DORIS_HOST, this.DORIS_HTTP_PORT, database, table);
        HttpClientBuilder httpClientBuilder = HttpClients.custom().setRedirectStrategy((RedirectStrategy)new DefaultRedirectStrategy(this){

            protected boolean isRedirectable(String method) {
                return true;
            }
        });
        try (CloseableHttpClient client = httpClientBuilder.build();){
            HttpPut put = new HttpPut(loadUrl);
            StringEntity entity = new StringEntity(content, "UTF-8");
            put.setHeader("Expect", "100-continue");
            put.setHeader("Authorization", HttpUtil.basicAuthHeader(this.DORIS_USER, this.DORIS_PASSWORD));
            put.setHeader("max_filter_ratio", "0.1");
            if (partitioned) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd");
                put.setHeader("partitions", "p" + simpleDateFormat.format(new Date()));
            }
            put.setEntity((HttpEntity)entity);
            try (CloseableHttpResponse response = client.execute((HttpUriRequest)put);){
                String contentStr = new String(ByteStreams.toByteArray((InputStream)response.getEntity().getContent()));
                JsonObject jsonObject = jsonParser.parse(contentStr).getAsJsonObject();
                log.info("result:{}", (Object)contentStr);
                int statusCode = response.getStatusLine().getStatusCode();
                if (statusCode != 200 || !jsonObject.get("Status").getAsString().equalsIgnoreCase("SUCCESS") && !jsonObject.get("Status").getAsString().equalsIgnoreCase("Publish Timeout")) {
                    throw new IOException(String.format("Stream load failed, statusCode=%s load result=%s content=%s", statusCode, jsonObject.toString(), content));
                }
            }
            catch (Exception e) {
                log.error("error", (Throwable)e);
            }
            finally {
                client.close();
            }
        }
    }

    public void sendData(String database, String tableName, List<List<String>> rows) throws Exception {
        if (rows.isEmpty()) {
            return;
        }
        StringBuilder rowsData = new StringBuilder();
        for (List<String> row : rows) {
            StringBuilder rowData = new StringBuilder();
            for (int i = 0; i < row.size(); ++i) {
                rowData.append(row.get(i));
                if (i >= row.size() - 1) continue;
                rowData.append("\t");
            }
            rowData.append("\n");
            rowsData.append((CharSequence)rowData);
        }
        this.sendData(database, tableName, rowsData.toString(), false);
    }

    public void sendData(String database, String tableName, List<String> columnList, Map<String, Object> rows) throws Exception {
        if (rows.isEmpty()) {
            return;
        }
        StringBuilder rowData = new StringBuilder();
        for (int i = 0; i < columnList.size(); ++i) {
            rowData.append(rows.get(columnList.get(i)));
            if (i >= columnList.size() - 1) continue;
            rowData.append("\t");
        }
        this.sendData(database, tableName, rowData.toString(), false);
    }

    public void sendData(String database, String tableName, List<String> columnList, List<Map<String, Object>> rows) throws Exception {
        if (rows.isEmpty()) {
            return;
        }
        StringBuilder rowsData = new StringBuilder();
        for (Map<String, Object> row : rows) {
            StringBuilder rowData = new StringBuilder();
            for (int i = 0; i < columnList.size(); ++i) {
                rowData.append(row.get(columnList.get(i)));
                if (i >= columnList.size() - 1) continue;
                rowData.append("\t");
            }
            rowData.append("\n");
            rowsData.append((CharSequence)rowData);
        }
        this.sendData(database, tableName, rowsData.toString(), false);
    }
}

