/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.prometheus.agent.service.impl;

import com.alibaba.nacos.api.config.annotation.NacosValue;
import com.google.gson.Gson;
import com.xiaomi.data.push.client.HttpClientV2;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.ozhera.prometheus.agent.domain.Ips;
import org.apache.ozhera.prometheus.agent.service.PrometheusIpService;
import org.apache.ozhera.prometheus.agent.service.api.PrometheusIpServiceExtension;
import org.apache.ozhera.prometheus.agent.service.dto.heraApp.GetAllPodIpRes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PrometheusIpServiceImpl
implements PrometheusIpService {
    private static final Logger log = LoggerFactory.getLogger(PrometheusIpServiceImpl.class);
    @Autowired
    private PrometheusIpServiceExtension prometheusIpServiceExtension;
    @NacosValue(value="${hera.app.addr}", autoRefreshed=true)
    private String heraAppAddr;
    @NacosValue(value="${golang.runtime.default.port}", autoRefreshed=true)
    private String goRuntimePort;
    private static final Gson gson = new Gson();

    @Override
    public List<Ips> getByType(String type) {
        return this.prometheusIpServiceExtension.getByType(type);
    }

    @Override
    public Set<String> getIpsByAppName(String name) {
        return this.prometheusIpServiceExtension.getIpsByAppName(name);
    }

    @Override
    public Set<String> getEtcdHosts() {
        return this.prometheusIpServiceExtension.getEtcdHosts();
    }

    @Override
    public List<Ips> getK8sNodeIp(String type) {
        return this.prometheusIpServiceExtension.getK8sNodeIp(type);
    }

    @Override
    public List<Ips> getHeraAppPodIp() {
        log.info("getHeraAppPodIp begin heraAppAddr:{},goRuntimePort: {}", (Object)this.heraAppAddr, (Object)this.goRuntimePort);
        ArrayList<Ips> res = new ArrayList<Ips>();
        String url = this.heraAppAddr + "/hera/app/env/non/probe/ips";
        log.info("getHeraAppPodIp url:{}", (Object)url);
        HashMap<String, String> headers = new HashMap<String, String>(1);
        headers.put("Content-Type", "application/json; charset=utf-8");
        try {
            String heraAppRes = HttpClientV2.get((String)url, headers, (int)10000);
            GetAllPodIpRes getAllPodIpRes = (GetAllPodIpRes)gson.fromJson(heraAppRes, GetAllPodIpRes.class);
            log.info("getHeraAppPodIp heraAppRes : {} ", (Object)heraAppRes);
            if (getAllPodIpRes == null || getAllPodIpRes.getCode() != 0) {
                return res;
            }
            Ips ips = new Ips();
            ArrayList<String> ipStr = new ArrayList<String>();
            getAllPodIpRes.getData().forEach(it -> ipStr.add(it + ":" + this.goRuntimePort));
            ips.setTargets(ipStr);
            res.add(ips);
            return res;
        }
        catch (Exception e) {
            log.error("getHeraAppPodIp error:{}", (Throwable)e);
            return res;
        }
    }
}

