/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class UpdateMetadataRequestData
implements ApiMessage {
    private int controllerId;
    private int controllerEpoch;
    private long brokerEpoch;
    private List<UpdateMetadataPartitionState> ungroupedPartitionStates;
    private List<UpdateMetadataTopicState> topicStates;
    private List<UpdateMetadataBroker> liveBrokers;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field("controller_id", Type.INT32, "The controller id."), new Field("controller_epoch", Type.INT32, "The controller epoch."), new Field("ungrouped_partition_states", new ArrayOf(UpdateMetadataPartitionState.SCHEMA_0), "In older versions of this RPC, each partition that we would like to update."), new Field("live_brokers", new ArrayOf(UpdateMetadataBroker.SCHEMA_0), ""));
    public static final Schema SCHEMA_1 = new Schema(new Field("controller_id", Type.INT32, "The controller id."), new Field("controller_epoch", Type.INT32, "The controller epoch."), new Field("ungrouped_partition_states", new ArrayOf(UpdateMetadataPartitionState.SCHEMA_0), "In older versions of this RPC, each partition that we would like to update."), new Field("live_brokers", new ArrayOf(UpdateMetadataBroker.SCHEMA_1), ""));
    public static final Schema SCHEMA_2 = new Schema(new Field("controller_id", Type.INT32, "The controller id."), new Field("controller_epoch", Type.INT32, "The controller epoch."), new Field("ungrouped_partition_states", new ArrayOf(UpdateMetadataPartitionState.SCHEMA_0), "In older versions of this RPC, each partition that we would like to update."), new Field("live_brokers", new ArrayOf(UpdateMetadataBroker.SCHEMA_2), ""));
    public static final Schema SCHEMA_3 = new Schema(new Field("controller_id", Type.INT32, "The controller id."), new Field("controller_epoch", Type.INT32, "The controller epoch."), new Field("ungrouped_partition_states", new ArrayOf(UpdateMetadataPartitionState.SCHEMA_0), "In older versions of this RPC, each partition that we would like to update."), new Field("live_brokers", new ArrayOf(UpdateMetadataBroker.SCHEMA_3), ""));
    public static final Schema SCHEMA_4 = new Schema(new Field("controller_id", Type.INT32, "The controller id."), new Field("controller_epoch", Type.INT32, "The controller epoch."), new Field("ungrouped_partition_states", new ArrayOf(UpdateMetadataPartitionState.SCHEMA_4), "In older versions of this RPC, each partition that we would like to update."), new Field("live_brokers", new ArrayOf(UpdateMetadataBroker.SCHEMA_3), ""));
    public static final Schema SCHEMA_5 = new Schema(new Field("controller_id", Type.INT32, "The controller id."), new Field("controller_epoch", Type.INT32, "The controller epoch."), new Field("broker_epoch", Type.INT64, "The broker epoch."), new Field("topic_states", new ArrayOf(UpdateMetadataTopicState.SCHEMA_5), "In newer versions of this RPC, each topic that we would like to update."), new Field("live_brokers", new ArrayOf(UpdateMetadataBroker.SCHEMA_3), ""));
    public static final Schema SCHEMA_6 = new Schema(new Field("controller_id", Type.INT32, "The controller id."), new Field("controller_epoch", Type.INT32, "The controller epoch."), new Field("broker_epoch", Type.INT64, "The broker epoch."), new Field("topic_states", new CompactArrayOf(UpdateMetadataTopicState.SCHEMA_6), "In newer versions of this RPC, each topic that we would like to update."), new Field("live_brokers", new CompactArrayOf(UpdateMetadataBroker.SCHEMA_6), ""), Field.TaggedFieldsSection.of(new Object[0]));
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5, SCHEMA_6};

    public UpdateMetadataRequestData(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public UpdateMetadataRequestData(Struct _struct, short _version) {
        this.fromStruct(_struct, _version);
    }

    public UpdateMetadataRequestData() {
        this.controllerId = 0;
        this.controllerEpoch = 0;
        this.brokerEpoch = -1L;
        this.ungroupedPartitionStates = new ArrayList<UpdateMetadataPartitionState>(0);
        this.topicStates = new ArrayList<UpdateMetadataTopicState>(0);
        this.liveBrokers = new ArrayList<UpdateMetadataBroker>(0);
    }

    @Override
    public short apiKey() {
        return 6;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 6;
    }

    @Override
    public void read(Readable _readable, short _version) {
        int i;
        ArrayList<UpdateMetadataPartitionState> newCollection;
        int arrayLength;
        this.controllerId = _readable.readInt();
        this.controllerEpoch = _readable.readInt();
        this.brokerEpoch = _version >= 5 ? _readable.readLong() : -1L;
        if (_version <= 4) {
            arrayLength = _readable.readInt();
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field ungroupedPartitionStates was serialized as null");
            }
            newCollection = new ArrayList<UpdateMetadataPartitionState>(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add(new UpdateMetadataPartitionState(_readable, _version));
            }
            this.ungroupedPartitionStates = newCollection;
        } else {
            this.ungroupedPartitionStates = new ArrayList<UpdateMetadataPartitionState>(0);
        }
        if (_version >= 5) {
            if (_version >= 6) {
                arrayLength = _readable.readUnsignedVarint() - 1;
                if (arrayLength < 0) {
                    throw new RuntimeException("non-nullable field topicStates was serialized as null");
                }
                newCollection = new ArrayList(arrayLength);
                for (i = 0; i < arrayLength; ++i) {
                    newCollection.add((UpdateMetadataPartitionState)((Object)new UpdateMetadataTopicState(_readable, _version)));
                }
                this.topicStates = newCollection;
            } else {
                arrayLength = _readable.readInt();
                if (arrayLength < 0) {
                    throw new RuntimeException("non-nullable field topicStates was serialized as null");
                }
                newCollection = new ArrayList(arrayLength);
                for (i = 0; i < arrayLength; ++i) {
                    newCollection.add((UpdateMetadataPartitionState)((Object)new UpdateMetadataTopicState(_readable, _version)));
                }
                this.topicStates = newCollection;
            }
        } else {
            this.topicStates = new ArrayList<UpdateMetadataTopicState>(0);
        }
        if (_version >= 6) {
            arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field liveBrokers was serialized as null");
            }
            newCollection = new ArrayList(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add((UpdateMetadataPartitionState)((Object)new UpdateMetadataBroker(_readable, _version)));
            }
            this.liveBrokers = newCollection;
        } else {
            arrayLength = _readable.readInt();
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field liveBrokers was serialized as null");
            }
            newCollection = new ArrayList(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add((UpdateMetadataPartitionState)((Object)new UpdateMetadataBroker(_readable, _version)));
            }
            this.liveBrokers = newCollection;
        }
        this._unknownTaggedFields = null;
        if (_version >= 6) {
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        _writable.writeInt(this.controllerId);
        _writable.writeInt(this.controllerEpoch);
        if (_version >= 5) {
            _writable.writeLong(this.brokerEpoch);
        }
        if (_version <= 4) {
            _writable.writeInt(this.ungroupedPartitionStates.size());
            for (UpdateMetadataPartitionState ungroupedPartitionStatesElement : this.ungroupedPartitionStates) {
                ungroupedPartitionStatesElement.write(_writable, _cache, _version);
            }
        } else if (!this.ungroupedPartitionStates.isEmpty()) {
            throw new UnsupportedVersionException("Attempted to write a non-default ungroupedPartitionStates at version " + _version);
        }
        if (_version >= 5) {
            if (_version >= 6) {
                _writable.writeUnsignedVarint(this.topicStates.size() + 1);
                for (UpdateMetadataTopicState topicStatesElement : this.topicStates) {
                    topicStatesElement.write(_writable, _cache, _version);
                }
            } else {
                _writable.writeInt(this.topicStates.size());
                for (UpdateMetadataTopicState topicStatesElement : this.topicStates) {
                    topicStatesElement.write(_writable, _cache, _version);
                }
            }
        } else if (!this.topicStates.isEmpty()) {
            throw new UnsupportedVersionException("Attempted to write a non-default topicStates at version " + _version);
        }
        if (_version >= 6) {
            _writable.writeUnsignedVarint(this.liveBrokers.size() + 1);
            for (UpdateMetadataBroker liveBrokersElement : this.liveBrokers) {
                liveBrokersElement.write(_writable, _cache, _version);
            }
        } else {
            _writable.writeInt(this.liveBrokers.size());
            for (UpdateMetadataBroker liveBrokersElement : this.liveBrokers) {
                liveBrokersElement.write(_writable, _cache, _version);
            }
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _numTaggedFields += _rawWriter.numFields();
        if (_version >= 6) {
            _writable.writeUnsignedVarint(_numTaggedFields);
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    @Override
    public void fromStruct(Struct struct, short _version) {
        Object[] _nestedObjects;
        NavigableMap _taggedFields = null;
        this._unknownTaggedFields = null;
        if (_version >= 6) {
            _taggedFields = (NavigableMap)struct.get("_tagged_fields");
        }
        this.controllerId = struct.getInt("controller_id");
        this.controllerEpoch = struct.getInt("controller_epoch");
        this.brokerEpoch = _version >= 5 ? struct.getLong("broker_epoch") : -1L;
        if (_version <= 4) {
            _nestedObjects = struct.getArray("ungrouped_partition_states");
            this.ungroupedPartitionStates = new ArrayList<UpdateMetadataPartitionState>(_nestedObjects.length);
            for (Object nestedObject : _nestedObjects) {
                this.ungroupedPartitionStates.add(new UpdateMetadataPartitionState((Struct)nestedObject, _version));
            }
        } else {
            this.ungroupedPartitionStates = new ArrayList<UpdateMetadataPartitionState>(0);
        }
        if (_version >= 5) {
            _nestedObjects = struct.getArray("topic_states");
            this.topicStates = new ArrayList<UpdateMetadataTopicState>(_nestedObjects.length);
            for (Object nestedObject : _nestedObjects) {
                this.topicStates.add(new UpdateMetadataTopicState((Struct)nestedObject, _version));
            }
        } else {
            this.topicStates = new ArrayList<UpdateMetadataTopicState>(0);
        }
        _nestedObjects = struct.getArray("live_brokers");
        this.liveBrokers = new ArrayList<UpdateMetadataBroker>(_nestedObjects.length);
        for (Object nestedObject : _nestedObjects) {
            this.liveBrokers.add(new UpdateMetadataBroker((Struct)nestedObject, _version));
        }
        if (_version >= 6 && !_taggedFields.isEmpty()) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(_taggedFields.size());
            for (Map.Entry entry : _taggedFields.entrySet()) {
                this._unknownTaggedFields.add((RawTaggedField)entry.getValue());
            }
        }
    }

    @Override
    public Struct toStruct(short _version) {
        int i;
        Struct[] _nestedObjects;
        TreeMap _taggedFields = null;
        if (_version >= 6) {
            _taggedFields = new TreeMap();
        }
        Struct struct = new Struct(SCHEMAS[_version]);
        struct.set("controller_id", (Object)this.controllerId);
        struct.set("controller_epoch", (Object)this.controllerEpoch);
        if (_version >= 5) {
            struct.set("broker_epoch", (Object)this.brokerEpoch);
        }
        if (_version <= 4) {
            _nestedObjects = new Struct[this.ungroupedPartitionStates.size()];
            i = 0;
            for (UpdateMetadataPartitionState updateMetadataPartitionState : this.ungroupedPartitionStates) {
                _nestedObjects[i++] = updateMetadataPartitionState.toStruct(_version);
            }
            struct.set("ungrouped_partition_states", (Object)_nestedObjects);
        } else if (!this.ungroupedPartitionStates.isEmpty()) {
            throw new UnsupportedVersionException("Attempted to write a non-default ungroupedPartitionStates at version " + _version);
        }
        if (_version >= 5) {
            _nestedObjects = new Struct[this.topicStates.size()];
            i = 0;
            for (UpdateMetadataTopicState updateMetadataTopicState : this.topicStates) {
                _nestedObjects[i++] = updateMetadataTopicState.toStruct(_version);
            }
            struct.set("topic_states", (Object)_nestedObjects);
        } else if (!this.topicStates.isEmpty()) {
            throw new UnsupportedVersionException("Attempted to write a non-default topicStates at version " + _version);
        }
        _nestedObjects = new Struct[this.liveBrokers.size()];
        i = 0;
        for (UpdateMetadataBroker updateMetadataBroker : this.liveBrokers) {
            _nestedObjects[i++] = updateMetadataBroker.toStruct(_version);
        }
        struct.set("live_brokers", (Object)_nestedObjects);
        if (_version >= 6) {
            struct.set("_tagged_fields", _taggedFields);
        }
        return struct;
    }

    @Override
    public int size(ObjectSerializationCache _cache, short _version) {
        int _arraySize;
        int _size = 0;
        int _numTaggedFields = 0;
        _size += 4;
        _size += 4;
        if (_version >= 5) {
            _size += 8;
        }
        if (_version <= 4) {
            _arraySize = 0;
            _arraySize += 4;
            for (UpdateMetadataPartitionState ungroupedPartitionStatesElement : this.ungroupedPartitionStates) {
                _arraySize += ungroupedPartitionStatesElement.size(_cache, _version);
            }
            _size += _arraySize;
        }
        if (_version >= 5) {
            _arraySize = 0;
            _arraySize = _version >= 6 ? (_arraySize += ByteUtils.sizeOfUnsignedVarint(this.topicStates.size() + 1)) : (_arraySize += 4);
            for (UpdateMetadataTopicState topicStatesElement : this.topicStates) {
                _arraySize += topicStatesElement.size(_cache, _version);
            }
            _size += _arraySize;
        }
        _arraySize = 0;
        _arraySize = _version >= 6 ? (_arraySize += ByteUtils.sizeOfUnsignedVarint(this.liveBrokers.size() + 1)) : (_arraySize += 4);
        for (UpdateMetadataBroker liveBrokersElement : this.liveBrokers) {
            _arraySize += liveBrokersElement.size(_cache, _version);
        }
        _size += _arraySize;
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size += ByteUtils.sizeOfUnsignedVarint(_field.tag());
                _size += ByteUtils.sizeOfUnsignedVarint(_field.size());
                _size += _field.size();
            }
        }
        if (_version >= 6) {
            _size += ByteUtils.sizeOfUnsignedVarint(_numTaggedFields);
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
        return _size;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof UpdateMetadataRequestData)) {
            return false;
        }
        UpdateMetadataRequestData other = (UpdateMetadataRequestData)obj;
        if (this.controllerId != other.controllerId) {
            return false;
        }
        if (this.controllerEpoch != other.controllerEpoch) {
            return false;
        }
        if (this.brokerEpoch != other.brokerEpoch) {
            return false;
        }
        if (this.ungroupedPartitionStates == null ? other.ungroupedPartitionStates != null : !this.ungroupedPartitionStates.equals(other.ungroupedPartitionStates)) {
            return false;
        }
        if (this.topicStates == null ? other.topicStates != null : !this.topicStates.equals(other.topicStates)) {
            return false;
        }
        return !(this.liveBrokers == null ? other.liveBrokers != null : !this.liveBrokers.equals(other.liveBrokers));
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.controllerId;
        hashCode = 31 * hashCode + this.controllerEpoch;
        hashCode = 31 * hashCode + ((int)(this.brokerEpoch >> 32) ^ (int)this.brokerEpoch);
        hashCode = 31 * hashCode + (this.ungroupedPartitionStates == null ? 0 : this.ungroupedPartitionStates.hashCode());
        hashCode = 31 * hashCode + (this.topicStates == null ? 0 : this.topicStates.hashCode());
        hashCode = 31 * hashCode + (this.liveBrokers == null ? 0 : this.liveBrokers.hashCode());
        return hashCode;
    }

    @Override
    public UpdateMetadataRequestData duplicate() {
        UpdateMetadataRequestData _duplicate = new UpdateMetadataRequestData();
        _duplicate.controllerId = this.controllerId;
        _duplicate.controllerEpoch = this.controllerEpoch;
        _duplicate.brokerEpoch = this.brokerEpoch;
        ArrayList<UpdateMetadataPartitionState> newUngroupedPartitionStates = new ArrayList<UpdateMetadataPartitionState>(this.ungroupedPartitionStates.size());
        for (UpdateMetadataPartitionState updateMetadataPartitionState : this.ungroupedPartitionStates) {
            newUngroupedPartitionStates.add(updateMetadataPartitionState.duplicate());
        }
        _duplicate.ungroupedPartitionStates = newUngroupedPartitionStates;
        ArrayList<UpdateMetadataTopicState> newTopicStates = new ArrayList<UpdateMetadataTopicState>(this.topicStates.size());
        for (UpdateMetadataTopicState _element : this.topicStates) {
            newTopicStates.add(_element.duplicate());
        }
        _duplicate.topicStates = newTopicStates;
        ArrayList<UpdateMetadataBroker> arrayList = new ArrayList<UpdateMetadataBroker>(this.liveBrokers.size());
        for (UpdateMetadataBroker _element : this.liveBrokers) {
            arrayList.add(_element.duplicate());
        }
        _duplicate.liveBrokers = arrayList;
        return _duplicate;
    }

    public String toString() {
        return "UpdateMetadataRequestData(controllerId=" + this.controllerId + ", controllerEpoch=" + this.controllerEpoch + ", brokerEpoch=" + this.brokerEpoch + ", ungroupedPartitionStates=" + MessageUtil.deepToString(this.ungroupedPartitionStates.iterator()) + ", topicStates=" + MessageUtil.deepToString(this.topicStates.iterator()) + ", liveBrokers=" + MessageUtil.deepToString(this.liveBrokers.iterator()) + ")";
    }

    public int controllerId() {
        return this.controllerId;
    }

    public int controllerEpoch() {
        return this.controllerEpoch;
    }

    public long brokerEpoch() {
        return this.brokerEpoch;
    }

    public List<UpdateMetadataPartitionState> ungroupedPartitionStates() {
        return this.ungroupedPartitionStates;
    }

    public List<UpdateMetadataTopicState> topicStates() {
        return this.topicStates;
    }

    public List<UpdateMetadataBroker> liveBrokers() {
        return this.liveBrokers;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public UpdateMetadataRequestData setControllerId(int v) {
        this.controllerId = v;
        return this;
    }

    public UpdateMetadataRequestData setControllerEpoch(int v) {
        this.controllerEpoch = v;
        return this;
    }

    public UpdateMetadataRequestData setBrokerEpoch(long v) {
        this.brokerEpoch = v;
        return this;
    }

    public UpdateMetadataRequestData setUngroupedPartitionStates(List<UpdateMetadataPartitionState> v) {
        this.ungroupedPartitionStates = v;
        return this;
    }

    public UpdateMetadataRequestData setTopicStates(List<UpdateMetadataTopicState> v) {
        this.topicStates = v;
        return this;
    }

    public UpdateMetadataRequestData setLiveBrokers(List<UpdateMetadataBroker> v) {
        this.liveBrokers = v;
        return this;
    }

    public static class UpdateMetadataPartitionState
    implements Message {
        private String topicName;
        private int partitionIndex;
        private int controllerEpoch;
        private int leader;
        private int leaderEpoch;
        private List<Integer> isr;
        private int zkVersion;
        private List<Integer> replicas;
        private List<Integer> offlineReplicas;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema SCHEMA_3;
        public static final Schema SCHEMA_4;
        public static final Schema SCHEMA_5;
        public static final Schema SCHEMA_6;
        public static final Schema[] SCHEMAS;

        public UpdateMetadataPartitionState(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public UpdateMetadataPartitionState(Struct _struct, short _version) {
            this.fromStruct(_struct, _version);
        }

        public UpdateMetadataPartitionState() {
            this.topicName = "";
            this.partitionIndex = 0;
            this.controllerEpoch = 0;
            this.leader = 0;
            this.leaderEpoch = 0;
            this.isr = new ArrayList<Integer>(0);
            this.zkVersion = 0;
            this.replicas = new ArrayList<Integer>(0);
            this.offlineReplicas = new ArrayList<Integer>(0);
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return Short.MAX_VALUE;
        }

        @Override
        public void read(Readable _readable, short _version) {
            int i;
            if (_version <= 4) {
                short length = _readable.readShort();
                if (length < 0) {
                    throw new RuntimeException("non-nullable field topicName was serialized as null");
                }
                if (length > Short.MAX_VALUE) {
                    throw new RuntimeException("string field topicName had invalid length " + length);
                }
                this.topicName = _readable.readString(length);
            } else {
                this.topicName = "";
            }
            this.partitionIndex = _readable.readInt();
            this.controllerEpoch = _readable.readInt();
            this.leader = _readable.readInt();
            this.leaderEpoch = _readable.readInt();
            int arrayLength = _version >= 6 ? _readable.readUnsignedVarint() - 1 : _readable.readInt();
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field isr was serialized as null");
            }
            ArrayList<Integer> newCollection = new ArrayList<Integer>(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add(_readable.readInt());
            }
            this.isr = newCollection;
            this.zkVersion = _readable.readInt();
            arrayLength = _version >= 6 ? _readable.readUnsignedVarint() - 1 : _readable.readInt();
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field replicas was serialized as null");
            }
            newCollection = new ArrayList(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add(_readable.readInt());
            }
            this.replicas = newCollection;
            if (_version >= 4) {
                arrayLength = _version >= 6 ? _readable.readUnsignedVarint() - 1 : _readable.readInt();
                if (arrayLength < 0) {
                    throw new RuntimeException("non-nullable field offlineReplicas was serialized as null");
                }
                newCollection = new ArrayList(arrayLength);
                for (i = 0; i < arrayLength; ++i) {
                    newCollection.add(_readable.readInt());
                }
                this.offlineReplicas = newCollection;
            } else {
                this.offlineReplicas = new ArrayList<Integer>(0);
            }
            this._unknownTaggedFields = null;
            if (_version >= 6) {
                int _numTaggedFields = _readable.readUnsignedVarint();
                for (int _i = 0; _i < _numTaggedFields; ++_i) {
                    int _tag = _readable.readUnsignedVarint();
                    int _size = _readable.readUnsignedVarint();
                    switch (_tag) {
                        default: 
                    }
                    this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                }
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            Object _stringBytes;
            int _numTaggedFields = 0;
            if (_version <= 4) {
                _stringBytes = _cache.getSerializedValue(this.topicName);
                _writable.writeShort((short)((byte[])_stringBytes).length);
                _writable.writeByteArray((byte[])_stringBytes);
            }
            _writable.writeInt(this.partitionIndex);
            _writable.writeInt(this.controllerEpoch);
            _writable.writeInt(this.leader);
            _writable.writeInt(this.leaderEpoch);
            if (_version >= 6) {
                _writable.writeUnsignedVarint(this.isr.size() + 1);
            } else {
                _writable.writeInt(this.isr.size());
            }
            _stringBytes = this.isr.iterator();
            while (_stringBytes.hasNext()) {
                Integer isrElement = (Integer)_stringBytes.next();
                _writable.writeInt(isrElement);
            }
            _writable.writeInt(this.zkVersion);
            if (_version >= 6) {
                _writable.writeUnsignedVarint(this.replicas.size() + 1);
            } else {
                _writable.writeInt(this.replicas.size());
            }
            for (Integer replicasElement : this.replicas) {
                _writable.writeInt(replicasElement);
            }
            if (_version >= 4) {
                if (_version >= 6) {
                    _writable.writeUnsignedVarint(this.offlineReplicas.size() + 1);
                } else {
                    _writable.writeInt(this.offlineReplicas.size());
                }
                for (Integer offlineReplicasElement : this.offlineReplicas) {
                    _writable.writeInt(offlineReplicasElement);
                }
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _numTaggedFields += _rawWriter.numFields();
            if (_version >= 6) {
                _writable.writeUnsignedVarint(_numTaggedFields);
                _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void fromStruct(Struct struct, short _version) {
            NavigableMap _taggedFields = null;
            this._unknownTaggedFields = null;
            if (_version >= 6) {
                _taggedFields = (NavigableMap)struct.get("_tagged_fields");
            }
            this.topicName = _version <= 4 ? struct.getString("topic_name") : "";
            this.partitionIndex = struct.getInt("partition_index");
            this.controllerEpoch = struct.getInt("controller_epoch");
            this.leader = struct.getInt("leader");
            this.leaderEpoch = struct.getInt("leader_epoch");
            Object[] _nestedObjects = struct.getArray("isr");
            this.isr = new ArrayList<Integer>(_nestedObjects.length);
            for (Object nestedObject : _nestedObjects) {
                this.isr.add((Integer)nestedObject);
            }
            this.zkVersion = struct.getInt("zk_version");
            _nestedObjects = struct.getArray("replicas");
            this.replicas = new ArrayList<Integer>(_nestedObjects.length);
            for (Object nestedObject : _nestedObjects) {
                this.replicas.add((Integer)nestedObject);
            }
            if (_version >= 4) {
                _nestedObjects = struct.getArray("offline_replicas");
                this.offlineReplicas = new ArrayList<Integer>(_nestedObjects.length);
                for (Object nestedObject : _nestedObjects) {
                    this.offlineReplicas.add((Integer)nestedObject);
                }
            } else {
                this.offlineReplicas = new ArrayList<Integer>(0);
            }
            if (_version >= 6 && !_taggedFields.isEmpty()) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(_taggedFields.size());
                for (Map.Entry entry : _taggedFields.entrySet()) {
                    this._unknownTaggedFields.add((RawTaggedField)entry.getValue());
                }
            }
        }

        @Override
        public Struct toStruct(short _version) {
            TreeMap _taggedFields = null;
            if (_version >= 6) {
                _taggedFields = new TreeMap();
            }
            Struct struct = new Struct(SCHEMAS[_version]);
            if (_version <= 4) {
                struct.set("topic_name", (Object)this.topicName);
            }
            struct.set("partition_index", (Object)this.partitionIndex);
            struct.set("controller_epoch", (Object)this.controllerEpoch);
            struct.set("leader", (Object)this.leader);
            struct.set("leader_epoch", (Object)this.leaderEpoch);
            Integer[] _nestedObjects = new Integer[this.isr.size()];
            int i = 0;
            for (Integer element : this.isr) {
                _nestedObjects[i++] = element;
            }
            struct.set("isr", (Object)_nestedObjects);
            struct.set("zk_version", (Object)this.zkVersion);
            _nestedObjects = new Integer[this.replicas.size()];
            i = 0;
            for (Integer element : this.replicas) {
                _nestedObjects[i++] = element;
            }
            struct.set("replicas", (Object)_nestedObjects);
            if (_version >= 4) {
                _nestedObjects = new Integer[this.offlineReplicas.size()];
                i = 0;
                for (Integer element : this.offlineReplicas) {
                    _nestedObjects[i++] = element;
                }
                struct.set("offline_replicas", (Object)_nestedObjects);
            }
            if (_version >= 6) {
                struct.set("_tagged_fields", _taggedFields);
            }
            return struct;
        }

        @Override
        public int size(ObjectSerializationCache _cache, short _version) {
            int _size = 0;
            int _numTaggedFields = 0;
            if (_version <= 4) {
                byte[] _stringBytes = this.topicName.getBytes(StandardCharsets.UTF_8);
                if (_stringBytes.length > Short.MAX_VALUE) {
                    throw new RuntimeException("'topicName' field is too long to be serialized");
                }
                _cache.cacheSerializedValue(this.topicName, _stringBytes);
                _size += _stringBytes.length + 2;
            }
            _size += 4;
            _size += 4;
            _size += 4;
            _size += 4;
            int _arraySize = 0;
            _arraySize = _version >= 6 ? (_arraySize += ByteUtils.sizeOfUnsignedVarint(this.isr.size() + 1)) : (_arraySize += 4);
            _size += (_arraySize += this.isr.size() * 4);
            _size += 4;
            _arraySize = 0;
            _arraySize = _version >= 6 ? (_arraySize += ByteUtils.sizeOfUnsignedVarint(this.replicas.size() + 1)) : (_arraySize += 4);
            _size += (_arraySize += this.replicas.size() * 4);
            if (_version >= 4) {
                _arraySize = 0;
                _arraySize = _version >= 6 ? (_arraySize += ByteUtils.sizeOfUnsignedVarint(this.offlineReplicas.size() + 1)) : (_arraySize += 4);
                _size += (_arraySize += this.offlineReplicas.size() * 4);
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.tag());
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.size());
                    _size += _field.size();
                }
            }
            if (_version >= 6) {
                _size += ByteUtils.sizeOfUnsignedVarint(_numTaggedFields);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
            return _size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof UpdateMetadataPartitionState)) {
                return false;
            }
            UpdateMetadataPartitionState other = (UpdateMetadataPartitionState)obj;
            if (this.topicName == null ? other.topicName != null : !this.topicName.equals(other.topicName)) {
                return false;
            }
            if (this.partitionIndex != other.partitionIndex) {
                return false;
            }
            if (this.controllerEpoch != other.controllerEpoch) {
                return false;
            }
            if (this.leader != other.leader) {
                return false;
            }
            if (this.leaderEpoch != other.leaderEpoch) {
                return false;
            }
            if (this.isr == null ? other.isr != null : !this.isr.equals(other.isr)) {
                return false;
            }
            if (this.zkVersion != other.zkVersion) {
                return false;
            }
            if (this.replicas == null ? other.replicas != null : !this.replicas.equals(other.replicas)) {
                return false;
            }
            return !(this.offlineReplicas == null ? other.offlineReplicas != null : !this.offlineReplicas.equals(other.offlineReplicas));
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.topicName == null ? 0 : this.topicName.hashCode());
            hashCode = 31 * hashCode + this.partitionIndex;
            hashCode = 31 * hashCode + this.controllerEpoch;
            hashCode = 31 * hashCode + this.leader;
            hashCode = 31 * hashCode + this.leaderEpoch;
            hashCode = 31 * hashCode + (this.isr == null ? 0 : this.isr.hashCode());
            hashCode = 31 * hashCode + this.zkVersion;
            hashCode = 31 * hashCode + (this.replicas == null ? 0 : this.replicas.hashCode());
            hashCode = 31 * hashCode + (this.offlineReplicas == null ? 0 : this.offlineReplicas.hashCode());
            return hashCode;
        }

        @Override
        public UpdateMetadataPartitionState duplicate() {
            UpdateMetadataPartitionState _duplicate = new UpdateMetadataPartitionState();
            _duplicate.topicName = this.topicName;
            _duplicate.partitionIndex = this.partitionIndex;
            _duplicate.controllerEpoch = this.controllerEpoch;
            _duplicate.leader = this.leader;
            _duplicate.leaderEpoch = this.leaderEpoch;
            ArrayList<Integer> newIsr = new ArrayList<Integer>(this.isr.size());
            for (Integer n : this.isr) {
                newIsr.add(n);
            }
            _duplicate.isr = newIsr;
            _duplicate.zkVersion = this.zkVersion;
            ArrayList<Integer> newReplicas = new ArrayList<Integer>(this.replicas.size());
            for (Integer _element : this.replicas) {
                newReplicas.add(_element);
            }
            _duplicate.replicas = newReplicas;
            ArrayList<Integer> arrayList = new ArrayList<Integer>(this.offlineReplicas.size());
            for (Integer _element : this.offlineReplicas) {
                arrayList.add(_element);
            }
            _duplicate.offlineReplicas = arrayList;
            return _duplicate;
        }

        public String toString() {
            return "UpdateMetadataPartitionState(topicName=" + (this.topicName == null ? "null" : "'" + this.topicName.toString() + "'") + ", partitionIndex=" + this.partitionIndex + ", controllerEpoch=" + this.controllerEpoch + ", leader=" + this.leader + ", leaderEpoch=" + this.leaderEpoch + ", isr=" + MessageUtil.deepToString(this.isr.iterator()) + ", zkVersion=" + this.zkVersion + ", replicas=" + MessageUtil.deepToString(this.replicas.iterator()) + ", offlineReplicas=" + MessageUtil.deepToString(this.offlineReplicas.iterator()) + ")";
        }

        public String topicName() {
            return this.topicName;
        }

        public int partitionIndex() {
            return this.partitionIndex;
        }

        public int controllerEpoch() {
            return this.controllerEpoch;
        }

        public int leader() {
            return this.leader;
        }

        public int leaderEpoch() {
            return this.leaderEpoch;
        }

        public List<Integer> isr() {
            return this.isr;
        }

        public int zkVersion() {
            return this.zkVersion;
        }

        public List<Integer> replicas() {
            return this.replicas;
        }

        public List<Integer> offlineReplicas() {
            return this.offlineReplicas;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public UpdateMetadataPartitionState setTopicName(String v) {
            this.topicName = v;
            return this;
        }

        public UpdateMetadataPartitionState setPartitionIndex(int v) {
            this.partitionIndex = v;
            return this;
        }

        public UpdateMetadataPartitionState setControllerEpoch(int v) {
            this.controllerEpoch = v;
            return this;
        }

        public UpdateMetadataPartitionState setLeader(int v) {
            this.leader = v;
            return this;
        }

        public UpdateMetadataPartitionState setLeaderEpoch(int v) {
            this.leaderEpoch = v;
            return this;
        }

        public UpdateMetadataPartitionState setIsr(List<Integer> v) {
            this.isr = v;
            return this;
        }

        public UpdateMetadataPartitionState setZkVersion(int v) {
            this.zkVersion = v;
            return this;
        }

        public UpdateMetadataPartitionState setReplicas(List<Integer> v) {
            this.replicas = v;
            return this;
        }

        public UpdateMetadataPartitionState setOfflineReplicas(List<Integer> v) {
            this.offlineReplicas = v;
            return this;
        }

        static {
            SCHEMA_3 = SCHEMA_2 = (SCHEMA_1 = (SCHEMA_0 = new Schema(new Field("topic_name", Type.STRING, "In older versions of this RPC, the topic name."), new Field("partition_index", Type.INT32, "The partition index."), new Field("controller_epoch", Type.INT32, "The controller epoch."), new Field("leader", Type.INT32, "The ID of the broker which is the current partition leader."), new Field("leader_epoch", Type.INT32, "The leader epoch of this partition."), new Field("isr", new ArrayOf(Type.INT32), "The brokers which are in the ISR for this partition."), new Field("zk_version", Type.INT32, "The Zookeeper version."), new Field("replicas", new ArrayOf(Type.INT32), "All the replicas of this partition."))));
            SCHEMA_4 = new Schema(new Field("topic_name", Type.STRING, "In older versions of this RPC, the topic name."), new Field("partition_index", Type.INT32, "The partition index."), new Field("controller_epoch", Type.INT32, "The controller epoch."), new Field("leader", Type.INT32, "The ID of the broker which is the current partition leader."), new Field("leader_epoch", Type.INT32, "The leader epoch of this partition."), new Field("isr", new ArrayOf(Type.INT32), "The brokers which are in the ISR for this partition."), new Field("zk_version", Type.INT32, "The Zookeeper version."), new Field("replicas", new ArrayOf(Type.INT32), "All the replicas of this partition."), new Field("offline_replicas", new ArrayOf(Type.INT32), "The replicas of this partition which are offline."));
            SCHEMA_5 = new Schema(new Field("partition_index", Type.INT32, "The partition index."), new Field("controller_epoch", Type.INT32, "The controller epoch."), new Field("leader", Type.INT32, "The ID of the broker which is the current partition leader."), new Field("leader_epoch", Type.INT32, "The leader epoch of this partition."), new Field("isr", new ArrayOf(Type.INT32), "The brokers which are in the ISR for this partition."), new Field("zk_version", Type.INT32, "The Zookeeper version."), new Field("replicas", new ArrayOf(Type.INT32), "All the replicas of this partition."), new Field("offline_replicas", new ArrayOf(Type.INT32), "The replicas of this partition which are offline."));
            SCHEMA_6 = new Schema(new Field("partition_index", Type.INT32, "The partition index."), new Field("controller_epoch", Type.INT32, "The controller epoch."), new Field("leader", Type.INT32, "The ID of the broker which is the current partition leader."), new Field("leader_epoch", Type.INT32, "The leader epoch of this partition."), new Field("isr", new CompactArrayOf(Type.INT32), "The brokers which are in the ISR for this partition."), new Field("zk_version", Type.INT32, "The Zookeeper version."), new Field("replicas", new CompactArrayOf(Type.INT32), "All the replicas of this partition."), new Field("offline_replicas", new CompactArrayOf(Type.INT32), "The replicas of this partition which are offline."), Field.TaggedFieldsSection.of(new Object[0]));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5, SCHEMA_6};
        }
    }

    public static class UpdateMetadataEndpoint
    implements Message {
        private int port;
        private String host;
        private String listener;
        private short securityProtocol;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema SCHEMA_3;
        public static final Schema SCHEMA_4;
        public static final Schema SCHEMA_5;
        public static final Schema SCHEMA_6;
        public static final Schema[] SCHEMAS;

        public UpdateMetadataEndpoint(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public UpdateMetadataEndpoint(Struct _struct, short _version) {
            this.fromStruct(_struct, _version);
        }

        public UpdateMetadataEndpoint() {
            this.port = 0;
            this.host = "";
            this.listener = "";
            this.securityProtocol = 0;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 6;
        }

        @Override
        public void read(Readable _readable, short _version) {
            if (_version > 6) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of UpdateMetadataEndpoint");
            }
            this.port = _readable.readInt();
            int length = _version >= 6 ? _readable.readUnsignedVarint() - 1 : _readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field host was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field host had invalid length " + length);
            }
            this.host = _readable.readString(length);
            if (_version >= 3) {
                length = _version >= 6 ? _readable.readUnsignedVarint() - 1 : (int)_readable.readShort();
                if (length < 0) {
                    throw new RuntimeException("non-nullable field listener was serialized as null");
                }
                if (length > Short.MAX_VALUE) {
                    throw new RuntimeException("string field listener had invalid length " + length);
                }
                this.listener = _readable.readString(length);
            } else {
                this.listener = "";
            }
            this.securityProtocol = _readable.readShort();
            this._unknownTaggedFields = null;
            if (_version >= 6) {
                int _numTaggedFields = _readable.readUnsignedVarint();
                for (int _i = 0; _i < _numTaggedFields; ++_i) {
                    int _tag = _readable.readUnsignedVarint();
                    int _size = _readable.readUnsignedVarint();
                    switch (_tag) {
                        default: 
                    }
                    this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                }
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            if (_version < 1) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of UpdateMetadataEndpoint");
            }
            int _numTaggedFields = 0;
            _writable.writeInt(this.port);
            byte[] _stringBytes = _cache.getSerializedValue(this.host);
            if (_version >= 6) {
                _writable.writeUnsignedVarint(_stringBytes.length + 1);
            } else {
                _writable.writeShort((short)_stringBytes.length);
            }
            _writable.writeByteArray(_stringBytes);
            if (_version >= 3) {
                _stringBytes = _cache.getSerializedValue(this.listener);
                if (_version >= 6) {
                    _writable.writeUnsignedVarint(_stringBytes.length + 1);
                } else {
                    _writable.writeShort((short)_stringBytes.length);
                }
                _writable.writeByteArray(_stringBytes);
            }
            _writable.writeShort(this.securityProtocol);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _numTaggedFields += _rawWriter.numFields();
            if (_version >= 6) {
                _writable.writeUnsignedVarint(_numTaggedFields);
                _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void fromStruct(Struct struct, short _version) {
            if (_version > 6) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of UpdateMetadataEndpoint");
            }
            NavigableMap _taggedFields = null;
            this._unknownTaggedFields = null;
            if (_version >= 6) {
                _taggedFields = (NavigableMap)struct.get("_tagged_fields");
            }
            this.port = struct.getInt("port");
            this.host = struct.getString("host");
            this.listener = _version >= 3 ? struct.getString("listener") : "";
            this.securityProtocol = struct.getShort("security_protocol");
            if (_version >= 6 && !_taggedFields.isEmpty()) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(_taggedFields.size());
                for (Map.Entry entry : _taggedFields.entrySet()) {
                    this._unknownTaggedFields.add((RawTaggedField)entry.getValue());
                }
            }
        }

        @Override
        public Struct toStruct(short _version) {
            if (_version > 6) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of UpdateMetadataEndpoint");
            }
            TreeMap _taggedFields = null;
            if (_version >= 6) {
                _taggedFields = new TreeMap();
            }
            Struct struct = new Struct(SCHEMAS[_version]);
            struct.set("port", (Object)this.port);
            struct.set("host", (Object)this.host);
            if (_version >= 3) {
                struct.set("listener", (Object)this.listener);
            }
            struct.set("security_protocol", (Object)this.securityProtocol);
            if (_version >= 6) {
                struct.set("_tagged_fields", _taggedFields);
            }
            return struct;
        }

        @Override
        public int size(ObjectSerializationCache _cache, short _version) {
            int _size = 0;
            int _numTaggedFields = 0;
            if (_version > 6) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of UpdateMetadataEndpoint");
            }
            _size += 4;
            byte[] _stringBytes = this.host.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'host' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.host, _stringBytes);
            _size = _version >= 6 ? (_size += _stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1)) : (_size += _stringBytes.length + 2);
            if (_version >= 3) {
                _stringBytes = this.listener.getBytes(StandardCharsets.UTF_8);
                if (_stringBytes.length > Short.MAX_VALUE) {
                    throw new RuntimeException("'listener' field is too long to be serialized");
                }
                _cache.cacheSerializedValue(this.listener, _stringBytes);
                _size = _version >= 6 ? (_size += _stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1)) : (_size += _stringBytes.length + 2);
            }
            _size += 2;
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.tag());
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.size());
                    _size += _field.size();
                }
            }
            if (_version >= 6) {
                _size += ByteUtils.sizeOfUnsignedVarint(_numTaggedFields);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
            return _size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof UpdateMetadataEndpoint)) {
                return false;
            }
            UpdateMetadataEndpoint other = (UpdateMetadataEndpoint)obj;
            if (this.port != other.port) {
                return false;
            }
            if (this.host == null ? other.host != null : !this.host.equals(other.host)) {
                return false;
            }
            if (this.listener == null ? other.listener != null : !this.listener.equals(other.listener)) {
                return false;
            }
            return this.securityProtocol == other.securityProtocol;
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.port;
            hashCode = 31 * hashCode + (this.host == null ? 0 : this.host.hashCode());
            hashCode = 31 * hashCode + (this.listener == null ? 0 : this.listener.hashCode());
            hashCode = 31 * hashCode + this.securityProtocol;
            return hashCode;
        }

        @Override
        public UpdateMetadataEndpoint duplicate() {
            UpdateMetadataEndpoint _duplicate = new UpdateMetadataEndpoint();
            _duplicate.port = this.port;
            _duplicate.host = this.host;
            _duplicate.listener = this.listener;
            _duplicate.securityProtocol = this.securityProtocol;
            return _duplicate;
        }

        public String toString() {
            return "UpdateMetadataEndpoint(port=" + this.port + ", host=" + (this.host == null ? "null" : "'" + this.host.toString() + "'") + ", listener=" + (this.listener == null ? "null" : "'" + this.listener.toString() + "'") + ", securityProtocol=" + this.securityProtocol + ")";
        }

        public int port() {
            return this.port;
        }

        public String host() {
            return this.host;
        }

        public String listener() {
            return this.listener;
        }

        public short securityProtocol() {
            return this.securityProtocol;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public UpdateMetadataEndpoint setPort(int v) {
            this.port = v;
            return this;
        }

        public UpdateMetadataEndpoint setHost(String v) {
            this.host = v;
            return this;
        }

        public UpdateMetadataEndpoint setListener(String v) {
            this.listener = v;
            return this;
        }

        public UpdateMetadataEndpoint setSecurityProtocol(short v) {
            this.securityProtocol = v;
            return this;
        }

        static {
            SCHEMA_2 = SCHEMA_1 = new Schema(new Field("port", Type.INT32, "The port of this endpoint"), new Field("host", Type.STRING, "The hostname of this endpoint"), new Field("security_protocol", Type.INT16, "The security protocol type."));
            SCHEMA_5 = SCHEMA_4 = (SCHEMA_3 = new Schema(new Field("port", Type.INT32, "The port of this endpoint"), new Field("host", Type.STRING, "The hostname of this endpoint"), new Field("listener", Type.STRING, "The listener name."), new Field("security_protocol", Type.INT16, "The security protocol type.")));
            SCHEMA_6 = new Schema(new Field("port", Type.INT32, "The port of this endpoint"), new Field("host", Type.COMPACT_STRING, "The hostname of this endpoint"), new Field("listener", Type.COMPACT_STRING, "The listener name."), new Field("security_protocol", Type.INT16, "The security protocol type."), Field.TaggedFieldsSection.of(new Object[0]));
            SCHEMAS = new Schema[]{null, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5, SCHEMA_6};
        }
    }

    public static class UpdateMetadataBroker
    implements Message {
        private int id;
        private String v0Host;
        private int v0Port;
        private List<UpdateMetadataEndpoint> endpoints;
        private String rack;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("id", Type.INT32, "The broker id."), new Field("v0_host", Type.STRING, "The broker hostname."), new Field("v0_port", Type.INT32, "The broker port."));
        public static final Schema SCHEMA_1 = new Schema(new Field("id", Type.INT32, "The broker id."), new Field("endpoints", new ArrayOf(UpdateMetadataEndpoint.SCHEMA_1), "The broker endpoints."));
        public static final Schema SCHEMA_2 = new Schema(new Field("id", Type.INT32, "The broker id."), new Field("endpoints", new ArrayOf(UpdateMetadataEndpoint.SCHEMA_1), "The broker endpoints."), new Field("rack", Type.NULLABLE_STRING, "The rack which this broker belongs to."));
        public static final Schema SCHEMA_3;
        public static final Schema SCHEMA_4;
        public static final Schema SCHEMA_5;
        public static final Schema SCHEMA_6;
        public static final Schema[] SCHEMAS;

        public UpdateMetadataBroker(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public UpdateMetadataBroker(Struct _struct, short _version) {
            this.fromStruct(_struct, _version);
        }

        public UpdateMetadataBroker() {
            this.id = 0;
            this.v0Host = "";
            this.v0Port = 0;
            this.endpoints = new ArrayList<UpdateMetadataEndpoint>(0);
            this.rack = "";
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 6;
        }

        @Override
        public void read(Readable _readable, short _version) {
            int length;
            if (_version > 6) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of UpdateMetadataBroker");
            }
            this.id = _readable.readInt();
            if (_version <= 0) {
                length = _readable.readShort();
                if (length < 0) {
                    throw new RuntimeException("non-nullable field v0Host was serialized as null");
                }
                if (length > Short.MAX_VALUE) {
                    throw new RuntimeException("string field v0Host had invalid length " + length);
                }
                this.v0Host = _readable.readString(length);
            } else {
                this.v0Host = "";
            }
            this.v0Port = _version <= 0 ? _readable.readInt() : 0;
            if (_version >= 1) {
                int i;
                ArrayList<UpdateMetadataEndpoint> newCollection;
                int arrayLength;
                if (_version >= 6) {
                    arrayLength = _readable.readUnsignedVarint() - 1;
                    if (arrayLength < 0) {
                        throw new RuntimeException("non-nullable field endpoints was serialized as null");
                    }
                    newCollection = new ArrayList(arrayLength);
                    for (i = 0; i < arrayLength; ++i) {
                        newCollection.add(new UpdateMetadataEndpoint(_readable, _version));
                    }
                    this.endpoints = newCollection;
                } else {
                    arrayLength = _readable.readInt();
                    if (arrayLength < 0) {
                        throw new RuntimeException("non-nullable field endpoints was serialized as null");
                    }
                    newCollection = new ArrayList<UpdateMetadataEndpoint>(arrayLength);
                    for (i = 0; i < arrayLength; ++i) {
                        newCollection.add(new UpdateMetadataEndpoint(_readable, _version));
                    }
                    this.endpoints = newCollection;
                }
            } else {
                this.endpoints = new ArrayList<UpdateMetadataEndpoint>(0);
            }
            if (_version >= 2) {
                length = _version >= 6 ? _readable.readUnsignedVarint() - 1 : _readable.readShort();
                if (length < 0) {
                    this.rack = null;
                } else {
                    if (length > Short.MAX_VALUE) {
                        throw new RuntimeException("string field rack had invalid length " + length);
                    }
                    this.rack = _readable.readString(length);
                }
            } else {
                this.rack = "";
            }
            this._unknownTaggedFields = null;
            if (_version >= 6) {
                int _numTaggedFields = _readable.readUnsignedVarint();
                for (int _i = 0; _i < _numTaggedFields; ++_i) {
                    int _tag = _readable.readUnsignedVarint();
                    int _size = _readable.readUnsignedVarint();
                    switch (_tag) {
                        default: 
                    }
                    this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                }
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            Object _stringBytes;
            int _numTaggedFields = 0;
            _writable.writeInt(this.id);
            if (_version <= 0) {
                _stringBytes = _cache.getSerializedValue(this.v0Host);
                _writable.writeShort((short)((byte[])_stringBytes).length);
                _writable.writeByteArray((byte[])_stringBytes);
            }
            if (_version <= 0) {
                _writable.writeInt(this.v0Port);
            }
            if (_version >= 1) {
                if (_version >= 6) {
                    _writable.writeUnsignedVarint(this.endpoints.size() + 1);
                    _stringBytes = this.endpoints.iterator();
                    while (_stringBytes.hasNext()) {
                        UpdateMetadataEndpoint endpointsElement = (UpdateMetadataEndpoint)_stringBytes.next();
                        endpointsElement.write(_writable, _cache, _version);
                    }
                } else {
                    _writable.writeInt(this.endpoints.size());
                    _stringBytes = this.endpoints.iterator();
                    while (_stringBytes.hasNext()) {
                        UpdateMetadataEndpoint endpointsElement = (UpdateMetadataEndpoint)_stringBytes.next();
                        endpointsElement.write(_writable, _cache, _version);
                    }
                }
            }
            if (_version >= 2) {
                if (this.rack == null) {
                    if (_version >= 6) {
                        _writable.writeUnsignedVarint(0);
                    } else {
                        _writable.writeShort((short)-1);
                    }
                } else {
                    _stringBytes = _cache.getSerializedValue(this.rack);
                    if (_version >= 6) {
                        _writable.writeUnsignedVarint(((Object)_stringBytes).length + 1);
                    } else {
                        _writable.writeShort((short)((Object)_stringBytes).length);
                    }
                    _writable.writeByteArray((byte[])_stringBytes);
                }
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _numTaggedFields += _rawWriter.numFields();
            if (_version >= 6) {
                _writable.writeUnsignedVarint(_numTaggedFields);
                _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void fromStruct(Struct struct, short _version) {
            if (_version > 6) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of UpdateMetadataBroker");
            }
            NavigableMap _taggedFields = null;
            this._unknownTaggedFields = null;
            if (_version >= 6) {
                _taggedFields = (NavigableMap)struct.get("_tagged_fields");
            }
            this.id = struct.getInt("id");
            this.v0Host = _version <= 0 ? struct.getString("v0_host") : "";
            this.v0Port = _version <= 0 ? struct.getInt("v0_port") : 0;
            if (_version >= 1) {
                Object[] _nestedObjects = struct.getArray("endpoints");
                this.endpoints = new ArrayList<UpdateMetadataEndpoint>(_nestedObjects.length);
                for (Object nestedObject : _nestedObjects) {
                    this.endpoints.add(new UpdateMetadataEndpoint((Struct)nestedObject, _version));
                }
            } else {
                this.endpoints = new ArrayList<UpdateMetadataEndpoint>(0);
            }
            this.rack = _version >= 2 ? struct.getString("rack") : "";
            if (_version >= 6 && !_taggedFields.isEmpty()) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(_taggedFields.size());
                for (Map.Entry entry : _taggedFields.entrySet()) {
                    this._unknownTaggedFields.add((RawTaggedField)entry.getValue());
                }
            }
        }

        @Override
        public Struct toStruct(short _version) {
            if (_version > 6) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of UpdateMetadataBroker");
            }
            TreeMap _taggedFields = null;
            if (_version >= 6) {
                _taggedFields = new TreeMap();
            }
            Struct struct = new Struct(SCHEMAS[_version]);
            struct.set("id", (Object)this.id);
            if (_version <= 0) {
                struct.set("v0_host", (Object)this.v0Host);
            }
            if (_version <= 0) {
                struct.set("v0_port", (Object)this.v0Port);
            }
            if (_version >= 1) {
                Struct[] _nestedObjects = new Struct[this.endpoints.size()];
                int i = 0;
                for (UpdateMetadataEndpoint element : this.endpoints) {
                    _nestedObjects[i++] = element.toStruct(_version);
                }
                struct.set("endpoints", (Object)_nestedObjects);
            }
            if (_version >= 2) {
                struct.set("rack", (Object)this.rack);
            }
            if (_version >= 6) {
                struct.set("_tagged_fields", _taggedFields);
            }
            return struct;
        }

        @Override
        public int size(ObjectSerializationCache _cache, short _version) {
            byte[] _stringBytes;
            int _size = 0;
            int _numTaggedFields = 0;
            if (_version > 6) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of UpdateMetadataBroker");
            }
            _size += 4;
            if (_version <= 0) {
                _stringBytes = this.v0Host.getBytes(StandardCharsets.UTF_8);
                if (_stringBytes.length > Short.MAX_VALUE) {
                    throw new RuntimeException("'v0Host' field is too long to be serialized");
                }
                _cache.cacheSerializedValue(this.v0Host, _stringBytes);
                _size += _stringBytes.length + 2;
            }
            if (_version <= 0) {
                _size += 4;
            }
            if (_version >= 1) {
                int _arraySize = 0;
                _arraySize = _version >= 6 ? (_arraySize += ByteUtils.sizeOfUnsignedVarint(this.endpoints.size() + 1)) : (_arraySize += 4);
                for (UpdateMetadataEndpoint endpointsElement : this.endpoints) {
                    _arraySize += endpointsElement.size(_cache, _version);
                }
                _size += _arraySize;
            }
            if (_version >= 2) {
                if (this.rack == null) {
                    _size = _version >= 6 ? ++_size : (_size += 2);
                } else {
                    _stringBytes = this.rack.getBytes(StandardCharsets.UTF_8);
                    if (_stringBytes.length > Short.MAX_VALUE) {
                        throw new RuntimeException("'rack' field is too long to be serialized");
                    }
                    _cache.cacheSerializedValue(this.rack, _stringBytes);
                    _size = _version >= 6 ? (_size += _stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1)) : (_size += _stringBytes.length + 2);
                }
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.tag());
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.size());
                    _size += _field.size();
                }
            }
            if (_version >= 6) {
                _size += ByteUtils.sizeOfUnsignedVarint(_numTaggedFields);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
            return _size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof UpdateMetadataBroker)) {
                return false;
            }
            UpdateMetadataBroker other = (UpdateMetadataBroker)obj;
            if (this.id != other.id) {
                return false;
            }
            if (this.v0Host == null ? other.v0Host != null : !this.v0Host.equals(other.v0Host)) {
                return false;
            }
            if (this.v0Port != other.v0Port) {
                return false;
            }
            if (this.endpoints == null ? other.endpoints != null : !this.endpoints.equals(other.endpoints)) {
                return false;
            }
            return !(this.rack == null ? other.rack != null : !this.rack.equals(other.rack));
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.id;
            hashCode = 31 * hashCode + (this.v0Host == null ? 0 : this.v0Host.hashCode());
            hashCode = 31 * hashCode + this.v0Port;
            hashCode = 31 * hashCode + (this.endpoints == null ? 0 : this.endpoints.hashCode());
            hashCode = 31 * hashCode + (this.rack == null ? 0 : this.rack.hashCode());
            return hashCode;
        }

        @Override
        public UpdateMetadataBroker duplicate() {
            UpdateMetadataBroker _duplicate = new UpdateMetadataBroker();
            _duplicate.id = this.id;
            _duplicate.v0Host = this.v0Host;
            _duplicate.v0Port = this.v0Port;
            ArrayList<UpdateMetadataEndpoint> newEndpoints = new ArrayList<UpdateMetadataEndpoint>(this.endpoints.size());
            for (UpdateMetadataEndpoint _element : this.endpoints) {
                newEndpoints.add(_element.duplicate());
            }
            _duplicate.endpoints = newEndpoints;
            _duplicate.rack = this.rack == null ? null : this.rack;
            return _duplicate;
        }

        public String toString() {
            return "UpdateMetadataBroker(id=" + this.id + ", v0Host=" + (this.v0Host == null ? "null" : "'" + this.v0Host.toString() + "'") + ", v0Port=" + this.v0Port + ", endpoints=" + MessageUtil.deepToString(this.endpoints.iterator()) + ", rack=" + (this.rack == null ? "null" : "'" + this.rack.toString() + "'") + ")";
        }

        public int id() {
            return this.id;
        }

        public String v0Host() {
            return this.v0Host;
        }

        public int v0Port() {
            return this.v0Port;
        }

        public List<UpdateMetadataEndpoint> endpoints() {
            return this.endpoints;
        }

        public String rack() {
            return this.rack;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public UpdateMetadataBroker setId(int v) {
            this.id = v;
            return this;
        }

        public UpdateMetadataBroker setV0Host(String v) {
            this.v0Host = v;
            return this;
        }

        public UpdateMetadataBroker setV0Port(int v) {
            this.v0Port = v;
            return this;
        }

        public UpdateMetadataBroker setEndpoints(List<UpdateMetadataEndpoint> v) {
            this.endpoints = v;
            return this;
        }

        public UpdateMetadataBroker setRack(String v) {
            this.rack = v;
            return this;
        }

        static {
            SCHEMA_5 = SCHEMA_4 = (SCHEMA_3 = new Schema(new Field("id", Type.INT32, "The broker id."), new Field("endpoints", new ArrayOf(UpdateMetadataEndpoint.SCHEMA_3), "The broker endpoints."), new Field("rack", Type.NULLABLE_STRING, "The rack which this broker belongs to.")));
            SCHEMA_6 = new Schema(new Field("id", Type.INT32, "The broker id."), new Field("endpoints", new CompactArrayOf(UpdateMetadataEndpoint.SCHEMA_6), "The broker endpoints."), new Field("rack", Type.COMPACT_NULLABLE_STRING, "The rack which this broker belongs to."), Field.TaggedFieldsSection.of(new Object[0]));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5, SCHEMA_6};
        }
    }

    public static class UpdateMetadataTopicState
    implements Message {
        private String topicName;
        private List<UpdateMetadataPartitionState> partitionStates;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_5 = new Schema(new Field("topic_name", Type.STRING, "The topic name."), new Field("partition_states", new ArrayOf(UpdateMetadataPartitionState.SCHEMA_5), "The partition that we would like to update."));
        public static final Schema SCHEMA_6 = new Schema(new Field("topic_name", Type.COMPACT_STRING, "The topic name."), new Field("partition_states", new CompactArrayOf(UpdateMetadataPartitionState.SCHEMA_6), "The partition that we would like to update."), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema[] SCHEMAS = new Schema[]{null, null, null, null, null, SCHEMA_5, SCHEMA_6};

        public UpdateMetadataTopicState(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public UpdateMetadataTopicState(Struct _struct, short _version) {
            this.fromStruct(_struct, _version);
        }

        public UpdateMetadataTopicState() {
            this.topicName = "";
            this.partitionStates = new ArrayList<UpdateMetadataPartitionState>(0);
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 6;
        }

        @Override
        public void read(Readable _readable, short _version) {
            int i;
            ArrayList<UpdateMetadataPartitionState> newCollection;
            int arrayLength;
            if (_version > 6) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of UpdateMetadataTopicState");
            }
            int length = _version >= 6 ? _readable.readUnsignedVarint() - 1 : _readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field topicName was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field topicName had invalid length " + length);
            }
            this.topicName = _readable.readString(length);
            if (_version >= 6) {
                arrayLength = _readable.readUnsignedVarint() - 1;
                if (arrayLength < 0) {
                    throw new RuntimeException("non-nullable field partitionStates was serialized as null");
                }
                newCollection = new ArrayList(arrayLength);
                for (i = 0; i < arrayLength; ++i) {
                    newCollection.add(new UpdateMetadataPartitionState(_readable, _version));
                }
                this.partitionStates = newCollection;
            } else {
                arrayLength = _readable.readInt();
                if (arrayLength < 0) {
                    throw new RuntimeException("non-nullable field partitionStates was serialized as null");
                }
                newCollection = new ArrayList<UpdateMetadataPartitionState>(arrayLength);
                for (i = 0; i < arrayLength; ++i) {
                    newCollection.add(new UpdateMetadataPartitionState(_readable, _version));
                }
                this.partitionStates = newCollection;
            }
            this._unknownTaggedFields = null;
            if (_version >= 6) {
                int _numTaggedFields = _readable.readUnsignedVarint();
                for (int _i = 0; _i < _numTaggedFields; ++_i) {
                    int _tag = _readable.readUnsignedVarint();
                    int _size = _readable.readUnsignedVarint();
                    switch (_tag) {
                        default: 
                    }
                    this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                }
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            if (_version < 5) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of UpdateMetadataTopicState");
            }
            int _numTaggedFields = 0;
            Object _stringBytes = _cache.getSerializedValue(this.topicName);
            if (_version >= 6) {
                _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            } else {
                _writable.writeShort((short)((byte[])_stringBytes).length);
            }
            _writable.writeByteArray((byte[])_stringBytes);
            if (_version >= 6) {
                _writable.writeUnsignedVarint(this.partitionStates.size() + 1);
                _stringBytes = this.partitionStates.iterator();
                while (_stringBytes.hasNext()) {
                    UpdateMetadataPartitionState partitionStatesElement = (UpdateMetadataPartitionState)_stringBytes.next();
                    partitionStatesElement.write(_writable, _cache, _version);
                }
            } else {
                _writable.writeInt(this.partitionStates.size());
                _stringBytes = this.partitionStates.iterator();
                while (_stringBytes.hasNext()) {
                    UpdateMetadataPartitionState partitionStatesElement = (UpdateMetadataPartitionState)_stringBytes.next();
                    partitionStatesElement.write(_writable, _cache, _version);
                }
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _numTaggedFields += _rawWriter.numFields();
            if (_version >= 6) {
                _writable.writeUnsignedVarint(_numTaggedFields);
                _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void fromStruct(Struct struct, short _version) {
            if (_version > 6) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of UpdateMetadataTopicState");
            }
            NavigableMap _taggedFields = null;
            this._unknownTaggedFields = null;
            if (_version >= 6) {
                _taggedFields = (NavigableMap)struct.get("_tagged_fields");
            }
            this.topicName = struct.getString("topic_name");
            Object[] _nestedObjects = struct.getArray("partition_states");
            this.partitionStates = new ArrayList<UpdateMetadataPartitionState>(_nestedObjects.length);
            for (Object nestedObject : _nestedObjects) {
                this.partitionStates.add(new UpdateMetadataPartitionState((Struct)nestedObject, _version));
            }
            if (_version >= 6 && !_taggedFields.isEmpty()) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(_taggedFields.size());
                for (Map.Entry entry : _taggedFields.entrySet()) {
                    this._unknownTaggedFields.add((RawTaggedField)entry.getValue());
                }
            }
        }

        @Override
        public Struct toStruct(short _version) {
            if (_version > 6) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of UpdateMetadataTopicState");
            }
            TreeMap _taggedFields = null;
            if (_version >= 6) {
                _taggedFields = new TreeMap();
            }
            Struct struct = new Struct(SCHEMAS[_version]);
            struct.set("topic_name", (Object)this.topicName);
            Struct[] _nestedObjects = new Struct[this.partitionStates.size()];
            int i = 0;
            for (UpdateMetadataPartitionState element : this.partitionStates) {
                _nestedObjects[i++] = element.toStruct(_version);
            }
            struct.set("partition_states", (Object)_nestedObjects);
            if (_version >= 6) {
                struct.set("_tagged_fields", _taggedFields);
            }
            return struct;
        }

        @Override
        public int size(ObjectSerializationCache _cache, short _version) {
            int _size = 0;
            int _numTaggedFields = 0;
            if (_version > 6) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of UpdateMetadataTopicState");
            }
            byte[] _stringBytes = this.topicName.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'topicName' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.topicName, _stringBytes);
            _size = _version >= 6 ? (_size += _stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1)) : (_size += _stringBytes.length + 2);
            int _arraySize = 0;
            _arraySize = _version >= 6 ? (_arraySize += ByteUtils.sizeOfUnsignedVarint(this.partitionStates.size() + 1)) : (_arraySize += 4);
            for (UpdateMetadataPartitionState partitionStatesElement : this.partitionStates) {
                _arraySize += partitionStatesElement.size(_cache, _version);
            }
            _size += _arraySize;
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.tag());
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.size());
                    _size += _field.size();
                }
            }
            if (_version >= 6) {
                _size += ByteUtils.sizeOfUnsignedVarint(_numTaggedFields);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
            return _size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof UpdateMetadataTopicState)) {
                return false;
            }
            UpdateMetadataTopicState other = (UpdateMetadataTopicState)obj;
            if (this.topicName == null ? other.topicName != null : !this.topicName.equals(other.topicName)) {
                return false;
            }
            return !(this.partitionStates == null ? other.partitionStates != null : !this.partitionStates.equals(other.partitionStates));
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.topicName == null ? 0 : this.topicName.hashCode());
            hashCode = 31 * hashCode + (this.partitionStates == null ? 0 : this.partitionStates.hashCode());
            return hashCode;
        }

        @Override
        public UpdateMetadataTopicState duplicate() {
            UpdateMetadataTopicState _duplicate = new UpdateMetadataTopicState();
            _duplicate.topicName = this.topicName;
            ArrayList<UpdateMetadataPartitionState> newPartitionStates = new ArrayList<UpdateMetadataPartitionState>(this.partitionStates.size());
            for (UpdateMetadataPartitionState _element : this.partitionStates) {
                newPartitionStates.add(_element.duplicate());
            }
            _duplicate.partitionStates = newPartitionStates;
            return _duplicate;
        }

        public String toString() {
            return "UpdateMetadataTopicState(topicName=" + (this.topicName == null ? "null" : "'" + this.topicName.toString() + "'") + ", partitionStates=" + MessageUtil.deepToString(this.partitionStates.iterator()) + ")";
        }

        public String topicName() {
            return this.topicName;
        }

        public List<UpdateMetadataPartitionState> partitionStates() {
            return this.partitionStates;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public UpdateMetadataTopicState setTopicName(String v) {
            this.topicName = v;
            return this;
        }

        public UpdateMetadataTopicState setPartitionStates(List<UpdateMetadataPartitionState> v) {
            this.partitionStates = v;
            return this;
        }
    }
}

