/*
 * Decompiled with CFR 0.152.
 */
package com.ecwid.consul.v1.coordinate;

import com.ecwid.consul.UrlParameters;
import com.ecwid.consul.json.GsonFactory;
import com.ecwid.consul.transport.RawResponse;
import com.ecwid.consul.v1.ConsulRawClient;
import com.ecwid.consul.v1.OperationException;
import com.ecwid.consul.v1.QueryParams;
import com.ecwid.consul.v1.Response;
import com.ecwid.consul.v1.coordinate.CoordinateClient;
import com.ecwid.consul.v1.coordinate.model.Datacenter;
import com.ecwid.consul.v1.coordinate.model.Node;
import com.google.gson.reflect.TypeToken;
import java.util.List;

public class CoordinateConsulClient
implements CoordinateClient {
    private final ConsulRawClient rawClient;

    public CoordinateConsulClient(ConsulRawClient rawClient) {
        this.rawClient = rawClient;
    }

    @Override
    public Response<List<Datacenter>> getDatacenters() {
        RawResponse rawResponse = this.rawClient.makeGetRequest("/v1/coordinate/datacenters", new UrlParameters[0]);
        if (rawResponse.getStatusCode() == 200) {
            List value = (List)GsonFactory.getGson().fromJson(rawResponse.getContent(), new TypeToken<List<Datacenter>>(){}.getType());
            return new Response<List<Datacenter>>(value, rawResponse);
        }
        throw new OperationException(rawResponse);
    }

    @Override
    public Response<List<Node>> getNodes(QueryParams queryParams) {
        RawResponse rawResponse = this.rawClient.makeGetRequest("/v1/coordinate/nodes", queryParams);
        if (rawResponse.getStatusCode() == 200) {
            List value = (List)GsonFactory.getGson().fromJson(rawResponse.getContent(), new TypeToken<List<Node>>(){}.getType());
            return new Response<List<Node>>(value, rawResponse);
        }
        throw new OperationException(rawResponse);
    }
}

