/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.common.util;

import java.sql.Blob;
import javax.sql.rowset.serial.SerialBlob;
import org.apache.seata.common.Constants;
import org.apache.seata.common.exception.ShouldNeverHappenException;

public class BlobUtils {
    private BlobUtils() {
    }

    public static Blob string2blob(String str) {
        if (str == null) {
            return null;
        }
        try {
            return new SerialBlob(str.getBytes(Constants.DEFAULT_CHARSET));
        }
        catch (Exception e) {
            throw new ShouldNeverHappenException(e);
        }
    }

    public static String blob2string(Blob blob) {
        if (blob == null) {
            return null;
        }
        try {
            return new String(blob.getBytes(1L, (int)blob.length()), Constants.DEFAULT_CHARSET);
        }
        catch (Exception e) {
            throw new ShouldNeverHappenException(e);
        }
    }

    public static Blob bytes2Blob(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        try {
            return new SerialBlob(bytes);
        }
        catch (Exception e) {
            throw new ShouldNeverHappenException(e);
        }
    }

    public static byte[] blob2Bytes(Blob blob) {
        if (blob == null) {
            return null;
        }
        try {
            return blob.getBytes(1L, (int)blob.length());
        }
        catch (Exception e) {
            throw new ShouldNeverHappenException(e);
        }
    }
}

