/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.server.console.impl.file;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.seata.common.result.PageResult;
import org.apache.seata.common.result.SingleResult;
import org.apache.seata.common.util.CollectionUtils;
import org.apache.seata.common.util.StringUtils;
import org.apache.seata.core.exception.TransactionException;
import org.apache.seata.core.lock.RowLock;
import org.apache.seata.server.console.entity.bo.GlobalLockQueryBO;
import org.apache.seata.server.console.entity.param.GlobalLockParam;
import org.apache.seata.server.console.entity.vo.GlobalLockVO;
import org.apache.seata.server.console.exception.ConsoleException;
import org.apache.seata.server.console.impl.AbstractLockService;
import org.apache.seata.server.console.impl.redis.GlobalLockRedisServiceImpl;
import org.apache.seata.server.console.service.GlobalLockService;
import org.apache.seata.server.lock.LockerManagerFactory;
import org.apache.seata.server.session.BranchSession;
import org.apache.seata.server.session.GlobalSession;
import org.apache.seata.server.session.SessionHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.context.annotation.Configuration;
import org.springframework.stereotype.Component;

@Component
@Configuration
@ConditionalOnExpression(value="#{'file'.equals('${lockMode}')}")
public class GlobalLockFileServiceImpl
extends AbstractLockService
implements GlobalLockService {
    private static final Logger LOGGER = LoggerFactory.getLogger(GlobalLockRedisServiceImpl.class);

    public PageResult<GlobalLockVO> query(GlobalLockParam param) {
        this.checkParam(param);
        Collection allSessions = SessionHolder.getRootSessionManager().allSessions();
        List result = allSessions.parallelStream().filter(this.obtainGlobalSessionPredicate(param)).flatMap(globalSession -> globalSession.getBranchSessions().stream().filter(this.obtainBranchSessionPredicate(param)).flatMap(branchSession -> this.filterAndMap(param, branchSession).map(lock -> new GlobalLockQueryBO(lock, globalSession)))).collect(Collectors.toList());
        return PageResult.build((List)GlobalLockVO.convert(result), (Integer)param.getPageNum(), (Integer)param.getPageSize());
    }

    public SingleResult<Void> deleteLock(GlobalLockParam param) {
        GlobalSession globalSession;
        this.checkDeleteLock(param);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("start to delete global lock,xid:{} branchId:{}", (Object)param.getXid(), (Object)param.getBranchId());
        }
        if ((globalSession = SessionHolder.getRootSessionManager().findGlobalSession(param.getXid(), true)) != null) {
            List branchSessions = globalSession.getBranchSessions().stream().filter(branchSession -> branchSession.getBranchId() == Long.parseLong(param.getBranchId())).collect(Collectors.toList());
            if (branchSessions.size() != 1) {
                throw new ConsoleException((Throwable)new UnsupportedOperationException("branch session size is not one"), String.format("delete global lock,xid:%s ,branchId:%s", param.getXid(), param.getBranchId()));
            }
            try {
                this.lockManager.releaseLock((BranchSession)branchSessions.get(0));
            }
            catch (TransactionException e) {
                throw new ConsoleException((Throwable)e, String.format("delete global lock,xid:%s ,branchId:%s", param.getXid(), param.getBranchId()));
            }
        }
        return SingleResult.success();
    }

    private Stream<RowLock> filterAndMap(GlobalLockParam param, BranchSession branchSession) {
        if (CollectionUtils.isEmpty((Map)branchSession.getLockHolder())) {
            return Stream.empty();
        }
        String tableName = param.getTableName();
        List rowLocks = LockerManagerFactory.getLockManager().collectRowLocks(branchSession);
        if (StringUtils.isNotBlank((String)tableName)) {
            return rowLocks.parallelStream().filter(rowLock -> rowLock.getTableName().contains(param.getTableName()));
        }
        return rowLocks.stream();
    }

    private void checkParam(GlobalLockParam param) {
        if (param.getPageSize() <= 0 || param.getPageNum() <= 0) {
            throw new IllegalArgumentException("wrong pageSize or pageNum");
        }
        try {
            Long.parseLong(param.getTransactionId());
        }
        catch (NumberFormatException e) {
            param.setTransactionId(null);
        }
        try {
            Long.parseLong(param.getBranchId());
        }
        catch (NumberFormatException e) {
            param.setBranchId(null);
        }
    }

    private Predicate<? super BranchSession> obtainBranchSessionPredicate(GlobalLockParam param) {
        return branchSession -> !(!StringUtils.isBlank((String)param.getTransactionId()) && !String.valueOf(branchSession.getTransactionId()).contains(param.getTransactionId()) || !StringUtils.isBlank((String)param.getBranchId()) && !String.valueOf(branchSession.getBranchId()).contains(param.getBranchId()));
    }

    private Predicate<? super GlobalSession> obtainGlobalSessionPredicate(GlobalLockParam param) {
        return globalSession -> !(!CollectionUtils.isNotEmpty((Collection)globalSession.getBranchSessions()) || !StringUtils.isBlank((String)param.getXid()) && !globalSession.getXid().contains(param.getXid()) || !Objects.isNull(param.getTimeStart()) && param.getTimeStart() / 1000L < globalSession.getBeginTime() / 1000L || !Objects.isNull(param.getTimeEnd()) && param.getTimeEnd() / 1000L > globalSession.getBeginTime() / 1000L);
    }
}

