/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.util;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.function.BiConsumer;
import org.apache.skywalking.apm.util.ConfigDesc;
import org.apache.skywalking.apm.util.Length;
import org.apache.skywalking.apm.util.StringUtil;

public class ConfigInitializer {
    public static void initialize(Properties properties, Class<?> rootConfigType) throws IllegalAccessException {
        ConfigInitializer.initNextLevel(properties, rootConfigType, new ConfigDesc());
    }

    private static void initNextLevel(Properties properties, Class<?> recentConfigType, ConfigDesc parentDesc) throws IllegalArgumentException, IllegalAccessException {
        for (Field field : recentConfigType.getFields()) {
            Object convertedValue;
            if (!Modifier.isPublic(field.getModifiers()) || !Modifier.isStatic(field.getModifiers())) continue;
            String configKey = (parentDesc + "." + field.getName()).toLowerCase();
            Class<?> type = field.getType();
            if (type.equals(Map.class)) {
                ParameterizedType genericType = (ParameterizedType)field.getGenericType();
                Type[] argumentTypes = genericType.getActualTypeArguments();
                Type keyType = null;
                Type valueType = null;
                if (argumentTypes != null && argumentTypes.length == 2) {
                    keyType = argumentTypes[0];
                    valueType = argumentTypes[1];
                }
                Map map = (Map)field.get(null);
                ConfigInitializer.setForMapType(configKey, map, properties, keyType, valueType);
                continue;
            }
            String value = properties.getProperty(configKey);
            Length lengthDefine = field.getAnnotation(Length.class);
            if (lengthDefine != null && value != null && value.length() > lengthDefine.value()) {
                value = value.substring(0, lengthDefine.value());
            }
            if ((convertedValue = ConfigInitializer.convertToTypicalType(type, value)) == null) continue;
            field.set(null, convertedValue);
        }
        for (AnnotatedElement annotatedElement : recentConfigType.getClasses()) {
            parentDesc.append(((Class)annotatedElement).getSimpleName());
            ConfigInitializer.initNextLevel(properties, annotatedElement, parentDesc);
            parentDesc.removeLastDesc();
        }
    }

    private static Object convertToTypicalType(Type type, String value) {
        Class clazz;
        if (value == null || type == null) {
            return null;
        }
        List<String> result = null;
        if (String.class.equals((Object)type)) {
            result = value;
        } else if (Integer.TYPE.equals(type) || Integer.class.equals((Object)type)) {
            result = Integer.valueOf(value);
        } else if (Long.TYPE.equals(type) || Long.class.equals((Object)type)) {
            result = Long.valueOf(value);
        } else if (Boolean.TYPE.equals(type) || Boolean.class.equals((Object)type)) {
            result = Boolean.valueOf(value);
        } else if (Float.TYPE.equals(type) || Float.class.equals((Object)type)) {
            result = Float.valueOf(value);
        } else if (Double.TYPE.equals(type) || Double.class.equals((Object)type)) {
            result = Double.valueOf(value);
        } else if (List.class.equals((Object)type)) {
            result = ConfigInitializer.convert2List(value);
        } else if (type instanceof Class && (clazz = (Class)type).isEnum()) {
            result = Enum.valueOf((Class)type, value.toUpperCase());
        }
        return result;
    }

    private static void setForMapType(String configKey, Map<Object, Object> map, Properties properties, Type keyType, Type valueType) {
        Objects.requireNonNull(configKey);
        Objects.requireNonNull(map);
        Objects.requireNonNull(properties);
        String prefix = configKey + "[";
        String suffix = "]";
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(propertyKey, propertyValue) -> {
            String propertyStringKey = propertyKey.toString();
            if (propertyStringKey.startsWith(prefix) && propertyStringKey.endsWith(suffix)) {
                String itemKey = propertyStringKey.substring(prefix.length(), propertyStringKey.length() - suffix.length());
                Object keyObj = ConfigInitializer.convertToTypicalType(keyType, itemKey);
                Object valueObj = ConfigInitializer.convertToTypicalType(valueType, propertyValue.toString());
                if (keyObj == null) {
                    keyObj = itemKey;
                }
                if (valueObj == null) {
                    valueObj = propertyValue;
                }
                map.put(keyObj, valueObj);
            }
        }));
    }

    private static List<String> convert2List(String value) {
        String[] segments;
        if (StringUtil.isEmpty(value)) {
            return Collections.emptyList();
        }
        LinkedList<String> result = new LinkedList<String>();
        for (String segment : segments = value.split(",")) {
            String trimmedSegment = segment.trim();
            if (!StringUtil.isNotEmpty(trimmedSegment)) continue;
            result.add(trimmedSegment);
        }
        return result;
    }
}

