#
# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
#
#  http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.
#

# Generate image from whimsey JSON file amd Apache Logos to
# update slides run ike so:
# python3 projects.py

import urllib.request, json

#imagePath = "https://www.apache.org/img/"
imagePath = "http://www.apache.org/logos/res/"

with urllib.request.urlopen("https://whimsy.apache.org/public/pods-scan.json") as url:
    pods = json.loads(url.read().decode())
    for podling in pods:
        # try to get jpg logo
        found = True
        #logo = imagePath + podling + ".jpg" 
        logo = imagePath + podling + "/default.png"
        try:
            response = urllib.request.urlopen(logo)
        except urllib.error.HTTPError as error:
            # if missing try png instead
            if error.code == 404:
                logo = imagePath + podling + ".png"
                try:
                    response = urllib.request.urlopen(logo)
                except urllib.error.HTTPError as error:
                    found = False
            else:
                found = False
        if found:
            todo = True
        else:
            #missing podlings
            print(podling)