/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.stream.Stream;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.Scannable;
import reactor.core.publisher.InnerOperator;
import reactor.core.publisher.InternalEmptySink;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Operators;
import reactor.core.publisher.Sinks;
import reactor.util.context.Context;

final class SinkEmptyMulticast<T>
extends Mono<T>
implements InternalEmptySink<T> {
    volatile VoidInner<T>[] subscribers;
    static final AtomicReferenceFieldUpdater<SinkEmptyMulticast, VoidInner[]> SUBSCRIBERS = AtomicReferenceFieldUpdater.newUpdater(SinkEmptyMulticast.class, VoidInner[].class, "subscribers");
    static final VoidInner[] EMPTY = new VoidInner[0];
    static final VoidInner[] TERMINATED = new VoidInner[0];
    Throwable error;

    SinkEmptyMulticast() {
        SUBSCRIBERS.lazySet(this, EMPTY);
    }

    @Override
    public int currentSubscriberCount() {
        return this.subscribers.length;
    }

    @Override
    public Mono<T> asMono() {
        return this;
    }

    @Override
    public Sinks.EmitResult tryEmitEmpty() {
        VoidInner[] array = SUBSCRIBERS.getAndSet(this, TERMINATED);
        if (array == TERMINATED) {
            return Sinks.EmitResult.FAIL_TERMINATED;
        }
        for (VoidInner as : array) {
            as.onComplete();
        }
        return Sinks.EmitResult.OK;
    }

    @Override
    public Sinks.EmitResult tryEmitError(Throwable cause) {
        Objects.requireNonNull(cause, "onError cannot be null");
        if (this.subscribers == TERMINATED) {
            return Sinks.EmitResult.FAIL_TERMINATED;
        }
        this.error = cause;
        for (VoidInner as : SUBSCRIBERS.getAndSet(this, TERMINATED)) {
            as.onError(cause);
        }
        return Sinks.EmitResult.OK;
    }

    @Override
    public Context currentContext() {
        return Operators.multiSubscribersContext(this.subscribers);
    }

    boolean add(VoidInner<T> ps) {
        VoidInner[] b;
        VoidInner<T>[] a;
        do {
            if ((a = this.subscribers) == TERMINATED) {
                return false;
            }
            int n = a.length;
            b = new VoidInner[n + 1];
            System.arraycopy(a, 0, b, 0, n);
            b[n] = ps;
        } while (!SUBSCRIBERS.compareAndSet(this, a, b));
        return true;
    }

    void remove(VoidInner<T> ps) {
        VoidInner[] b;
        VoidInner<T>[] a;
        do {
            int n;
            if ((n = (a = this.subscribers).length) == 0) {
                return;
            }
            int j = -1;
            for (int i = 0; i < n; ++i) {
                if (a[i] != ps) continue;
                j = i;
                break;
            }
            if (j < 0) {
                return;
            }
            if (n == 1) {
                b = EMPTY;
                continue;
            }
            b = new VoidInner[n - 1];
            System.arraycopy(a, 0, b, 0, j);
            System.arraycopy(a, j + 1, b, j, n - j - 1);
        } while (!SUBSCRIBERS.compareAndSet(this, a, b));
    }

    @Override
    public void subscribe(CoreSubscriber<? super T> actual) {
        VoidInner<T> as = new VoidInner<T>(actual, this);
        actual.onSubscribe(as);
        if (this.add(as)) {
            if (as.get()) {
                this.remove(as);
            }
        } else {
            if (as.get()) {
                return;
            }
            Throwable ex = this.error;
            if (ex != null) {
                actual.onError(ex);
            } else {
                actual.onComplete();
            }
        }
    }

    @Override
    public Stream<? extends Scannable> inners() {
        return Stream.of(this.subscribers);
    }

    @Override
    public Object scanUnsafe(Scannable.Attr key) {
        if (key == Scannable.Attr.TERMINATED) {
            return this.subscribers == TERMINATED;
        }
        if (key == Scannable.Attr.ERROR) {
            return this.error;
        }
        return null;
    }

    static final class VoidInner<T>
    extends AtomicBoolean
    implements InnerOperator<Void, T> {
        final SinkEmptyMulticast<T> parent;
        final CoreSubscriber<? super T> actual;

        VoidInner(CoreSubscriber<? super T> actual, SinkEmptyMulticast<T> parent) {
            this.actual = actual;
            this.parent = parent;
        }

        public void cancel() {
            if (this.getAndSet(true)) {
                return;
            }
            this.parent.remove(this);
        }

        public void request(long l) {
            Operators.validate(l);
        }

        @Override
        public void onSubscribe(Subscription s) {
            Objects.requireNonNull(s);
        }

        public void onNext(Void aVoid) {
        }

        public void onComplete() {
            if (this.get()) {
                return;
            }
            this.actual.onComplete();
        }

        public void onError(Throwable t) {
            if (this.get()) {
                Operators.onOperatorError(t, this.currentContext());
                return;
            }
            this.actual.onError(t);
        }

        @Override
        public CoreSubscriber<? super T> actual() {
            return this.actual;
        }

        @Override
        public Object scanUnsafe(Scannable.Attr key) {
            if (key == Scannable.Attr.PARENT) {
                return this.parent;
            }
            if (key == Scannable.Attr.CANCELLED) {
                return this.get();
            }
            if (key == Scannable.Attr.RUN_STYLE) {
                return Scannable.Attr.RunStyle.SYNC;
            }
            return InnerOperator.super.scanUnsafe(key);
        }
    }
}

