/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.archiving;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.archiving.ArchivingOperate;
import org.apache.iotdb.db.engine.archiving.ArchivingOperateReader;
import org.apache.iotdb.db.engine.archiving.ArchivingOperateWriter;
import org.apache.iotdb.db.engine.archiving.ArchivingTask;
import org.apache.iotdb.db.engine.fileSystem.SystemFileFactory;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.tsfile.utils.FilePathUtils;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArchivingRecover {
    private static final Logger logger = LoggerFactory.getLogger(ArchivingRecover.class);
    private static final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private static final File LOG_FILE = SystemFileFactory.INSTANCE.getFile(Paths.get(FilePathUtils.regularizePath((String)config.getSystemDir()), "archiving", "log.bin").toString());
    private static final File ARCHIVING_LOG_DIR = SystemFileFactory.INSTANCE.getFile(Paths.get(FilePathUtils.regularizePath((String)config.getSystemDir()), "archiving", "archiving_task").toString());
    private Map<Long, ArchivingTask> archivingTasks;
    private long currentTaskId = 0L;

    public List<ArchivingTask> recover() {
        this.recoverArchivingFiles();
        this.archivingTasks = new HashMap<Long, ArchivingTask>();
        this.currentTaskId = 0L;
        try (ArchivingOperateReader logReader = new ArchivingOperateReader(LOG_FILE);
             ArchivingOperateWriter logWriter = new ArchivingOperateWriter(LOG_FILE);){
            HashSet<Long> errorSet = new HashSet<Long>();
            block21: while (logReader.hasNext()) {
                ArchivingOperate operate = logReader.next();
                long taskId = operate.getTask().getTaskId();
                switch (operate.getType()) {
                    case SET: {
                        this.setArchivingFromLog(operate.getTask());
                        continue block21;
                    }
                    case CANCEL: {
                        this.operateFromLog(ArchivingOperate.ArchivingOperateType.CANCEL, taskId);
                        continue block21;
                    }
                    case START: {
                        errorSet.add(taskId);
                        continue block21;
                    }
                    case PAUSE: {
                        errorSet.remove(taskId);
                        this.operateFromLog(ArchivingOperate.ArchivingOperateType.PAUSE, taskId);
                        continue block21;
                    }
                    case RESUME: {
                        this.operateFromLog(ArchivingOperate.ArchivingOperateType.RESUME, taskId);
                        continue block21;
                    }
                    case FINISHED: {
                        errorSet.remove(taskId);
                        this.archivingTasks.remove(taskId);
                        this.operateFromLog(ArchivingOperate.ArchivingOperateType.FINISHED, taskId);
                        continue block21;
                    }
                    case ERROR: {
                        errorSet.remove(taskId);
                        this.operateFromLog(ArchivingOperate.ArchivingOperateType.ERROR, taskId);
                        continue block21;
                    }
                }
                logger.error("read archiving log: unknown type");
            }
            Iterator iterator = errorSet.iterator();
            while (iterator.hasNext()) {
                long errTaskId = (Long)iterator.next();
                if (this.archivingTasks.containsKey(errTaskId)) {
                    logWriter.log(ArchivingOperate.ArchivingOperateType.ERROR, this.archivingTasks.get(errTaskId));
                    this.operateFromLog(ArchivingOperate.ArchivingOperateType.ERROR, errTaskId);
                    continue;
                }
                logger.error("unknown error taskId");
            }
        }
        catch (Exception e) {
            logger.error("Cannot read log for archiving.");
        }
        this.recoverArchivingFiles();
        return new ArrayList<ArchivingTask>(this.archivingTasks.values());
    }

    public void setArchivingFromLog(ArchivingTask newTask) {
        if (this.currentTaskId > newTask.getTaskId()) {
            logger.error("set archiving error, current index larger than log index");
        }
        this.archivingTasks.put(newTask.getTaskId(), newTask);
        this.currentTaskId = newTask.getTaskId() + 1L;
    }

    private ArchivingTask.ArchivingTaskStatus statusFromOperateType(ArchivingOperate.ArchivingOperateType archivingOperateType) {
        switch (archivingOperateType) {
            case RESUME: {
                return ArchivingTask.ArchivingTaskStatus.READY;
            }
            case CANCEL: {
                return ArchivingTask.ArchivingTaskStatus.CANCELED;
            }
            case START: {
                return ArchivingTask.ArchivingTaskStatus.RUNNING;
            }
            case PAUSE: {
                return ArchivingTask.ArchivingTaskStatus.PAUSED;
            }
            case FINISHED: {
                return ArchivingTask.ArchivingTaskStatus.FINISHED;
            }
            case ERROR: {
                return ArchivingTask.ArchivingTaskStatus.ERROR;
            }
        }
        return null;
    }

    public boolean operateFromLog(ArchivingOperate.ArchivingOperateType operateType, long taskId) {
        if (this.archivingTasks.containsKey(taskId)) {
            this.archivingTasks.get(taskId).setStatus(this.statusFromOperateType(operateType));
            return true;
        }
        return false;
    }

    public void recoverArchivingFiles() {
        File[] archivingLogFiles;
        for (File logFile : archivingLogFiles = ARCHIVING_LOG_DIR.listFiles()) {
            String tsfilePath;
            File targetDir;
            FileInputStream logFileInput;
            block12: {
                try {
                    logFileInput = new FileInputStream(logFile);
                    String targetDirPath = ReadWriteIOUtils.readString((InputStream)logFileInput);
                    targetDir = SystemFileFactory.INSTANCE.getFile(targetDirPath);
                    tsfilePath = ReadWriteIOUtils.readString((InputStream)logFileInput);
                    if (targetDir.exists()) {
                        if (!targetDir.isDirectory()) {
                            logger.error("target dir {} not a directory", (Object)targetDirPath);
                            continue;
                        }
                    } else if (!targetDir.mkdirs()) {
                        logger.error("create target dir {} failed", (Object)targetDirPath);
                    }
                    break block12;
                }
                catch (IOException e) {
                    logger.error("ArchivingRecover: log file not found");
                }
                continue;
            }
            while (tsfilePath != null && !tsfilePath.isEmpty()) {
                File tsfile = SystemFileFactory.INSTANCE.getFile(tsfilePath);
                TsFileResource resource = new TsFileResource(tsfile);
                resource.archive(targetDir);
                try {
                    tsfilePath = ReadWriteIOUtils.readString((InputStream)logFileInput);
                }
                catch (IOException e) {
                    break;
                }
            }
            try {
                logFileInput.close();
            }
            catch (IOException e) {
                logger.error("Archiving Log File Error", (Throwable)e);
                break;
            }
            logFile.delete();
        }
    }

    public List<ArchivingTask> getArchivingTasks() {
        return new ArrayList<ArchivingTask>(this.archivingTasks.values());
    }

    public long getCurrentTaskId() {
        return this.currentTaskId;
    }
}

