/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.compaction.cross;

import java.util.List;
import org.apache.iotdb.db.engine.compaction.cross.CrossSpaceCompactionTaskFactory;
import org.apache.iotdb.db.engine.compaction.task.AbstractCompactionSelector;
import org.apache.iotdb.db.engine.storagegroup.TsFileManager;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;

public abstract class AbstractCrossSpaceCompactionSelector
extends AbstractCompactionSelector {
    protected String logicalStorageGroupName;
    protected String virtualGroupId;
    protected String storageGroupDir;
    protected long timePartition;
    protected TsFileManager tsFileManager;
    protected List<TsFileResource> sequenceFileList;
    protected List<TsFileResource> unsequenceFileList;
    protected CrossSpaceCompactionTaskFactory taskFactory;

    public AbstractCrossSpaceCompactionSelector(String logicalStorageGroupName, String virtualGroupId, String storageGroupDir, long timePartition, TsFileManager tsFileManager, CrossSpaceCompactionTaskFactory taskFactory) {
        this.logicalStorageGroupName = logicalStorageGroupName;
        this.virtualGroupId = virtualGroupId;
        this.storageGroupDir = storageGroupDir;
        this.timePartition = timePartition;
        this.sequenceFileList = tsFileManager.getSequenceListByTimePartition(timePartition);
        this.unsequenceFileList = tsFileManager.getUnsequenceListByTimePartition(timePartition);
        this.taskFactory = taskFactory;
        this.tsFileManager = tsFileManager;
    }

    @Override
    public abstract void selectAndSubmit();
}

