/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.compaction.inner;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.iotdb.db.engine.compaction.task.AbstractCompactionTask;
import org.apache.iotdb.db.engine.storagegroup.TsFileManager;
import org.apache.iotdb.db.engine.storagegroup.TsFileNameGenerator;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.engine.storagegroup.TsFileResourceStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractInnerSpaceCompactionTask
extends AbstractCompactionTask {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"COMPACTION");
    protected List<TsFileResource> selectedTsFileResourceList;
    protected boolean sequence;
    protected long selectedFileSize;
    protected int sumOfCompactionCount;
    protected long maxFileVersion;
    protected int maxCompactionCount;

    public AbstractInnerSpaceCompactionTask(String storageGroupName, long timePartition, AtomicInteger currentTaskNum, boolean sequence, List<TsFileResource> selectedTsFileResourceList, TsFileManager tsFileManager) {
        super(storageGroupName, timePartition, tsFileManager, currentTaskNum);
        this.selectedTsFileResourceList = selectedTsFileResourceList;
        this.sequence = sequence;
        this.collectSelectedFilesInfo();
    }

    @Override
    public void setSourceFilesToCompactionCandidate() {
        this.selectedTsFileResourceList.forEach(tsFileResource -> {
            try {
                tsFileResource.setStatus(TsFileResourceStatus.COMPACTION_CANDIDATE);
            }
            catch (Exception e) {
                LOGGER.error("Exception occurs when setting compaction candidate", (Throwable)e);
            }
        });
    }

    private void collectSelectedFilesInfo() {
        this.selectedFileSize = 0L;
        this.sumOfCompactionCount = 0;
        this.maxFileVersion = -1L;
        this.maxCompactionCount = -1;
        if (this.selectedTsFileResourceList == null) {
            return;
        }
        for (TsFileResource resource : this.selectedTsFileResourceList) {
            try {
                this.selectedFileSize += resource.getTsFileSize();
                TsFileNameGenerator.TsFileName fileName = TsFileNameGenerator.getTsFileName(resource.getTsFile().getName());
                this.sumOfCompactionCount += fileName.getInnerCompactionCnt();
                if (fileName.getInnerCompactionCnt() > this.maxCompactionCount) {
                    this.maxCompactionCount = fileName.getInnerCompactionCnt();
                }
                if (fileName.getVersion() <= this.maxFileVersion) continue;
                this.maxFileVersion = fileName.getVersion();
            }
            catch (IOException e) {
                LOGGER.warn("Fail to get the tsfile name of {}", (Object)resource.getTsFile(), (Object)e);
            }
        }
    }

    public List<TsFileResource> getSelectedTsFileResourceList() {
        return this.selectedTsFileResourceList;
    }

    public boolean isSequence() {
        return this.sequence;
    }

    public long getSelectedFileSize() {
        return this.selectedFileSize;
    }

    public int getSumOfCompactionCount() {
        return this.sumOfCompactionCount;
    }

    public long getMaxFileVersion() {
        return this.maxFileVersion;
    }

    @Override
    public boolean checkValidAndSetMerging() {
        for (TsFileResource resource : this.selectedTsFileResourceList) {
            if (!(resource.isCompacting() | !resource.isClosed()) && resource.getTsFile().exists()) continue;
            return false;
        }
        for (TsFileResource resource : this.selectedTsFileResourceList) {
            resource.setStatus(TsFileResourceStatus.COMPACTING);
        }
        return true;
    }

    public String toString() {
        return this.fullStorageGroupName + "-" + this.timePartition + " task file num is " + this.selectedTsFileResourceList.size() + ", files is " + this.selectedTsFileResourceList + ", total compaction count is " + this.sumOfCompactionCount;
    }

    @Override
    public void resetCompactionCandidateStatusForAllSourceFiles() {
        this.selectedTsFileResourceList.forEach(x -> x.setStatus(TsFileResourceStatus.CLOSED));
    }
}

