/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.trigger.api;

import org.apache.iotdb.db.engine.trigger.api.TriggerAttributes;
import org.apache.iotdb.tsfile.utils.Binary;

public interface Trigger {
    default public void onCreate(TriggerAttributes attributes) throws Exception {
    }

    default public void onDrop() throws Exception {
    }

    default public void onStart() throws Exception {
    }

    default public void onStop() throws Exception {
    }

    default public Integer fire(long timestamp, Integer value) throws Exception {
        return value;
    }

    default public int[] fire(long[] timestamps, int[] values) throws Exception {
        int size = timestamps.length;
        for (int i = 0; i < size; ++i) {
            this.fire(timestamps[i], values[i]);
        }
        return values;
    }

    default public Long fire(long timestamp, Long value) throws Exception {
        return value;
    }

    default public long[] fire(long[] timestamps, long[] values) throws Exception {
        int size = timestamps.length;
        for (int i = 0; i < size; ++i) {
            this.fire(timestamps[i], values[i]);
        }
        return values;
    }

    default public Float fire(long timestamp, Float value) throws Exception {
        return value;
    }

    default public float[] fire(long[] timestamps, float[] values) throws Exception {
        int size = timestamps.length;
        for (int i = 0; i < size; ++i) {
            this.fire(timestamps[i], Float.valueOf(values[i]));
        }
        return values;
    }

    default public Double fire(long timestamp, Double value) throws Exception {
        return value;
    }

    default public double[] fire(long[] timestamps, double[] values) throws Exception {
        int size = timestamps.length;
        for (int i = 0; i < size; ++i) {
            this.fire(timestamps[i], values[i]);
        }
        return values;
    }

    default public Boolean fire(long timestamp, Boolean value) throws Exception {
        return value;
    }

    default public boolean[] fire(long[] timestamps, boolean[] values) throws Exception {
        int size = timestamps.length;
        for (int i = 0; i < size; ++i) {
            this.fire(timestamps[i], values[i]);
        }
        return values;
    }

    default public Binary fire(long timestamp, Binary value) throws Exception {
        return value;
    }

    default public Binary[] fire(long[] timestamps, Binary[] values) throws Exception {
        int size = timestamps.length;
        for (int i = 0; i < size; ++i) {
            this.fire(timestamps[i], values[i]);
        }
        return values;
    }
}

