/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.trigger.service;

import java.util.Map;
import org.apache.iotdb.db.engine.trigger.executor.TriggerEvent;
import org.apache.iotdb.db.metadata.path.PartialPath;
import org.apache.iotdb.db.qp.physical.sys.CreateTriggerPlan;

public class TriggerRegistrationInformation {
    private final String triggerName;
    private final TriggerEvent event;
    private final PartialPath fullPath;
    private final String className;
    private final Map<String, String> attributes;
    private volatile boolean isStopped;

    public TriggerRegistrationInformation(CreateTriggerPlan plan) {
        this.triggerName = plan.getTriggerName();
        this.event = plan.getEvent();
        this.fullPath = plan.getFullPath();
        this.className = plan.getClassName();
        this.attributes = plan.getAttributes();
        this.isStopped = plan.isStopped();
    }

    public CreateTriggerPlan convertToCreateTriggerPlan() {
        return new CreateTriggerPlan(this.triggerName, this.event, this.fullPath, this.className, this.attributes);
    }

    public void markAsStarted() {
        this.isStopped = false;
    }

    public void markAsStopped() {
        this.isStopped = true;
    }

    public String getTriggerName() {
        return this.triggerName;
    }

    public TriggerEvent getEvent() {
        return this.event;
    }

    public PartialPath getFullPath() {
        return this.fullPath;
    }

    public String getClassName() {
        return this.className;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public boolean isStopped() {
        return this.isStopped;
    }
}

