/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.protocol.influxdb.meta;

import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.db.exception.metadata.IllegalPathException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.path.PartialPath;
import org.apache.iotdb.db.qp.physical.crud.InsertRowPlan;
import org.apache.iotdb.db.utils.DataTypeUtils;
import org.apache.iotdb.rpc.IoTDBConnectionException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.influxdb.InfluxDBException;

public class TagInfoRecords {
    private static final String TAG_INFO_DEVICE_ID = "root.TAG_INFO";
    private static final List<String> TAG_INFO_MEASUREMENTS = new ArrayList<String>();
    private static final List<TSDataType> TAG_INFO_TYPES = new ArrayList<TSDataType>();
    private final List<String> deviceIds = new ArrayList<String>();
    private final List<Long> times = new ArrayList<Long>();
    private final List<List<String>> measurementsList = new ArrayList<List<String>>();
    private final List<List<TSDataType>> typesList = new ArrayList<List<TSDataType>>();
    private final List<List<Object>> valuesList = new ArrayList<List<Object>>();

    public void add(String database, String measurement, String tag, int order) {
        this.deviceIds.add(TAG_INFO_DEVICE_ID);
        this.times.add(System.currentTimeMillis());
        this.measurementsList.add(TAG_INFO_MEASUREMENTS);
        this.typesList.add(TAG_INFO_TYPES);
        ArrayList<Object> values = new ArrayList<Object>();
        values.add(database);
        values.add(measurement);
        values.add(tag);
        values.add(order);
        this.valuesList.add(values);
    }

    public List<InsertRowPlan> convertToInsertRowPlans() {
        ArrayList<InsertRowPlan> insertRowPlans = new ArrayList<InsertRowPlan>();
        for (int i = 0; i < this.deviceIds.size(); ++i) {
            try {
                insertRowPlans.add(new InsertRowPlan(new PartialPath(this.deviceIds.get(i)), (long)this.times.get(i), this.measurementsList.get(i).toArray(new String[0]), DataTypeUtils.getValueBuffer(this.typesList.get(i), this.valuesList.get(i)), false));
                continue;
            }
            catch (IllegalPathException | QueryProcessException | IoTDBConnectionException e) {
                throw new InfluxDBException(e.getMessage());
            }
        }
        return insertRowPlans;
    }

    static {
        TAG_INFO_MEASUREMENTS.add("database_name");
        TAG_INFO_MEASUREMENTS.add("measurement_name");
        TAG_INFO_MEASUREMENTS.add("tag_name");
        TAG_INFO_MEASUREMENTS.add("tag_order");
        TAG_INFO_TYPES.add(TSDataType.TEXT);
        TAG_INFO_TYPES.add(TSDataType.TEXT);
        TAG_INFO_TYPES.add(TSDataType.TEXT);
        TAG_INFO_TYPES.add(TSDataType.INT32);
    }
}

