/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.logical.crud;

import org.apache.iotdb.db.exception.query.LogicalOperatorException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.qp.logical.crud.QueryOperator;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.qp.physical.crud.LastQueryPlan;
import org.apache.iotdb.db.qp.strategy.PhysicalGenerator;
import org.apache.iotdb.db.query.expression.Expression;
import org.apache.iotdb.db.query.expression.ResultColumn;
import org.apache.iotdb.db.query.expression.unary.TimeSeriesOperand;

public class LastQueryOperator
extends QueryOperator {
    public LastQueryOperator() {
    }

    public LastQueryOperator(QueryOperator queryOperator) {
        super(queryOperator);
    }

    @Override
    public void check() throws LogicalOperatorException {
        super.check();
        if (this.isAlignByDevice()) {
            throw new LogicalOperatorException("Last query doesn't support align by device.");
        }
        if (!this.isAlignByTime()) {
            throw new LogicalOperatorException("Disable align cannot be applied to LAST query.");
        }
        for (ResultColumn resultColumn : this.selectComponent.getResultColumns()) {
            Expression expression = resultColumn.getExpression();
            if (expression instanceof TimeSeriesOperand) continue;
            throw new LogicalOperatorException("Last queries can only be applied on raw time series.");
        }
    }

    @Override
    public PhysicalPlan generatePhysicalPlan(PhysicalGenerator generator) throws QueryProcessException {
        return super.generateRawDataQueryPlan(generator, new LastQueryPlan());
    }
}

