/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.udf.core.executor;

import java.time.ZoneId;
import java.util.Map;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.query.expression.Expression;
import org.apache.iotdb.db.query.expression.unary.FunctionExpression;
import org.apache.iotdb.db.query.udf.api.UDTF;
import org.apache.iotdb.db.query.udf.api.access.Row;
import org.apache.iotdb.db.query.udf.api.access.RowWindow;
import org.apache.iotdb.db.query.udf.api.collector.PointCollector;
import org.apache.iotdb.db.query.udf.api.customizer.config.UDTFConfigurations;
import org.apache.iotdb.db.query.udf.api.customizer.parameter.UDFParameterValidator;
import org.apache.iotdb.db.query.udf.api.customizer.parameter.UDFParameters;
import org.apache.iotdb.db.query.udf.datastructure.tv.ElasticSerializableTVList;
import org.apache.iotdb.db.query.udf.service.UDFRegistrationService;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UDTFExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(UDTFExecutor.class);
    protected final FunctionExpression expression;
    protected final UDTFConfigurations configurations;
    protected UDTF udtf;
    protected ElasticSerializableTVList collector;

    public UDTFExecutor(FunctionExpression expression, ZoneId zoneId) {
        this.expression = expression;
        this.configurations = new UDTFConfigurations(zoneId);
    }

    public void beforeStart(long queryId, float collectorMemoryBudgetInMB, Map<Expression, TSDataType> expressionDataTypeMap) throws QueryProcessException {
        this.udtf = (UDTF)UDFRegistrationService.getInstance().reflect(this.expression);
        UDFParameters parameters = new UDFParameters(this.expression, expressionDataTypeMap);
        try {
            this.udtf.validate(new UDFParameterValidator(parameters));
        }
        catch (Exception e) {
            this.onError("validate(UDFParameterValidator)", e);
        }
        try {
            this.udtf.beforeStart(parameters, this.configurations);
        }
        catch (Exception e) {
            this.onError("beforeStart(UDFParameters, UDTFConfigurations)", e);
        }
        this.configurations.check();
        this.collector = ElasticSerializableTVList.newElasticSerializableTVList(this.configurations.getOutputDataType(), queryId, collectorMemoryBudgetInMB, 1);
    }

    public void execute(Row row, boolean isCurrentRowNull) throws QueryProcessException {
        try {
            if (isCurrentRowNull) {
                this.collector.putNull(row.getTime());
            } else {
                this.udtf.transform(row, (PointCollector)this.collector);
            }
        }
        catch (Exception e) {
            this.onError("transform(Row, PointCollector)", e);
        }
    }

    public void execute(RowWindow rowWindow) throws QueryProcessException {
        try {
            this.udtf.transform(rowWindow, (PointCollector)this.collector);
        }
        catch (Exception e) {
            this.onError("transform(RowWindow, PointCollector)", e);
        }
    }

    public void terminate() throws QueryProcessException {
        try {
            this.udtf.terminate(this.collector);
        }
        catch (Exception e) {
            this.onError("terminate(PointCollector)", e);
        }
    }

    public void beforeDestroy() {
        if (this.udtf != null) {
            this.udtf.beforeDestroy();
        }
    }

    private void onError(String methodName, Exception e) throws QueryProcessException {
        LOGGER.warn("Error occurred during executing UDTF", (Throwable)e);
        throw new QueryProcessException(String.format("Error occurred during executing UDTF#%s: %s", methodName, System.lineSeparator()) + e);
    }

    public FunctionExpression getExpression() {
        return this.expression;
    }

    public UDTFConfigurations getConfigurations() {
        return this.configurations;
    }

    public ElasticSerializableTVList getCollector() {
        return this.collector;
    }
}

