/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.udf.core.transformer;

import java.io.IOException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.query.udf.core.reader.LayerPointReader;
import org.apache.iotdb.db.query.udf.core.transformer.Transformer;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;

public class TransparentTransformer
extends Transformer {
    private final LayerPointReader reader;

    public TransparentTransformer(LayerPointReader reader) {
        this.reader = reader;
    }

    @Override
    public boolean isConstantPointReader() {
        return false;
    }

    @Override
    public TSDataType getDataType() {
        return this.reader.getDataType();
    }

    @Override
    protected boolean cacheValue() throws QueryProcessException, IOException {
        if (!this.reader.next()) {
            return false;
        }
        if (this.reader.isCurrentNull()) {
            this.currentNull = true;
        } else {
            switch (this.reader.getDataType()) {
                case BOOLEAN: {
                    this.cachedBoolean = this.reader.currentBoolean();
                    break;
                }
                case DOUBLE: {
                    this.cachedDouble = this.reader.currentDouble();
                    break;
                }
                case FLOAT: {
                    this.cachedFloat = this.reader.currentFloat();
                    break;
                }
                case INT32: {
                    this.cachedInt = this.reader.currentInt();
                    break;
                }
                case INT64: {
                    this.cachedLong = this.reader.currentLong();
                    break;
                }
                case TEXT: {
                    this.cachedBinary = this.reader.currentBinary();
                    break;
                }
                default: {
                    throw new QueryProcessException("unsupported data type: " + this.reader.getDataType());
                }
            }
        }
        this.cachedTime = this.reader.currentTime();
        return true;
    }

    @Override
    public void readyForNext() {
        super.readyForNext();
        this.reader.readyForNext();
    }
}

