/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.sync.receiver.load;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.apache.iotdb.db.sync.receiver.load.ILoadLogger;

public class LoadLogger
implements ILoadLogger {
    private BufferedWriter bw;

    public LoadLogger(File logFile) throws IOException {
        if (!logFile.getParentFile().exists()) {
            logFile.getParentFile().mkdirs();
        }
        this.bw = new BufferedWriter(new FileWriter(logFile));
    }

    @Override
    public void startLoadDeletedFiles() throws IOException {
        this.bw.write("load deleted files start");
        this.bw.newLine();
        this.bw.flush();
    }

    @Override
    public void finishLoadDeletedFile(File file) throws IOException {
        this.bw.write(file.getAbsolutePath());
        this.bw.newLine();
        this.bw.flush();
    }

    @Override
    public void startLoadTsFiles() throws IOException {
        this.bw.write("load tsfile start");
        this.bw.newLine();
        this.bw.flush();
    }

    @Override
    public void finishLoadTsfile(File file) throws IOException {
        this.bw.write(file.getAbsolutePath());
        this.bw.newLine();
        this.bw.flush();
    }

    @Override
    public void close() throws IOException {
        if (this.bw != null) {
            this.bw.close();
            this.bw = null;
        }
    }
}

