/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils;

import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;

public class MathUtils {
    private MathUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static float roundWithGivenPrecision(float data, int size) {
        if (size == 0) {
            return Math.round(data);
        }
        return (float)Math.round(data) + (float)Math.round((double)(data - (float)Math.round(data)) * Math.pow(10.0, size)) / (float)Math.pow(10.0, size);
    }

    public static float roundWithGivenPrecision(float data) {
        if (TSFileDescriptor.getInstance().getConfig().getFloatPrecision() == 0) {
            return Math.round(data);
        }
        return (float)Math.round(data) + (float)Math.round((data - (float)Math.round(data)) * (float)Math.pow(10.0, TSFileDescriptor.getInstance().getConfig().getFloatPrecision())) / (float)Math.pow(10.0, TSFileDescriptor.getInstance().getConfig().getFloatPrecision());
    }

    public static double roundWithGivenPrecision(double data, int size) {
        if (size == 0) {
            return Math.round(data);
        }
        return (double)Math.round(data) + (double)Math.round((data - (double)Math.round(data)) * Math.pow(10.0, size)) / Math.pow(10.0, size);
    }

    public static double roundWithGivenPrecision(double data) {
        if (TSFileDescriptor.getInstance().getConfig().getFloatPrecision() == 0) {
            return Math.round(data);
        }
        return (double)Math.round(data) + (double)Math.round((data - (double)Math.round(data)) * Math.pow(10.0, TSFileDescriptor.getInstance().getConfig().getFloatPrecision())) / Math.pow(10.0, TSFileDescriptor.getInstance().getConfig().getFloatPrecision());
    }
}

