/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.client;

import java.time.Duration;
import org.apache.commons.pool2.KeyedPooledObjectFactory;
import org.apache.commons.pool2.impl.GenericKeyedObjectPool;
import org.apache.commons.pool2.impl.GenericKeyedObjectPoolConfig;
import org.apache.iotdb.cluster.client.ClientCategory;
import org.apache.iotdb.cluster.client.IClientManager;
import org.apache.iotdb.cluster.client.async.AsyncDataClient;
import org.apache.iotdb.cluster.client.async.AsyncMetaClient;
import org.apache.iotdb.cluster.client.sync.SyncDataClient;
import org.apache.iotdb.cluster.client.sync.SyncMetaClient;
import org.apache.iotdb.cluster.config.ClusterConfig;
import org.apache.iotdb.cluster.config.ClusterDescriptor;
import org.apache.iotdb.cluster.rpc.thrift.Node;
import org.apache.iotdb.cluster.rpc.thrift.RaftService;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TProtocolFactory;

public class ClientPoolFactory {
    protected long waitClientTimeoutMS;
    protected int maxConnectionForEachNode;
    protected int maxIdleConnectionForEachNode;
    private final TProtocolFactory protocolFactory;
    private GenericKeyedObjectPoolConfig poolConfig;
    private IClientManager clientManager;

    public ClientPoolFactory() {
        ClusterConfig config = ClusterDescriptor.getInstance().getConfig();
        this.waitClientTimeoutMS = config.getWaitClientTimeoutMS();
        this.maxConnectionForEachNode = config.getMaxClientPerNodePerMember();
        this.maxIdleConnectionForEachNode = config.getMaxIdleClientPerNodePerMember();
        this.protocolFactory = config.isRpcThriftCompressionEnabled() ? new TCompactProtocol.Factory() : new TBinaryProtocol.Factory();
        this.poolConfig = new GenericKeyedObjectPoolConfig();
        this.poolConfig.setMaxTotalPerKey(this.maxConnectionForEachNode);
        this.poolConfig.setMaxIdlePerKey(this.maxIdleConnectionForEachNode);
        this.poolConfig.setMaxWait(Duration.ofMillis(this.waitClientTimeoutMS));
        this.poolConfig.setTestOnReturn(true);
        this.poolConfig.setTestOnBorrow(true);
    }

    public void setClientManager(IClientManager clientManager) {
        this.clientManager = clientManager;
    }

    public GenericKeyedObjectPool<Node, RaftService.Client> createSyncDataPool(ClientCategory category) {
        return new GenericKeyedObjectPool((KeyedPooledObjectFactory)new SyncDataClient.SyncDataClientFactory(this.protocolFactory, category, this.clientManager), this.poolConfig);
    }

    public GenericKeyedObjectPool<Node, RaftService.Client> createSyncMetaPool(ClientCategory category) {
        return new GenericKeyedObjectPool((KeyedPooledObjectFactory)new SyncMetaClient.SyncMetaClientFactory(this.protocolFactory, category, this.clientManager), this.poolConfig);
    }

    public GenericKeyedObjectPool<Node, RaftService.AsyncClient> createAsyncDataPool(ClientCategory category) {
        return new GenericKeyedObjectPool((KeyedPooledObjectFactory)new AsyncDataClient.AsyncDataClientFactory(this.protocolFactory, category, this.clientManager), this.poolConfig);
    }

    public GenericKeyedObjectPool<Node, RaftService.AsyncClient> createAsyncMetaPool(ClientCategory category) {
        return new GenericKeyedObjectPool((KeyedPooledObjectFactory)new AsyncMetaClient.AsyncMetaClientFactory(this.protocolFactory, category, this.clientManager), this.poolConfig);
    }

    public GenericKeyedObjectPool<Node, RaftService.AsyncClient> createSingleManagerAsyncDataPool() {
        return new GenericKeyedObjectPool((KeyedPooledObjectFactory)new AsyncDataClient.SingleManagerFactory(this.protocolFactory, this.clientManager), this.poolConfig);
    }
}

